/*
 * Decompiled with CFR 0.152.
 */
package dexlogic;

import dexlogic.idnFileCheck.FileCheck;
import dexlogic.idnFileCheck.TestEnvironment;
import dexlogic.idnFileCheck.TestException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class IDNFileChecker {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        boolean bl = false;
        File file = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        System.out.println("IDN-File format checker v0.2");
        System.out.println();
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("-l")) {
                    bl2 = true;
                    continue;
                }
                if (stringArray[i].equals("-s")) {
                    bl3 = true;
                    continue;
                }
                if (stringArray[i].equals("-v")) {
                    bl4 = true;
                    continue;
                }
                if (stringArray[i].length() == 0 || stringArray[i].charAt(0) == '-') {
                    bl = true;
                } else if (file != null || stringArray[i].length() == 0) {
                    bl = true;
                } else {
                    file = new File(stringArray[i]);
                    if (file.exists()) continue;
                    bl = true;
                }
                break;
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            bl = true;
        }
        if (bl || file == null) {
            System.out.println("USAGE: java IDNFileChecker { Options } filename");
            System.out.println("Options:");
            System.out.println("  -l   locator check, verify all locator entries");
            System.out.println("  -s   stream check, verify messages (may take longer)");
            System.out.println("  -v   verbose mode, print processing details");
            System.out.println();
            return;
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            TestEnvironment testEnvironment = new TestEnvironment(randomAccessFile, bl4);
            testEnvironment.setLocatorCheck(bl2);
            FileCheck fileCheck = new FileCheck(testEnvironment);
            fileCheck.checkIntegrity(testEnvironment);
            if (bl4) {
                System.out.printf("\n", new Object[0]);
            }
            System.out.println("IDN-File integrity check passed");
            System.out.println();
        }
        catch (TestException testException) {
            System.out.printf("\n", new Object[0]);
            System.out.println(testException.getMessage());
            System.out.printf("\n", new Object[0]);
        }
        catch (IOException iOException) {
            System.out.printf("\n", new Object[0]);
            iOException.printStackTrace();
            System.out.printf("\n", new Object[0]);
        }
        finally {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

