/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.dxc;

import dexlogic.dxc.DXCException;
import dexlogic.dxc.DXCListener;
import dexlogic.tools.JNILoader;
import java.io.IOException;
import java.lang.ref.Cleaner;
import java.util.Set;
import java.util.WeakHashMap;

public class DXCManager
implements AutoCloseable {
    private long mgr = 0L;
    private final CleanupAction cleanupAction = new CleanupAction();
    private final Cleaner.Cleanable cleanable = cleaner.register(this, this.cleanupAction);
    private static final Cleaner cleaner = Cleaner.create();
    private static final WeakHashMap<Cleaner.Cleanable, Object> shutdownQueue = new WeakHashMap();
    public static final int DXC_LOG_OUTPUT_MASK = 0xF000000;
    public static final int DXC_LOG_OUTPUT_DISABLED = 0;
    public static final int DXC_LOG_OUTPUT_CONSOLE = 0x1000000;
    public static final int DXC_LOG_OUTPUT_PICKUP = 0x2000000;
    public static final int DXC_LOG_CONSOLE_MASK = 983040;
    public static final int DXC_LOG_CONSOLE_PLAIN = 0;
    public static final int DXC_LOG_CONSOLE_ANSI = 65536;
    public static final int DXC_LOG_LEVEL_MASK = 255;
    public static final int DXC_LOG_LEVEL_QUIET = 0;
    public static final int DXC_LOG_LEVEL_FATAL = 18;
    public static final int DXC_LOG_LEVEL_ERROR = 20;
    public static final int DXC_LOG_LEVEL_WARNING = 22;
    public static final int DXC_LOG_LEVEL_INFO = 24;
    public static final int DXC_LOG_LEVEL_DEBUG = 26;
    public static final int DXC_LOG_LEVEL_ALL = 255;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DXCManager(int n) {
        Class<DXCManager> clazz = DXCManager.class;
        synchronized (DXCManager.class) {
            shutdownQueue.put(this.cleanable, null);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.mgr = DXCManager.createManager(n);
            if (this.mgr == 0L) {
                clazz = DXCManager.class;
                synchronized (DXCManager.class) {
                    shutdownQueue.remove(this.cleanable);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    throw new RuntimeException("Failed to create native object");
                }
            }
            this.cleanupAction.mgr = this.mgr;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void close() {
        if (this.cleanable != null) {
            this.cleanable.clean();
            Class<DXCManager> clazz = DXCManager.class;
            // MONITORENTER : dexlogic.dxc.DXCManager.class
            shutdownQueue.remove(this.cleanable);
            // MONITOREXIT : clazz
        }
        this.mgr = 0L;
    }

    public native void reset();

    public native boolean runDispatch(DXCListener var1, Object var2);

    public native long buildFromXML(String var1) throws DXCException;

    public native String remotePost(int var1, String var2) throws DXCException;

    public native void play(String var1) throws DXCException;

    public native void pause(String var1) throws DXCException;

    public native void preload(String var1) throws DXCException;

    public native void seek(int var1, String var2) throws DXCException;

    public native void idle(String var1);

    private static native int classInit();

    private static native long createManager(int var0);

    private static native void destroyManager(long var0);

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<DXCManager> clazz = DXCManager.class;
                synchronized (DXCManager.class) {
                    Set<Cleaner.Cleanable> set = shutdownQueue.keySet();
                    for (Cleaner.Cleanable cleanable : set) {
                        if (cleanable == null) continue;
                        cleanable.clean();
                        shutdownQueue.remove(cleanable);
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
        try {
            JNILoader.loadLibrary("DexConnect");
            if (DXCManager.classInit() < 0) {
                throw new IOException("DXCManager class initialization failed");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static class CleanupAction
    implements Runnable {
        long mgr = 0L;

        CleanupAction() {
        }

        @Override
        public void run() {
            if (this.mgr != 0L) {
                DXCManager.destroyManager(this.mgr);
            }
            this.mgr = 0L;
        }
    }
}

