/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.idnFileCheck;

import dexlogic.idnFileCheck.IDNFile64Anchor;
import dexlogic.idnFileCheck.TestEnvironment;
import dexlogic.idnFileCheck.TestException;
import dexlogic.idnFileCheck.TestScope;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class FileCheck {
    long fileLength;
    String title;
    int fmtCode;
    int verCode;
    long creationDateUTC;
    String creationDate;

    public FileCheck(TestEnvironment testEnvironment) throws TestException {
        TestScope testScope = new TestScope("Header", new Object[0]);
        testScope.setAction("file length", new Object[0]);
        this.fileLength = testEnvironment.getFileLength(testScope);
        if (this.fileLength < 80L) {
            throw new TestException(testScope, "Invalid file length: %d", this.fileLength);
        }
        testScope.setAction("signature", new Object[0]);
        testEnvironment.seek(testScope, 0L);
        int n = testEnvironment.readUnsignedByte(testScope);
        int n2 = testEnvironment.readUnsignedByte(testScope);
        int n3 = testEnvironment.readUnsignedByte(testScope);
        int n4 = testEnvironment.readUnsignedByte(testScope);
        if (n != 73 || n2 != 68 || n3 != 78 || n4 != 58) {
            throw new TestException(testScope, "Invalid signature: 0x%02X 0x%02X 0x%02X 0x%02X", n, n2, n3, n4);
        }
        testScope.setAction("title", new Object[0]);
        this.title = testEnvironment.readStringField(testScope, 60);
        if (testEnvironment.verboseMode) {
            System.out.printf("Title: %s\n", this.title);
        }
        testScope.setAction("delimiter", new Object[0]);
        int n5 = testEnvironment.readUnsignedByte(testScope);
        int n6 = testEnvironment.readUnsignedByte(testScope);
        if (n5 != 26 || n6 != 26) {
            throw new TestException(testScope, "Invalid delimiter: 0x%02X 0x%02X", n5, n6);
        }
        testScope.setAction("format/version", new Object[0]);
        this.fmtCode = testEnvironment.readUnsignedByte(testScope);
        this.verCode = testEnvironment.readUnsignedByte(testScope);
        if (this.fmtCode == 1 && this.verCode == 1) {
            if (this.fileLength < 128L) {
                throw new TestException(testScope, "Invalid file length: %d, format=0x%02X, version=0x%02X", this.fileLength, this.fmtCode, this.verCode);
            }
        } else {
            throw new TestException(testScope, "Unknown file structure, format=0x%02X, version=0x%02X", this.fmtCode, this.verCode);
        }
        testScope.setAction(null, new Object[0]);
        testEnvironment.checkReserved(testScope, 0L, 4);
        testScope.setAction("creation date", new Object[0]);
        this.creationDateUTC = testEnvironment.readLong(testScope);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.creationDate = simpleDateFormat.format(new Date(this.creationDateUTC));
        if (testEnvironment.verboseMode) {
            System.out.printf("Creation(UTC): %s, format %d, version %d\n", this.creationDate, this.fmtCode, this.verCode);
        }
        testScope.setAction(null, new Object[0]);
        testEnvironment.checkOffset(testScope, 0L, 80L);
    }

    public void checkIntegrity(TestEnvironment testEnvironment) throws TestException {
        TestScope testScope = new TestScope("HeaderExt", new Object[0]);
        testEnvironment.fmtCode = this.fmtCode;
        testEnvironment.verCode = this.verCode;
        if (this.fmtCode == 1 && this.verCode == 1) {
            testEnvironment.seek(testScope, 80L);
            testScope.setAction("properties FP", new Object[0]);
            long l = testEnvironment.readFP(testScope);
            testScope.setAction("editor FP", new Object[0]);
            long l2 = testEnvironment.readFP(testScope);
            testScope.setAction("first anchor FP", new Object[0]);
            long l3 = testEnvironment.readFP(testScope);
            testScope.setAction("free list FP", new Object[0]);
            long l4 = testEnvironment.readFP(testScope);
            testScope.setAction(null, new Object[0]);
            testEnvironment.checkReserved(testScope, 0L, 8);
            testScope.setAction(null, new Object[0]);
            testEnvironment.checkReserved(testScope, 0L, 8);
            testScope.setAction(null, new Object[0]);
            testEnvironment.checkOffset(testScope, 0L, 128L);
            testScope.setAction(null, new Object[0]);
            long l5 = l3;
            int n = 1;
            while (l5 != 0L) {
                IDNFile64Anchor iDNFile64Anchor = new IDNFile64Anchor(testEnvironment, l5, n);
                if (iDNFile64Anchor.movieFirstFP != 0L) {
                    iDNFile64Anchor.checkMovie(testEnvironment);
                }
                l5 = iDNFile64Anchor.nextAnchorFP;
                ++n;
            }
        } else {
            testEnvironment.fmtCode = 0;
            testEnvironment.verCode = 0;
            throw new TestException(testScope, "Unknown file structure, format=0x%02X, version=0x%02X", this.fmtCode, this.verCode);
        }
    }
}

