/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.idnFileCheck;

import dexlogic.idnFileCheck.Channel;
import dexlogic.idnFileCheck.TestEnvironment;
import dexlogic.idnFileCheck.TestException;
import dexlogic.idnFileCheck.TestScope;
import dexlogic.idnFileCheck.TestTools;
import java.util.Arrays;

public class IDNChannelMessage {
    int totalSize;
    int contentID;
    int channelID;
    int chunkType;
    int[] configWords;
    int configFlags;
    int configServiceID;
    int configServiceMode;
    long chunkFP;
    long messageFP;
    int timestamp;

    public IDNChannelMessage(TestEnvironment testEnvironment, TestScope testScope, long l) throws TestException {
        this.messageFP = l;
        testScope = new TestScope(testScope, "ChannelMessage FP(0x%s)", TestTools.toFPHexString(l));
        testScope.setAction("message header", new Object[0]);
        testEnvironment.seek(testScope, l);
        this.totalSize = testEnvironment.readUnsignedShort(testScope);
        this.contentID = testEnvironment.readUnsignedShort(testScope);
        this.timestamp = testEnvironment.readInt(testScope);
        if ((this.contentID & 0x8000) == 0) {
            throw new TestException(testScope, "Invalid contentID 0x%04X", this.contentID);
        }
        this.chunkFP = testEnvironment.tell(testScope);
        this.channelID = (this.contentID & 0x3F00) >> 8;
        this.chunkType = this.contentID & 0xFF;
        if (this.chunkType <= 191 && (this.contentID & 0x4000) != 0) {
            this.configWords = new int[testEnvironment.readUnsignedByte(testScope)];
            this.configFlags = testEnvironment.readUnsignedByte(testScope);
            this.configServiceID = testEnvironment.readUnsignedByte(testScope);
            this.configServiceMode = testEnvironment.readUnsignedByte(testScope);
            for (int i = 0; i < this.configWords.length; ++i) {
                this.configWords[i] = testEnvironment.readInt(testScope);
            }
            this.chunkFP = testEnvironment.tell(testScope);
        }
    }

    public void checkMessage(TestEnvironment testEnvironment, TestScope testScope, long l, Channel[] channelArray) throws TestException {
        int n;
        testScope = new TestScope(testScope, "ChannelMessage FP(0x%s)", TestTools.toFPHexString(this.messageFP));
        if (l > 0L && (n = (int)((long)this.timestamp - l)) < 0) {
            throw new TestException(testScope, "Timestamp decrementing", new Object[0]);
        }
        Channel channel = channelArray[this.channelID];
        if (channel == null) {
            channel = channelArray[this.channelID] = new Channel();
            if ((this.configFlags & 1) == 0) {
                System.out.printf("  ChannelMessage 0x%s: Message on closed channel, channelID=%d\n", TestTools.toFPHexString(this.messageFP), this.channelID);
            }
        }
        if (!((this.configFlags & 1) == 0 || channel.connectedFlag && channel.serviceID == this.configServiceID && channel.serviceMode == this.configServiceMode)) {
            if (channel.connectedFlag) {
                channel.serviceID = 0;
                channel.serviceMode = 0;
                channel.connectedFlag = false;
            }
            channel.serviceID = this.configServiceID;
            channel.serviceMode = this.configServiceMode;
            channel.connectedFlag = true;
            if (testEnvironment.verboseMode) {
                System.out.printf("  ChannelMessage 0x%s: Channel %d connect, serviceID=%d, serviceMode=0x%02X\n", TestTools.toFPHexString(this.messageFP), this.channelID, this.configServiceID, this.configServiceMode);
            }
        }
        if (channel.connectedFlag && (this.configFlags & 1) != 0 && (channel.configWords == null || Arrays.compare(channel.configWords, this.configWords) != 0)) {
            channel.configWords = this.configWords;
            if (testEnvironment.verboseMode) {
                System.out.printf("  ChannelMessage 0x%s: Channel %d config", TestTools.toFPHexString(this.messageFP), this.channelID);
                for (int i = 0; i < this.configWords.length; ++i) {
                    System.out.printf(" %08X", this.configWords[i]);
                }
                System.out.printf("\n", new Object[0]);
            }
        }
        if ((this.configFlags & 2) != 0) {
            channelArray[this.channelID] = null;
            if (testEnvironment.verboseMode) {
                System.out.printf("  ChannelMessage 0x%s: Channel %d close\n", TestTools.toFPHexString(this.messageFP), this.channelID);
            }
        }
    }
}

