/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.idnFileCheck;

import dexlogic.idnFileCheck.TestException;
import dexlogic.idnFileCheck.TestScope;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;

public class TestEnvironment {
    RandomAccessFile file;
    int fmtCode;
    int verCode;
    boolean verboseMode;
    boolean locatorCheckFlag;
    boolean streamCheckFlag;

    public TestEnvironment(RandomAccessFile randomAccessFile, boolean bl) {
        this.file = randomAccessFile;
        this.verboseMode = bl;
    }

    public void setLocatorCheck(boolean bl) {
        this.locatorCheckFlag = bl;
    }

    public boolean getLocatorCheck() {
        return this.locatorCheckFlag;
    }

    public void setStreamCheck(boolean bl) {
        this.streamCheckFlag = bl;
    }

    public boolean getStreamCheck() {
        return this.streamCheckFlag;
    }

    public void checkReserved(TestScope testScope, long l, int n) throws TestException {
        testScope = new TestScope(testScope);
        long l2 = 0L;
        try {
            l2 = this.file.getFilePointer() - l;
            testScope.setAction("reserved(0x%04X, %d)", l2, n);
            for (int i = 0; i < n; ++i) {
                int n2 = this.file.readUnsignedByte();
                if (n2 == 0) continue;
                throw new TestException(testScope, "Invalid value %02X", n2);
            }
        }
        catch (IOException iOException) {
            throw new TestException(testScope, iOException.toString(), new Object[0]);
        }
    }

    public void checkOffset(TestScope testScope, long l, long l2) throws TestException {
        testScope = new TestScope(testScope);
        long l3 = 0L;
        try {
            l3 = this.file.getFilePointer() - l;
            testScope.setAction("offset check", new Object[0]);
            if (l3 != l2) {
                throw new TestException(testScope, "Position mismatch, offset=0x%04X, expected=0x%04X", l3, l2);
            }
        }
        catch (IOException iOException) {
            throw new TestException(testScope, iOException.toString(), new Object[0]);
        }
    }

    public long getFileLength(TestScope testScope) throws TestException {
        try {
            return this.file.length();
        }
        catch (IOException iOException) {
            throw new TestException(testScope, iOException.toString(), new Object[0]);
        }
    }

    public void seek(TestScope testScope, long l) throws TestException {
        try {
            this.file.seek(l);
        }
        catch (IOException iOException) {
            throw new TestException(testScope, iOException.toString(), new Object[0]);
        }
    }

    public long tell(TestScope testScope) throws TestException {
        try {
            return this.file.getFilePointer();
        }
        catch (IOException iOException) {
            throw new TestException(testScope, iOException.toString(), new Object[0]);
        }
    }

    public int readUnsignedByte(TestScope testScope) throws TestException {
        try {
            return this.file.readUnsignedByte();
        }
        catch (IOException iOException) {
            throw new TestException(testScope, iOException.toString(), new Object[0]);
        }
    }

    public int readUnsignedShort(TestScope testScope) throws TestException {
        try {
            return this.file.readUnsignedShort();
        }
        catch (IOException iOException) {
            throw new TestException(testScope, iOException.toString(), new Object[0]);
        }
    }

    public int readInt(TestScope testScope) throws TestException {
        try {
            return this.file.readInt();
        }
        catch (IOException iOException) {
            throw new TestException(testScope, iOException.toString(), new Object[0]);
        }
    }

    public long readLong(TestScope testScope) throws TestException {
        try {
            return this.file.readLong();
        }
        catch (IOException iOException) {
            throw new TestException(testScope, iOException.toString(), new Object[0]);
        }
    }

    public long readFP(TestScope testScope) throws TestException {
        try {
            return this.file.readLong();
        }
        catch (IOException iOException) {
            throw new TestException(testScope, iOException.toString(), new Object[0]);
        }
    }

    public void readFully(TestScope testScope, byte[] byArray) throws TestException {
        try {
            this.file.readFully(byArray);
        }
        catch (IOException iOException) {
            throw new TestException(testScope, iOException.toString(), new Object[0]);
        }
    }

    public String readStringField(TestScope testScope, int n) throws TestException {
        byte[] byArray = new byte[n];
        try {
            int n2;
            this.file.readFully(byArray);
            for (n2 = byArray.length; n2 > 0 && byArray[n2 - 1] <= 32; --n2) {
            }
            return new String(byArray, 0, n2, StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            throw new TestException(testScope, iOException.toString(), new Object[0]);
        }
    }
}

