/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.dln;

import dexlogic.io.dln.DLNUnitID;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class DLNTools {
    public static String readStringField(ByteBuffer byteBuffer, int n) {
        int n2;
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        for (n2 = n; n2 > 0 && byArray[n2 - 1] <= 32; --n2) {
        }
        for (int i = 0; i < n2; ++i) {
            if (byArray[i] != 0) continue;
            n2 = i;
            break;
        }
        String string = null;
        if (n2 != 0) {
            string = new String(byArray, 0, n2, StandardCharsets.UTF_8);
        }
        return string;
    }

    public static DLNUnitID readUnitIDField(ByteBuffer byteBuffer, int n) {
        int n2;
        if (n < 1) {
            throw new IllegalArgumentException("Invalid field size " + n);
        }
        int n3 = byteBuffer.get() & 0xFF;
        if (n3 > --n) {
            return null;
        }
        byte[] byArray = new byte[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            byArray[n2] = byteBuffer.get();
        }
        for (n2 = n3; n2 < n; ++n2) {
            byteBuffer.get();
        }
        return new DLNUnitID(byArray);
    }

    public static void writeByteField(ByteBuffer byteBuffer, byte[] byArray, int n) {
        if (byArray != null) {
            int n2 = byArray.length;
            for (int i = 0; i < n2 && n > 0; ++i, --n) {
                byteBuffer.put(byArray[i]);
            }
        }
        while (n > 0) {
            byteBuffer.put((byte)0);
            --n;
        }
    }

    public static void writeStringField(ByteBuffer byteBuffer, String string, int n) {
        byte[] byArray = null;
        while (true) {
            if (string != null) {
                byArray = string.getBytes(StandardCharsets.UTF_8);
            }
            if (byArray == null || byArray.length < n) break;
            byArray = null;
            string = string.substring(0, string.length() - 1);
        }
        DLNTools.writeByteField(byteBuffer, byArray, n);
    }

    public static void writeUnitIDField(ByteBuffer byteBuffer, DLNUnitID dLNUnitID, int n) {
        byte[] byArray;
        byte[] byArray2 = byArray = dLNUnitID != null ? dLNUnitID.getIDBytes() : null;
        if (byArray != null && n <= byArray.length + 1) {
            throw new IllegalArgumentException("UnitID too long " + byArray.length);
        }
        if (byArray == null) {
            while (n > 0) {
                byteBuffer.put((byte)0);
                --n;
            }
        } else {
            byteBuffer.put((byte)byArray.length);
            DLNTools.writeByteField(byteBuffer, byArray, --n);
        }
    }
}

