/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.dln.packets;

import dexlogic.io.dln.DLNDataException;
import dexlogic.io.dln.DLNDrainSet;
import dexlogic.io.dln.packets.DLNPacket;
import java.nio.ByteBuffer;
import java.util.Iterator;

public class DLNDrainRouteReqPacket
extends DLNPacket {
    private DLNDrainSet drainSet = null;

    @Override
    protected void resetMembers() {
        super.resetMembers();
        this.drainSet = null;
    }

    @Override
    protected void readBytes(ByteBuffer byteBuffer) throws DLNDataException {
        super.readBytes(byteBuffer);
        throw new DLNDataException("Not implemented");
    }

    @Override
    protected void writeBytes(ByteBuffer byteBuffer) throws DLNDataException {
        super.writeBytes(byteBuffer);
        int n = this.drainSet.getRouteCount();
        if (n > 1) {
            byteBuffer.put((byte)4);
            byteBuffer.put((byte)n);
            byteBuffer.putShort((short)0);
        }
        Iterator<DLNDrainSet.RouteEntry> iterator = this.drainSet.routeIterator();
        while (iterator.hasNext()) {
            DLNDrainSet.RouteEntry routeEntry = iterator.next();
            byteBuffer.put((byte)28);
            byteBuffer.put((byte)routeEntry.cmd);
            byteBuffer.put((byte)routeEntry.flags);
            byteBuffer.put((byte)routeEntry.captureID);
            byteBuffer.put((byte)routeEntry.serviceID);
            byteBuffer.put((byte)routeEntry.bridgeType);
            byteBuffer.putShort((short)routeEntry.port);
            byte[] byArray = routeEntry.address;
            for (int i = 0; i < 20; ++i) {
                if (byArray != null && i < byArray.length) {
                    byteBuffer.put(byArray[i]);
                    continue;
                }
                byteBuffer.put((byte)0);
            }
        }
        byteBuffer.mark();
    }

    public DLNDrainRouteReqPacket() {
        super(120);
    }

    public void setDrainSet(DLNDrainSet dLNDrainSet) {
        this.drainSet = dLNDrainSet;
    }

    public DLNDrainSet getDrainSet() {
        return this.drainSet;
    }

    @Override
    public String toString() {
        return String.format("DLNDrainRouteReqPacket", new Object[0]);
    }
}

