/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.dln.packets;

import dexlogic.io.dln.DLNDataException;
import dexlogic.io.dln.packets.DLNPacket;
import java.nio.ByteBuffer;

public class DLNDrainRouteRspPacket
extends DLNPacket {
    private int rteResult;

    @Override
    protected void resetMembers() {
        super.resetMembers();
        this.rteResult = 0;
    }

    @Override
    protected void readBytes(ByteBuffer byteBuffer) throws DLNDataException {
        super.readBytes(byteBuffer);
        if (byteBuffer.remaining() < 1) {
            throw new DLNDataException("Drain route response: Invalid length");
        }
        int n = byteBuffer.get(byteBuffer.position()) & 0xFF;
        if (n != 4) {
            throw new DLNDataException("Drain route response: Invalid header size " + n);
        }
        if (byteBuffer.remaining() < n) {
            throw new DLNDataException("Drain route response: Invalid packet size " + byteBuffer.remaining() + " < " + n);
        }
        byteBuffer.position(byteBuffer.position() + 1);
        this.rteResult = byteBuffer.get() & 0xFF;
        int n2 = byteBuffer.get() & 0xFF;
        int n3 = byteBuffer.get() & 0xFF;
        byteBuffer.mark();
    }

    @Override
    protected void writeBytes(ByteBuffer byteBuffer) throws DLNDataException {
        super.writeBytes(byteBuffer);
        throw new DLNDataException("Not implemented");
    }

    public DLNDrainRouteRspPacket() {
        super(121);
    }

    public void setResult(int n) {
        this.rteResult = n;
    }

    public int getResult() {
        return this.rteResult;
    }

    @Override
    public String toString() {
        return String.format("DLNDrainRouteRspPacket", new Object[0]);
    }
}

