/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.dln.packets;

import dexlogic.io.dln.DLNDataException;
import dexlogic.io.dln.DLNTools;
import dexlogic.io.dln.DLNUnitID;
import dexlogic.io.dln.packets.DLNPacket;
import java.nio.ByteBuffer;

public class DLNFeedScanRspPacket
extends DLNPacket {
    private int idnClientGroup;
    private DLNUnitID unitID;
    private String hostName;

    @Override
    protected void resetMembers() {
        super.resetMembers();
        this.idnClientGroup = 0;
        this.unitID = null;
        this.hostName = null;
    }

    @Override
    protected void readBytes(ByteBuffer byteBuffer) throws DLNDataException {
        super.readBytes(byteBuffer);
        if (byteBuffer.remaining() < 1) {
            throw new DLNDataException("Scan response: Invalid length");
        }
        int n = byteBuffer.get(byteBuffer.position()) & 0xFF;
        if (n != 40) {
            throw new DLNDataException("Scan response: Invalid header size " + n);
        }
        if (byteBuffer.remaining() < n) {
            throw new DLNDataException("Scan response: Invalid packet size " + byteBuffer.remaining() + " < " + n);
        }
        byteBuffer.position(byteBuffer.position() + 1);
        int n2 = byteBuffer.get() & 0xFF;
        int n3 = byteBuffer.get() & 0xFF;
        int n4 = byteBuffer.get() & 0xFF;
        this.unitID = DLNTools.readUnitIDField(byteBuffer, 16);
        this.hostName = DLNTools.readStringField(byteBuffer, 20);
        this.idnClientGroup = n2 >= 2 ? n4 & 0xF : -1;
        byteBuffer.mark();
    }

    @Override
    protected void writeBytes(ByteBuffer byteBuffer) throws DLNDataException {
        super.writeBytes(byteBuffer);
        if (this.idnClientGroup >= 0) {
            byte by = 0;
            byte by2 = (byte)(this.idnClientGroup & 0xF);
            byteBuffer.put((byte)40);
            byteBuffer.put((byte)2);
            byteBuffer.put(by);
            byteBuffer.put(by2);
            DLNTools.writeUnitIDField(byteBuffer, this.unitID, 16);
            DLNTools.writeStringField(byteBuffer, this.hostName, 20);
        } else {
            byteBuffer.put((byte)40);
            byteBuffer.put((byte)1);
            byteBuffer.putShort((short)0);
            DLNTools.writeUnitIDField(byteBuffer, this.unitID, 16);
            DLNTools.writeStringField(byteBuffer, this.hostName, 20);
        }
        byteBuffer.mark();
    }

    public DLNFeedScanRspPacket() {
        super(17);
        this.unitID = this.unitID;
    }

    public void setUnitID(DLNUnitID dLNUnitID) {
        this.unitID = dLNUnitID;
    }

    public DLNUnitID getUnitID() {
        return this.unitID;
    }

    public void setHostName(String string) {
        this.hostName = string;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setIDNClientGroup(int n) {
        if (n < 0 || n > 15) {
            throw new IllegalArgumentException("Client group argument must be in range 0..15");
        }
        this.idnClientGroup = n;
    }

    public int getIDNClientGroup() {
        return this.idnClientGroup;
    }

    @Override
    public String toString() {
        return String.format("DLNScanRspPacket", new Object[0]);
    }
}

