/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.dln.packets;

import dexlogic.io.dln.DLNDataException;
import dexlogic.io.dln.packets.DLNPacket;
import dexlogic.io.idn.IDNTools;
import dexlogic.io.idn.IDNUnitID;
import java.nio.ByteBuffer;

public class DLNScanRspPacket
extends DLNPacket {
    private IDNUnitID unitID;
    private String hostName;

    @Override
    protected void resetMembers() {
        super.resetMembers();
        this.unitID = null;
        this.hostName = null;
    }

    @Override
    protected void readBytes(ByteBuffer byteBuffer) throws DLNDataException {
        super.readBytes(byteBuffer);
        if (byteBuffer.remaining() < 1) {
            throw new DLNDataException("Scan response: Invalid length");
        }
        int n = byteBuffer.get(byteBuffer.position()) & 0xFF;
        if (n != 40) {
            throw new DLNDataException("Scan response: Invalid header size " + n);
        }
        if (byteBuffer.remaining() < n) {
            throw new DLNDataException("Scan response: Invalid packet size " + byteBuffer.remaining() + " < " + n);
        }
        byteBuffer.position(byteBuffer.position() + 1);
        int n2 = byteBuffer.get() & 0xFF;
        int n3 = byteBuffer.getShort() & 0xFFFF;
        this.unitID = IDNTools.readUnitIDField(byteBuffer, 16);
        this.hostName = IDNTools.readStringField(byteBuffer, 20);
        byteBuffer.mark();
    }

    @Override
    protected void writeBytes(ByteBuffer byteBuffer) throws DLNDataException {
        super.writeBytes(byteBuffer);
        byteBuffer.put((byte)40);
        byteBuffer.put((byte)0);
        byteBuffer.putShort((short)0);
        IDNTools.writeUnitIDField(byteBuffer, this.unitID, 16);
        IDNTools.writeStringField(byteBuffer, this.hostName, 20);
        byteBuffer.mark();
    }

    public DLNScanRspPacket() {
        super(17);
        this.unitID = this.unitID;
    }

    public void setUnitID(IDNUnitID iDNUnitID) {
        this.unitID = iDNUnitID;
    }

    public IDNUnitID getUnitID() {
        return this.unitID;
    }

    public void setHostName(String string) {
        this.hostName = string;
    }

    public String getHostName() {
        return this.hostName;
    }

    @Override
    public String toString() {
        return String.format("DLNScanRspPacket", new Object[0]);
    }
}

