/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.idn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class IDNServiceMap {
    private ArrayList<RelayEntry> relayEntries = new ArrayList();
    private ArrayList<ServiceEntry> serviceEntries = new ArrayList();

    public void addRelayEntry(RelayEntry relayEntry) {
        relayEntry.firstRelayService = null;
        this.relayEntries.add(relayEntry);
    }

    public int addServiceEntry(ServiceEntry serviceEntry, int n) {
        serviceEntry.parentRelay = null;
        serviceEntry.nextRelayService = null;
        this.serviceEntries.add(serviceEntry);
        if (n == 0) {
            return 0;
        }
        int n2 = this.relayEntries.size();
        for (int i = 0; i < n2; ++i) {
            RelayEntry relayEntry = this.relayEntries.get(i);
            if (relayEntry.relayNumber != n) continue;
            if (relayEntry.firstRelayService == null) {
                relayEntry.firstRelayService = serviceEntry;
            } else {
                ServiceEntry serviceEntry2 = relayEntry.firstRelayService;
                while (serviceEntry2.nextRelayService != null) {
                    serviceEntry2 = serviceEntry2.nextRelayService;
                }
                serviceEntry2.nextRelayService = serviceEntry;
            }
            serviceEntry.parentRelay = relayEntry;
            return 0;
        }
        return -1;
    }

    public Iterator<RelayEntry> relayIterator() {
        return this.relayEntries.iterator();
    }

    public int getServiceCount() {
        return this.serviceEntries.size();
    }

    public Iterator<ServiceEntry> serviceIterator() {
        return this.serviceEntries.iterator();
    }

    public Iterable<ServiceEntry> serviceIterable() {
        return this.serviceEntries;
    }

    public Collection<ServiceEntry> getServiceCollection() {
        return this.serviceEntries;
    }

    public boolean equals(Object object) {
        if (object instanceof IDNServiceMap) {
            int n;
            IDNServiceMap iDNServiceMap = (IDNServiceMap)object;
            int n2 = this.relayEntries.size();
            if (n2 != iDNServiceMap.relayEntries.size()) {
                return false;
            }
            for (n = 0; n < n2; ++n) {
                if (this.relayEntries.get(n).equals(iDNServiceMap.relayEntries.get(n))) continue;
                return false;
            }
            n = this.serviceEntries.size();
            if (n != iDNServiceMap.serviceEntries.size()) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.serviceEntries.get(i).equals(iDNServiceMap.serviceEntries.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format("IDNServiceMap", new Object[0]);
    }

    public static class ServiceEntry {
        public String serviceName;
        public int serviceID;
        public int serviceType;
        public int flags;
        public RelayEntry parentRelay;
        public ServiceEntry nextRelayService;

        public ServiceEntry(int n, String string) {
            this.serviceID = n;
            this.serviceName = string;
        }

        public boolean equals(Object object) {
            if (object instanceof ServiceEntry) {
                ServiceEntry serviceEntry = (ServiceEntry)object;
                if (this.serviceID != serviceEntry.serviceID) {
                    return false;
                }
                if (this.serviceType != serviceEntry.serviceType) {
                    return false;
                }
                if (this.flags != serviceEntry.flags) {
                    return false;
                }
                if (this.parentRelay != null) {
                    if (serviceEntry.parentRelay == null) {
                        return false;
                    }
                    if (!this.parentRelay.equals(serviceEntry.parentRelay)) {
                        return false;
                    }
                } else if (serviceEntry.parentRelay != null) {
                    return false;
                }
                if (this.serviceName != null && serviceEntry.serviceName != null) {
                    return this.serviceName.equals(serviceEntry.serviceName);
                }
                return this.serviceName == serviceEntry.serviceName;
            }
            return false;
        }
    }

    public static class RelayEntry {
        public String relayName;
        public int relayNumber;
        public int flags;
        public ServiceEntry firstRelayService;

        public RelayEntry(int n, String string) {
            this.relayNumber = n;
            this.relayName = string;
        }

        public boolean equals(Object object) {
            if (object instanceof RelayEntry) {
                RelayEntry relayEntry = (RelayEntry)object;
                if (this.relayNumber != relayEntry.relayNumber) {
                    return false;
                }
                if (this.flags != relayEntry.flags) {
                    return false;
                }
                if (this.relayName != null && relayEntry.relayName != null) {
                    return this.relayName.equals(relayEntry.relayName);
                }
                return this.relayName == relayEntry.relayName;
            }
            return false;
        }
    }
}

