/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.idn;

import java.util.Arrays;
import java.util.Formatter;

public class IDNUnitID {
    private byte[] idBytes;

    public IDNUnitID(byte[] byArray) {
        this.idBytes = byArray;
    }

    public byte[] getIDBytes() {
        return this.idBytes;
    }

    public int hashCode() {
        return Arrays.hashCode(this.idBytes);
    }

    public boolean equals(Object object) {
        if (object instanceof IDNUnitID) {
            IDNUnitID iDNUnitID = (IDNUnitID)object;
            return Arrays.equals(iDNUnitID.idBytes, this.idBytes);
        }
        return false;
    }

    public String toString() {
        if (this.idBytes == null || this.idBytes.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Formatter formatter = new Formatter(stringBuilder);
        formatter.format("%02X", this.idBytes[0]);
        if (this.idBytes.length > 1) {
            formatter.format("-", new Object[0]);
        }
        for (int i = 1; i < this.idBytes.length; ++i) {
            formatter.format("%02X", this.idBytes[i]);
        }
        return stringBuilder.toString();
    }

    private static byte parseUByte(String string) {
        short s = Short.parseShort(string, 16);
        if (s < 0 || s > 255) {
            throw new NumberFormatException("Value out of range " + s);
        }
        return (byte)s;
    }

    public static IDNUnitID parseString(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("-");
        if (stringArray.length != 2) {
            return null;
        }
        if (stringArray[0].length() != 2) {
            return null;
        }
        if (stringArray[1].length() % 2 != 0) {
            return null;
        }
        int n = stringArray[1].length() / 2;
        byte[] byArray = new byte[1 + n];
        try {
            byArray[0] = IDNUnitID.parseUByte(stringArray[0]);
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[1].substring(i * 2, i * 2 + 2);
                byArray[1 + i] = IDNUnitID.parseUByte(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new IDNUnitID(byArray);
    }
}

