/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.idn.messages;

import dexlogic.io.idn.messages.IDNFileMessage;
import dexlogic.io.idn.structs.IDNFileTrackEntryStruct;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class IDNFileAnchorMessage
extends IDNFileMessage {
    String streamName;
    long nextAnchorFP;
    long durationMS;
    long movieFirstFP;
    long movieLastFP;
    long movieLength;
    long movieLocatorFP;
    ArrayList<IDNFileTrackEntryStruct> trackEntries = new ArrayList();

    IDNFileAnchorMessage() {
    }

    @Override
    protected void resetMembers() {
        super.resetMembers();
        this.streamName = null;
        this.nextAnchorFP = 0L;
        this.movieFirstFP = 0L;
        this.movieLastFP = 0L;
        this.movieLength = 0L;
        this.movieLocatorFP = 0L;
    }

    public void setStreamName(String string) {
        this.streamName = string;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setNextAnchorFP(long l) {
        this.nextAnchorFP = l;
    }

    public long getNextAnchorFP() {
        return this.nextAnchorFP;
    }

    public void setDurationMS(long l) {
        if (l < 0L) {
            throw new RuntimeException("Duration must not be negative");
        }
        if (l > -1L) {
            throw new RuntimeException("Duration must not greater than 0xFFFFFFFF");
        }
        this.durationMS = l;
    }

    public long getDurationMS() {
        return this.durationMS;
    }

    public void setMovieFirstFP(long l) {
        this.movieFirstFP = l;
    }

    public long getMovieFirstFP() {
        return this.movieFirstFP;
    }

    public void setMovieLastFP(long l) {
        this.movieLastFP = l;
    }

    public long getMovieLastFP() {
        return this.movieLastFP;
    }

    public void setMovieLength(long l) {
        this.movieLength = l;
    }

    public long getMovieLength() {
        return this.movieLength;
    }

    public void setMovieLocatorFP(long l) {
        this.movieLocatorFP = l;
    }

    public long getMovieLocatorFP() {
        return this.movieLocatorFP;
    }

    public int getTrackCount() {
        return this.trackEntries.size();
    }

    public IDNFileTrackEntryStruct[] getTrackArray() {
        IDNFileTrackEntryStruct[] iDNFileTrackEntryStructArray = new IDNFileTrackEntryStruct[this.trackEntries.size()];
        this.trackEntries.toArray(iDNFileTrackEntryStructArray);
        return iDNFileTrackEntryStructArray;
    }

    public Iterator<IDNFileTrackEntryStruct> trackIterator() {
        return this.trackEntries.iterator();
    }

    @Override
    public String toString() {
        return String.format("IDNFileAnchorMessage", new Object[0]);
    }
}

