/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.idn.messages;

import dexlogic.io.idn.IDNDataException;
import dexlogic.io.idn.messages.IDNMessage;
import java.nio.ByteBuffer;

public abstract class IDNFileMessage
extends IDNMessage {
    IDNFileMessage() {
    }

    protected void setContentID(int n) {
        throw new RuntimeException("Not implemented");
    }

    protected int getContentID() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    protected void readBytes(ByteBuffer byteBuffer) throws IDNDataException {
        int n = byteBuffer.getShort() & 0xFFFF;
        if (n != byteBuffer.limit()) {
            String string = "Buffer size mismatch. Expected %04X, got %04X";
            String string2 = String.format(string, n, byteBuffer.limit());
            throw new IDNDataException(string2);
        }
        int n2 = byteBuffer.getShort() & 0xFFFF;
        this.setContentID(n2);
        byteBuffer.mark();
    }

    @Override
    protected void writeBytes(ByteBuffer byteBuffer) throws IDNDataException {
        byteBuffer.putShort((short)0);
        byteBuffer.putShort((short)this.getContentID());
        byteBuffer.mark();
    }

    @Override
    public String toString() {
        return String.format("IDNFileMessage", new Object[0]);
    }
}

