/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.idn.packets;

import dexlogic.io.idn.IDNDataException;
import java.nio.ByteBuffer;

public class IDNPacket {
    private int command = 0;
    private int clientGroup = 0;
    private int sequence = 0;

    protected void resetMembers() {
        this.command = 0;
        this.clientGroup = 0;
        this.sequence = 0;
    }

    protected void readBytes(ByteBuffer byteBuffer) throws IDNDataException {
        this.command = byteBuffer.get() & 0xFF;
        int n = byteBuffer.get() & 0xFF;
        this.sequence = byteBuffer.getShort() & 0xFFFF;
        this.clientGroup = n & 0xF;
        byteBuffer.mark();
    }

    protected void writeBytes(ByteBuffer byteBuffer) throws IDNDataException {
        int n = this.clientGroup & 0xF;
        byteBuffer.put((byte)this.command);
        byteBuffer.put((byte)n);
        byteBuffer.putShort((short)this.sequence);
        byteBuffer.mark();
    }

    public IDNPacket(int n) {
        this.command = n;
    }

    public int getCommand() {
        return this.command;
    }

    public void setClientGroup(int n) {
        this.clientGroup = n;
    }

    public int getClientGroup() {
        return this.clientGroup;
    }

    public void setSequence(int n) {
        this.sequence = n;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void readFrom(ByteBuffer byteBuffer) throws IDNDataException {
        this.resetMembers();
        byteBuffer.rewind();
        this.readBytes(byteBuffer);
    }

    public ByteBuffer writeTo(ByteBuffer byteBuffer) throws IDNDataException {
        byteBuffer.clear();
        this.writeBytes(byteBuffer);
        int n = byteBuffer.position();
        byteBuffer.limit(n);
        return byteBuffer;
    }

    public ByteBuffer writeTo(ByteBuffer byteBuffer, int n) throws IDNDataException {
        this.sequence = n;
        return this.writeTo(byteBuffer);
    }

    public String toString() {
        return String.format("IDNPacket %02X", this.command);
    }
}

