/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.netscan;

import dexlogic.io.netscan.NetScanAddress;
import dexlogic.io.netscan.NetScanHandler;
import dexlogic.io.netscan.NetScanQueue;
import dexlogic.io.netscan.NetScanResult;
import dexlogic.io.netscan.NetScanServer;
import dexlogic.io.netscan.NetScanTrace;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class ScanManager {
    private NetScanHandler[] scanHandlerArray;
    private ScanRegion[] scanRegionArray;
    private StringWriter logStringWriter;
    private PrintWriter logPrintWriter;
    private Selector selector = null;
    private HashMap<DatagramChannel, ChannelInfo> channelMap;
    private CheckInfo checkInfo;
    private RegionInfo[] regionInfoArray;
    private HashMap<InetSocketAddress, ReplyInfo> replyMap;
    private HashMap<Integer, HandlerInfo> handlerMap;
    private static final int REPLY_TIMEOUT_MS = 400;

    private void putCheckQuery(HandlerInfo handlerInfo, InetSocketAddress inetSocketAddress) {
        if (handlerInfo.checkQuery != null) {
            this.checkInfo.queue.addQuery(handlerInfo.checkQuery, inetSocketAddress);
        }
    }

    private int getAddressInfoIndex(NetScanServer netScanServer, InetSocketAddress inetSocketAddress) {
        int n = netScanServer.addresses.length;
        for (int i = 0; i < n; ++i) {
            if (!netScanServer.addresses[i].inetSocketAddress.equals(inetSocketAddress)) continue;
            return i;
        }
        NetScanAddress netScanAddress = new NetScanAddress(inetSocketAddress);
        netScanAddress.errorFlags |= 1;
        netScanServer.addresses = Arrays.copyOf(netScanServer.addresses, n + 1);
        netScanServer.addresses[n] = netScanAddress;
        return n;
    }

    private NetScanAddress putScannedAddress(NetScanServer netScanServer, InetSocketAddress inetSocketAddress) {
        int n = this.getAddressInfoIndex(netScanServer, inetSocketAddress);
        return netScanServer.addresses[n];
    }

    private NetScanAddress putCheckedAddress(NetScanServer netScanServer, InetSocketAddress inetSocketAddress) {
        int n = this.getAddressInfoIndex(netScanServer, inetSocketAddress);
        NetScanAddress netScanAddress = netScanServer.addresses[n];
        netScanAddress.errorFlags &= 0xFFFFFFFE;
        if (netScanAddress.errorFlags != 0) {
            return netScanAddress;
        }
        for (int i = n - 1; i >= 0; --i) {
            NetScanAddress netScanAddress2 = netScanServer.addresses[i];
            if (netScanAddress2.errorFlags == 0) break;
            netScanServer.addresses[i + 1] = netScanAddress2;
            netScanServer.addresses[i] = netScanAddress;
        }
        return netScanAddress;
    }

    private NetScanAddress putAmbiguousAddress(NetScanServer netScanServer, InetSocketAddress inetSocketAddress) {
        int n = this.getAddressInfoIndex(netScanServer, inetSocketAddress);
        NetScanAddress netScanAddress = netScanServer.addresses[n];
        netScanAddress.errorFlags |= 0x10;
        int n2 = netScanServer.addresses.length;
        for (int i = n + 1; i < n2; ++i) {
            NetScanAddress netScanAddress2 = netScanServer.addresses[i];
            if (netScanAddress2.errorFlags != 0) break;
            netScanServer.addresses[i - 1] = netScanAddress2;
            netScanServer.addresses[i] = netScanAddress;
        }
        return netScanAddress;
    }

    private boolean serverMismatch(NetScanServer netScanServer, ReplyInfo replyInfo) {
        if (netScanServer == null || replyInfo == null || replyInfo.server == null) {
            return false;
        }
        if (netScanServer.equals(replyInfo.server)) {
            if (netScanServer != replyInfo.server) {
                throw new Error("Duplicate host objects with same UnitID");
            }
            return false;
        }
        return true;
    }

    private void processChatReply(HandlerInfo handlerInfo, ByteBuffer byteBuffer, InetSocketAddress inetSocketAddress) {
        NetScanHandler netScanHandler = handlerInfo.handler;
        ReplyInfo replyInfo = this.replyMap.get(inetSocketAddress);
        if (replyInfo == null || replyInfo.server == null) {
            netScanHandler.logError(handlerInfo.trace, inetSocketAddress, "Info response from unknown server", new Object[0]);
            return;
        }
        netScanHandler.readChatReply(handlerInfo.trace, byteBuffer, inetSocketAddress, replyInfo.server);
    }

    private void processFindReply(ProbeInfo probeInfo, ByteBuffer byteBuffer, InetSocketAddress inetSocketAddress) {
        Serializable serializable;
        HandlerInfo handlerInfo = null;
        ReplyInfo replyInfo = this.replyMap.get(inetSocketAddress);
        handlerInfo = replyInfo != null ? replyInfo.getHandlerInfo() : this.handlerMap.get(inetSocketAddress.getPort());
        if (handlerInfo == null) {
            return;
        }
        NetScanServer netScanServer = null;
        NetScanAddress netScanAddress = null;
        NetScanHandler netScanHandler = handlerInfo.handler;
        netScanServer = netScanHandler.readFindReply(probeInfo.trace, byteBuffer, inetSocketAddress);
        if (netScanServer != null) {
            if (this.serverMismatch(netScanServer, replyInfo)) {
                netScanAddress = this.putAmbiguousAddress(netScanServer, inetSocketAddress);
                this.putAmbiguousAddress(replyInfo.server, inetSocketAddress);
            } else {
                boolean bl = false;
                if (probeInfo instanceof RegionInfo) {
                    serializable = ((RegionInfo)probeInfo).scanInetAddress;
                    if (!inetSocketAddress.getAddress().equals(serializable)) {
                        bl = true;
                    }
                }
                if (replyInfo == null) {
                    replyInfo = new ReplyInfo(handlerInfo, null);
                    replyInfo.server = netScanServer;
                    this.replyMap.put(inetSocketAddress, replyInfo);
                    if (bl) {
                        this.putCheckQuery(handlerInfo, inetSocketAddress);
                    }
                } else if (replyInfo.server == null) {
                    replyInfo.server = netScanServer;
                }
                if (replyInfo.probeInfo == null || probeInfo instanceof RegionInfo) {
                    replyInfo.probeInfo = probeInfo;
                }
                replyInfo.statusFlags = bl ? (replyInfo.statusFlags |= 1) : (replyInfo.statusFlags |= 2);
                if ((replyInfo.statusFlags & 2) != 0) {
                    netScanAddress = this.putCheckedAddress(netScanServer, inetSocketAddress);
                } else if ((replyInfo.statusFlags & 1) != 0) {
                    netScanAddress = this.putScannedAddress(netScanServer, inetSocketAddress);
                } else {
                    throw new Error("Invalid reply info status " + replyInfo.statusFlags);
                }
            }
        }
        if (netScanServer != null) {
            if (netScanAddress == null) {
                throw new Error("Server object but no address object");
            }
            if (netScanServer.addresses.length == 0) {
                throw new Error("Empty server address list");
            }
            ServerInfo serverInfo = handlerInfo.serverInfoMap.get(netScanServer);
            if (serverInfo == null) {
                serverInfo = new ServerInfo(netScanServer);
                handlerInfo.serverInfoMap.put(netScanServer, serverInfo);
            }
            if (netScanServer.addresses[0].errorFlags == 0) {
                if (!serverInfo.infoRequested) {
                    serializable = netScanServer.addresses[0].getInetSocketAddress();
                    netScanHandler.getChatQueries(handlerInfo.queue, (InetSocketAddress)serializable);
                    if (handlerInfo.queue.hasQueries()) {
                        int n = handlerInfo.selectionKey.interestOps();
                        handlerInfo.selectionKey.interestOps(n | 4);
                    }
                    serverInfo.infoRequested = true;
                }
            } else {
                serverInfo.infoRequested = false;
            }
        }
    }

    private void setupHandlers() throws IOException {
        Object[] objectArray;
        HandlerInfo handlerInfo;
        NetScanHandler netScanHandler;
        int n;
        this.replyMap = new HashMap();
        this.handlerMap = new HashMap();
        NetScanTrace netScanTrace = new NetScanTrace();
        netScanTrace.taskName = "Scan handler setup";
        int n2 = this.scanHandlerArray.length;
        HandlerInfo[] handlerInfoArray = new HandlerInfo[n2];
        for (n = 0; n < n2; ++n) {
            Object object;
            Object object2;
            int n3;
            NetScanAddress[] netScanAddressArray;
            netScanHandler = this.scanHandlerArray[n];
            handlerInfo = handlerInfoArray[n] = new HandlerInfo(netScanHandler);
            handlerInfo.trace.taskName = netScanHandler.getTaskName();
            DatagramChannel datagramChannel = DatagramChannel.open();
            datagramChannel.configureBlocking(false);
            this.channelMap.put(datagramChannel, handlerInfo);
            handlerInfo.selectionKey = datagramChannel.register(this.selector, 5);
            netScanHandler.prepareScan();
            ByteBuffer object3 = netScanHandler.getScanQuery();
            objectArray = netScanHandler.getPortNumbers();
            for (int i = 0; i < objectArray.length; ++i) {
                NetScanAddress netScanAddress = objectArray[i];
                netScanAddressArray = Integer.valueOf((int)netScanAddress);
                if (this.handlerMap.containsKey(netScanAddressArray)) {
                    throw new IOException("Duplicate port number in scan handler set: " + (int)netScanAddress);
                }
                this.handlerMap.put((Integer)netScanAddressArray, handlerInfo);
                if (object3 == null) continue;
                n3 = this.regionInfoArray.length;
                for (int j = 0; j < n3; ++j) {
                    object2 = this.regionInfoArray[j];
                    object = ((RegionInfo)object2).scanInetAddress;
                    InetSocketAddress inetSocketAddress = new InetSocketAddress((InetAddress)object, (int)netScanAddress);
                    ((RegionInfo)object2).queue.addQuery(object3, inetSocketAddress);
                }
            }
            handlerInfo.checkQuery = netScanHandler.getCheckQuery();
            for (NetScanServer netScanServer : netScanHandler.getServerCollection()) {
                netScanAddressArray = netScanServer.addresses;
                for (n3 = 0; n3 < netScanAddressArray.length; ++n3) {
                    NetScanAddress netScanAddress = netScanAddressArray[n3];
                    netScanAddress.errorFlags = 0;
                    object2 = netScanAddress.inetSocketAddress;
                    if (this.replyMap.containsKey(object2)) {
                        netScanAddress.errorFlags |= 0x10;
                        netScanTrace.logInfo(netScanHandler.getIDString(netScanServer) + " ignore " + netScanAddress.toString(), new Object[0]);
                        object = this.replyMap.get(object2).getRefServer();
                        for (NetScanAddress netScanAddress2 : ((NetScanServer)object).addresses) {
                            if (!netScanAddress2.inetSocketAddress.equals(object2) || (netScanAddress2.errorFlags & 0x10) != 0) continue;
                            netScanAddress2.errorFlags |= 0x10;
                            netScanTrace.logInfo(netScanHandler.getIDString((NetScanServer)object) + " ignore " + netScanAddress2.toString(), new Object[0]);
                        }
                        continue;
                    }
                    object = new ReplyInfo(handlerInfo, netScanServer);
                    this.replyMap.put((InetSocketAddress)object2, (ReplyInfo)object);
                }
            }
        }
        for (n = 0; n < n2; ++n) {
            netScanHandler = this.scanHandlerArray[n];
            handlerInfo = handlerInfoArray[n];
            for (NetScanServer netScanServer : netScanHandler.getServerCollection()) {
                netScanServer.defaultAddress = null;
                objectArray = netScanServer.addresses;
                for (int i = 0; i < objectArray.length; ++i) {
                    NetScanAddress netScanAddress = objectArray[i];
                    if (netScanAddress.errorFlags == 0) {
                        this.putCheckQuery(handlerInfo, netScanAddress.inetSocketAddress);
                    } else {
                        this.replyMap.remove(netScanAddress.inetSocketAddress);
                        netScanAddress.errorFlags = 0;
                    }
                    netScanAddress.errorFlags |= 1;
                }
            }
        }
        StringBuffer stringBuffer = netScanTrace.getLogBuffer();
        if (stringBuffer.length() != 0) {
            this.logPrintWriter.println(netScanTrace.taskName);
            this.logPrintWriter.append(stringBuffer);
        }
    }

    private void setupRegions() throws IOException {
        ArrayList<RegionInfo> arrayList = new ArrayList<RegionInfo>();
        for (ScanRegion scanRegion : this.scanRegionArray) {
            DatagramChannel datagramChannel = DatagramChannel.open();
            RegionInfo regionInfo = new RegionInfo(scanRegion);
            this.channelMap.put(datagramChannel, regionInfo);
            arrayList.add(regionInfo);
            datagramChannel.socket().setBroadcast(true);
            datagramChannel.configureBlocking(false);
            regionInfo.selectionKey = datagramChannel.register(this.selector, 5);
            InetAddress inetAddress = null;
            if (scanRegion.interfaceAddress != null) {
                NetworkInterface networkInterface = scanRegion.networkInterface;
                InterfaceAddress interfaceAddress = scanRegion.interfaceAddress;
                regionInfo.trace.taskName = "Scan(interface, " + networkInterface.getName() + "): " + interfaceAddress;
                inetAddress = interfaceAddress.getAddress();
                datagramChannel.bind(new InetSocketAddress(inetAddress, 0));
                byte[] byArray = new byte[]{-1, -1, -1, -1};
                regionInfo.scanInetAddress = InetAddress.getByAddress(byArray);
                continue;
            }
            if (scanRegion.inetAddress != null) {
                regionInfo.trace.taskName = "Scan(address): " + scanRegion.inetAddress;
                inetAddress = new InetSocketAddress(0).getAddress();
                regionInfo.scanInetAddress = scanRegion.inetAddress;
                continue;
            }
            throw new RuntimeException("Invalid region parameter");
        }
        this.regionInfoArray = arrayList.toArray(new RegionInfo[arrayList.size()]);
    }

    public ScanManager(NetScanHandler netScanHandler, Object object) throws IOException {
        this.scanHandlerArray = new NetScanHandler[]{netScanHandler};
        this.logStringWriter = new StringWriter();
        this.logPrintWriter = new PrintWriter(this.logStringWriter);
        if (object == null) {
            this.logPrintWriter.println("===== Interface scan =====");
            ArrayList<ScanRegion> arrayList = new ArrayList<ScanRegion>();
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (networkInterface == null || networkInterface.isLoopback() || !networkInterface.isUp()) continue;
                for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                    if (interfaceAddress == null || interfaceAddress.getAddress() == null || interfaceAddress.getBroadcast() == null) continue;
                    arrayList.add(new ScanRegion(networkInterface, interfaceAddress));
                }
            }
            this.scanRegionArray = arrayList.toArray(new ScanRegion[arrayList.size()]);
        } else if (object instanceof String) {
            this.logPrintWriter.println("===== Single address scan =====");
            InetAddress inetAddress = InetAddress.getByName((String)object);
            this.scanRegionArray = new ScanRegion[]{new ScanRegion(inetAddress)};
        } else {
            throw new IllegalArgumentException("Invalid region parameter");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NetScanResult runScan() throws IOException {
        void var6_14;
        Object object;
        Object object2;
        Object object3;
        int n;
        long l;
        block42: {
            l = System.currentTimeMillis();
            n = 0;
            ByteBuffer byteBuffer = ByteBuffer.allocate(65536);
            this.channelMap = new HashMap();
            try {
                this.selector = Selector.open();
                Iterator<Map.Entry<InetSocketAddress, ReplyInfo>> iterator = DatagramChannel.open();
                this.checkInfo = new CheckInfo();
                this.checkInfo.trace.taskName = "Check(unicast)";
                this.channelMap.put((DatagramChannel)((Object)iterator), this.checkInfo);
                ((AbstractSelectableChannel)((Object)iterator)).configureBlocking(false);
                this.checkInfo.selectionKey = ((SelectableChannel)((Object)iterator)).register(this.selector, 5);
                this.setupRegions();
                this.setupHandlers();
                block10: while (true) {
                    if (this.selector.select(400L) <= 0) {
                        if (this.selector != null) {
                            break;
                        }
                        break block42;
                    }
                    Iterator<SelectionKey> object7 = this.selector.selectedKeys().iterator();
                    while (true) {
                        if (!object7.hasNext()) continue block10;
                        SelectionKey selectionKey = object7.next();
                        object7.remove();
                        SelectableChannel selectableChannel = selectionKey.channel();
                        if (selectionKey.isWritable()) {
                            object3 = this.channelMap.get((DatagramChannel)selectableChannel);
                            if (object3 == null) {
                                throw new IOException("Select returned invalid channel");
                            }
                            NetScanQueue netScanQueue = ((ChannelInfo)object3).queue;
                            object2 = netScanQueue.getNextQuery();
                            if (object2 != null) {
                                object2.reqBuffer.rewind();
                                if (((DatagramChannel)selectableChannel).send(object2.reqBuffer, object2.socketAddress) <= 0) {
                                    throw new IOException("Insufficient send buffer");
                                }
                            }
                            if (object2 != null && netScanQueue.hasQueries()) continue;
                            int n2 = selectionKey.interestOps();
                            selectionKey.interestOps(n2 & 0xFFFFFFFB);
                            continue;
                        }
                        if (!selectionKey.isReadable()) {
                            throw new IOException("Invalid channel / selection key");
                        }
                        object3 = this.channelMap.get((DatagramChannel)selectableChannel);
                        if (object3 == null) {
                            throw new IOException("Select returned invalid channel");
                        }
                        byteBuffer.clear();
                        InetSocketAddress inetSocketAddress = (InetSocketAddress)((DatagramChannel)selectableChannel).receive(byteBuffer);
                        byteBuffer.flip();
                        if (object3 instanceof ProbeInfo) {
                            if (object3 instanceof RegionInfo) {
                                ++n;
                            }
                            this.processFindReply((ProbeInfo)object3, byteBuffer, inetSocketAddress);
                            if (!this.checkInfo.queue.hasQueries()) continue;
                            int n3 = this.checkInfo.selectionKey.interestOps();
                            this.checkInfo.selectionKey.interestOps(n3 | 4);
                            continue;
                        }
                        if (!(object3 instanceof HandlerInfo)) {
                            throw new IOException("Inconsistent channel data map");
                        }
                        this.processChatReply((HandlerInfo)object3, byteBuffer, inetSocketAddress);
                        if (!((ChannelInfo)object3).queue.hasQueries()) continue;
                        int n4 = ((ChannelInfo)object3).selectionKey.interestOps();
                        ((ChannelInfo)object3).selectionKey.interestOps(n4 | 4);
                    }
                    break;
                }
                if (!this.selector.isOpen()) break block42;
            }
            catch (Throwable throwable) {
                if (this.selector != null && this.selector.isOpen()) {
                    try {
                        this.selector.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                this.selector = null;
                Iterator<DatagramChannel> iterator = this.channelMap.keySet().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        this.channelMap.clear();
                        this.channelMap = null;
                        throw throwable;
                    }
                    DatagramChannel datagramChannel = iterator.next();
                    if (datagramChannel == null || !datagramChannel.isOpen()) continue;
                    try {
                        datagramChannel.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            try {
                this.selector.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.selector = null;
        for (DatagramChannel stringBuffer : this.channelMap.keySet()) {
            if (stringBuffer == null || !stringBuffer.isOpen()) continue;
            try {
                stringBuffer.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.channelMap.clear();
        this.channelMap = null;
        for (Map.Entry<InetSocketAddress, ReplyInfo> entry : this.replyMap.entrySet()) {
            InetSocketAddress inetSocketAddress = entry.getKey();
            ReplyInfo replyInfo = entry.getValue();
            object3 = replyInfo.probeInfo;
            NetScanServer netScanServer = replyInfo.server;
            if (object3 == null || netScanServer == null) continue;
            object2 = replyInfo.handlerInfo.handler;
            String string = object2.getIDString(replyInfo.server);
            object = new StringBuilder();
            if (string != null) {
                ((StringBuilder)object).append(string).append(" at ");
            }
            ((StringBuilder)object).append(inetSocketAddress.toString());
            ((ProbeInfo)object3).trace.logInfo(((StringBuilder)object).toString(), new Object[0]);
            ++replyInfo.probeInfo.replyCount;
        }
        int n5 = this.regionInfoArray.length;
        boolean bl = false;
        while (var6_14 < n5) {
            RegionInfo regionInfo = this.regionInfoArray[var6_14];
            if (regionInfo.replyCount == 0) {
                PrintWriter printWriter = regionInfo.trace.logPrintWriter;
                printWriter.print("  ");
                printWriter.println("[msg] No broadcast replies");
            }
            this.logPrintWriter.println(regionInfo.trace.taskName);
            this.logPrintWriter.append(regionInfo.trace.getLogBuffer());
            ++var6_14;
        }
        StringBuffer stringBuffer = this.checkInfo.trace.getLogBuffer();
        if (stringBuffer.length() != 0) {
            this.logPrintWriter.println(this.checkInfo.trace.taskName);
            this.logPrintWriter.append(stringBuffer);
        }
        for (Map.Entry<Integer, HandlerInfo> entry : this.handlerMap.entrySet()) {
            object3 = entry.getValue();
            StringBuffer stringBuffer2 = ((HandlerInfo)object3).trace.getLogBuffer();
            if (stringBuffer2.length() == 0) continue;
            this.logPrintWriter.println(((HandlerInfo)object3).trace.taskName);
            this.logPrintWriter.append(stringBuffer2);
        }
        Object object8 = new NetScanTrace();
        ((NetScanTrace)object8).taskName = "Server address update";
        for (HandlerInfo handlerInfo : this.handlerMap.values()) {
            NetScanHandler netScanHandler = handlerInfo.handler;
            for (NetScanServer netScanServer : netScanHandler.getServerCollection()) {
                if (netScanServer.addresses.length > 0 && netScanServer.addresses[0].errorFlags == 0) {
                    netScanServer.defaultAddress = netScanServer.addresses[0].inetSocketAddress;
                    object2 = netScanServer.addresses;
                    int n6 = 1;
                    while (n6 < ((NetScanAddress[])object2).length) {
                        object = object2[n6];
                        ReplyInfo replyInfo = this.replyMap.get(((NetScanAddress)object).inetSocketAddress);
                        if (replyInfo == null || replyInfo.server != netScanServer) {
                            ((NetScanTrace)object8).logInfo(netScanHandler.getIDString(netScanServer) + " removed " + (NetScanAddress)object, new Object[0]);
                            int n7 = ((NetScanAddress[])object2).length - 1;
                            NetScanAddress[] netScanAddressArray = new NetScanAddress[n7];
                            System.arraycopy(object2, 0, netScanAddressArray, 0, n6);
                            if (n6 < n7) {
                                System.arraycopy(object2, n6 + 1, netScanAddressArray, n6, n7 - n6);
                            }
                            netScanServer.addresses = netScanAddressArray;
                            object2 = netScanAddressArray;
                            continue;
                        }
                        ++n6;
                    }
                    continue;
                }
                netScanServer.defaultAddress = null;
                ((NetScanTrace)object8).logInfo(netScanHandler.getIDString(netScanServer) + " has no default address", new Object[0]);
            }
        }
        StringBuffer stringBuffer3 = ((NetScanTrace)object8).getLogBuffer();
        if (stringBuffer3.length() != 0) {
            this.logPrintWriter.println(((NetScanTrace)object8).taskName);
            this.logPrintWriter.append(stringBuffer3);
        }
        object8 = new NetScanResult(this.scanHandlerArray);
        Iterator<Map.Entry<Integer, HandlerInfo>> iterator = this.handlerMap.entrySet().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                ((NetScanResult)object8).broadcastReplyCount = n;
                long l2 = System.currentTimeMillis() - l;
                this.logPrintWriter.print("Time: " + l2 / 1000L + "." + l2 % 1000L + "s");
                this.logPrintWriter.flush();
                ((NetScanResult)object8).log = this.logStringWriter.toString();
                return object8;
            }
            Map.Entry<Integer, HandlerInfo> entry = iterator.next();
            HandlerInfo handlerInfo = entry.getValue();
            object3 = handlerInfo.handler;
            ((NetScanHandler)object3).terminateScan();
        }
    }

    private static class ServerInfo {
        boolean infoRequested = false;
        public NetScanServer server;

        public ServerInfo(NetScanServer netScanServer) {
            this.server = netScanServer;
        }
    }

    private static class ReplyInfo {
        private HandlerInfo handlerInfo;
        private NetScanServer refServer;
        public NetScanServer server;
        public ProbeInfo probeInfo;
        public int statusFlags;
        public static final int STATUSFLAG_SCANNED = 1;
        public static final int STATUSFLAG_CHECKED = 2;

        public ReplyInfo(HandlerInfo handlerInfo, NetScanServer netScanServer) {
            this.handlerInfo = handlerInfo;
            this.refServer = netScanServer;
        }

        public HandlerInfo getHandlerInfo() {
            return this.handlerInfo;
        }

        public NetScanServer getRefServer() {
            return this.refServer;
        }
    }

    private static class HandlerInfo
    extends ChannelInfo {
        NetScanHandler handler;
        ByteBuffer checkQuery;
        HashMap<NetScanServer, ServerInfo> serverInfoMap = new HashMap();

        HandlerInfo(NetScanHandler netScanHandler) {
            this.handler = netScanHandler;
        }
    }

    private static class CheckInfo
    extends ProbeInfo {
        CheckInfo() {
        }
    }

    private static class RegionInfo
    extends ProbeInfo {
        ScanRegion scanRegion;
        InetAddress scanInetAddress;

        RegionInfo(ScanRegion scanRegion) {
            this.scanRegion = scanRegion;
        }
    }

    private static class ProbeInfo
    extends ChannelInfo {
        int replyCount;

        ProbeInfo() {
        }
    }

    private static class ChannelInfo {
        SelectionKey selectionKey;
        NetScanTrace trace = new NetScanTrace();
        NetScanQueue queue = new NetScanQueue();

        ChannelInfo() {
        }
    }

    private static class ScanRegion {
        public NetworkInterface networkInterface;
        public InterfaceAddress interfaceAddress;
        public InetAddress inetAddress;

        public ScanRegion(NetworkInterface networkInterface, InterfaceAddress interfaceAddress) {
            this.networkInterface = networkInterface;
            this.interfaceAddress = interfaceAddress;
        }

        public ScanRegion(InetAddress inetAddress) {
            this.inetAddress = inetAddress;
        }
    }
}

