/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.netscan.proto;

import dexlogic.io.dln.DLNCaptureMap;
import dexlogic.io.dln.DLNDataException;
import dexlogic.io.dln.DLNUnitID;
import dexlogic.io.dln.packets.DLNCaptureMapRspPacket;
import dexlogic.io.dln.packets.DLNFeedScanRspPacket;
import dexlogic.io.dln.packets.DLNPacket;
import dexlogic.io.netscan.NetScanHandler;
import dexlogic.io.netscan.NetScanQueue;
import dexlogic.io.netscan.NetScanServer;
import dexlogic.io.netscan.NetScanTrace;
import dexlogic.io.netscan.proto.DLNFeedServer;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;

public class DLNFeedScanHandler
extends NetScanHandler {
    private int[] portNumbers = new int[]{7272};
    private int scanSeqNumber = (int)(Math.random() * 65536.0);
    private int checkSeqNumber;
    private ByteBuffer scanReqBuffer = ByteBuffer.allocate(10);
    private ByteBuffer checkReqBuffer = ByteBuffer.allocate(10);

    protected NetScanServer readDLNFeedFindReply(NetScanTrace netScanTrace, ByteBuffer byteBuffer, InetSocketAddress inetSocketAddress) {
        DLNFeedServer dLNFeedServer;
        int n = byteBuffer.get(byteBuffer.position()) & 0xFF;
        if (n != 17) {
            this.logDebug(netScanTrace, inetSocketAddress, "Scan response: Invalid command (%d)", n);
            return null;
        }
        DLNFeedScanRspPacket dLNFeedScanRspPacket = new DLNFeedScanRspPacket();
        try {
            dLNFeedScanRspPacket.readFrom(byteBuffer);
        }
        catch (DLNDataException dLNDataException) {
            this.logDebug(netScanTrace, inetSocketAddress, dLNDataException.getMessage(), new Object[0]);
            return null;
        }
        boolean bl = false;
        int n2 = dLNFeedScanRspPacket.getSequence();
        if (n2 == this.scanSeqNumber) {
            bl = true;
        } else if (n2 == this.checkSeqNumber) {
            bl = false;
        } else {
            this.logDebug(netScanTrace, inetSocketAddress, "Scan response: Invalid sequence number (%d)", n2);
            return null;
        }
        DLNUnitID dLNUnitID = dLNFeedScanRspPacket.getUnitID();
        if (dLNUnitID == null) {
            this.logDebug(netScanTrace, inetSocketAddress, "Scan response: Invalid unitID", new Object[0]);
            return null;
        }
        this.logDebug(netScanTrace, inetSocketAddress, "%s (%s)", dLNUnitID, bl ? "discover" : "check");
        NetScanServer netScanServer = this.getServer(dLNUnitID);
        if (netScanServer == null) {
            dLNFeedServer = new DLNFeedServer(dLNUnitID);
            this.putServer(dLNFeedServer);
        } else if (netScanServer instanceof DLNFeedServer) {
            dLNFeedServer = (DLNFeedServer)netScanServer;
        } else {
            throw new Error("Invalid server class type");
        }
        this.setHostName(dLNFeedServer, dLNFeedScanRspPacket.getHostName());
        return dLNFeedServer;
    }

    protected void readDLNFeedChatReply(NetScanTrace netScanTrace, ByteBuffer byteBuffer, InetSocketAddress inetSocketAddress, NetScanServer netScanServer) {
        int n = byteBuffer.get(byteBuffer.position()) & 0xFF;
        if (n == 19) {
            try {
                DLNCaptureMap dLNCaptureMap;
                DLNCaptureMapRspPacket dLNCaptureMapRspPacket = new DLNCaptureMapRspPacket();
                dLNCaptureMapRspPacket.readFrom(byteBuffer);
                this.logDebug(netScanTrace, inetSocketAddress, "CaptureMap", new Object[0]);
                ((DLNFeedServer)netScanServer).captureMap = dLNCaptureMap = dLNCaptureMapRspPacket.getCaptureMap();
            }
            catch (DLNDataException dLNDataException) {
                dLNDataException.printStackTrace();
            }
        } else {
            this.logError(netScanTrace, inetSocketAddress, "Invalid chat response cmdID = %02X", n);
        }
    }

    @Override
    protected String getProtocolName(int n) {
        return "DLNFeed";
    }

    @Override
    protected String getTaskName() {
        return "DLNFeed";
    }

    @Override
    protected int[] getPortNumbers() {
        return this.portNumbers;
    }

    @Override
    protected void prepareScan() {
        super.prepareScan();
        this.scanSeqNumber = this.scanSeqNumber + 2 & 0xFFFF;
        this.checkSeqNumber = this.scanSeqNumber + 1 & 0xFFFF;
        DLNPacket dLNPacket = new DLNPacket(16);
        try {
            dLNPacket.writeTo(this.scanReqBuffer, this.scanSeqNumber);
        }
        catch (DLNDataException dLNDataException) {
            dLNDataException.printStackTrace();
        }
        try {
            dLNPacket.writeTo(this.checkReqBuffer, this.checkSeqNumber);
        }
        catch (DLNDataException dLNDataException) {
            dLNDataException.printStackTrace();
        }
    }

    @Override
    protected ByteBuffer getScanQuery() {
        return this.scanReqBuffer;
    }

    @Override
    protected ByteBuffer getCheckQuery() {
        return this.checkReqBuffer;
    }

    @Override
    protected NetScanServer readFindReply(NetScanTrace netScanTrace, ByteBuffer byteBuffer, InetSocketAddress inetSocketAddress) {
        return this.readDLNFeedFindReply(netScanTrace, byteBuffer, inetSocketAddress);
    }

    @Override
    protected void getChatQueries(NetScanQueue netScanQueue, InetSocketAddress inetSocketAddress) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(10);
        DLNPacket dLNPacket = new DLNPacket(18);
        try {
            dLNPacket.writeTo(byteBuffer);
            netScanQueue.addQuery(byteBuffer, inetSocketAddress);
        }
        catch (DLNDataException dLNDataException) {
            dLNDataException.printStackTrace();
        }
    }

    @Override
    protected void readChatReply(NetScanTrace netScanTrace, ByteBuffer byteBuffer, InetSocketAddress inetSocketAddress, NetScanServer netScanServer) {
        this.readDLNFeedChatReply(netScanTrace, byteBuffer, inetSocketAddress, netScanServer);
    }

    @Override
    protected String getIDString(NetScanServer netScanServer) {
        DLNFeedServer dLNFeedServer = (DLNFeedServer)netScanServer;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(dLNFeedServer.getHostID().toString());
        String string = dLNFeedServer.getHostName();
        if (string != null) {
            stringBuilder.append("(");
            stringBuilder.append(string);
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }
}

