/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.io.netscan.proto;

import dexlogic.io.idn.IDNDataException;
import dexlogic.io.idn.IDNServiceMap;
import dexlogic.io.idn.IDNUnitID;
import dexlogic.io.idn.packets.IDNPacket;
import dexlogic.io.idn.packets.IDNScanRspPacket;
import dexlogic.io.idn.packets.IDNServiceMapRspPacket;
import dexlogic.io.netscan.NetScanHandler;
import dexlogic.io.netscan.NetScanQueue;
import dexlogic.io.netscan.NetScanServer;
import dexlogic.io.netscan.NetScanTrace;
import dexlogic.io.netscan.proto.IDNHelloServer;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;

public class IDNHelloScanHandler
extends NetScanHandler {
    private int clientGroup = 0;
    private int[] portNumbers = new int[]{7255};
    private int scanSeqNumber = (int)(Math.random() * 65536.0);
    private int checkSeqNumber;
    private ByteBuffer scanReqBuffer = ByteBuffer.allocate(10);
    private ByteBuffer checkReqBuffer = ByteBuffer.allocate(10);

    protected NetScanServer readIDNHelloFindReply(NetScanTrace netScanTrace, ByteBuffer byteBuffer, InetSocketAddress inetSocketAddress) {
        IDNHelloServer iDNHelloServer;
        int n = byteBuffer.get(byteBuffer.position()) & 0xFF;
        if (n != 17) {
            this.logDebug(netScanTrace, inetSocketAddress, "Scan response: Invalid command (%d)", n);
            return null;
        }
        IDNScanRspPacket iDNScanRspPacket = new IDNScanRspPacket();
        try {
            iDNScanRspPacket.readFrom(byteBuffer);
        }
        catch (IDNDataException iDNDataException) {
            this.logDebug(netScanTrace, inetSocketAddress, iDNDataException.getMessage(), new Object[0]);
            return null;
        }
        int n2 = iDNScanRspPacket.getClientGroup();
        if (n2 != this.clientGroup) {
            this.logDebug(netScanTrace, inetSocketAddress, "Scan response: Client group (%d) mismatch (%d)", this.clientGroup, n2);
            return null;
        }
        boolean bl = false;
        int n3 = iDNScanRspPacket.getSequence();
        if (n3 == this.scanSeqNumber) {
            bl = true;
        } else if (n3 == this.checkSeqNumber) {
            bl = false;
        } else {
            this.logDebug(netScanTrace, inetSocketAddress, "Scan response: Invalid sequence number (%d)", n3);
            return null;
        }
        IDNUnitID iDNUnitID = iDNScanRspPacket.getUnitID();
        if (iDNUnitID == null) {
            this.logDebug(netScanTrace, inetSocketAddress, "Scan response: Invalid unitID", new Object[0]);
            return null;
        }
        int n4 = iDNScanRspPacket.getProtocolVersion();
        int n5 = (n4 & 0xF0) >> 4;
        int n6 = n4 & 0xF;
        this.logDebug(netScanTrace, inetSocketAddress, "%s (%s) v%d.%d", iDNUnitID, bl ? "discover" : "check", n5, n6);
        NetScanServer netScanServer = this.getServer(iDNUnitID);
        if (netScanServer == null) {
            iDNHelloServer = new IDNHelloServer(iDNUnitID);
            this.putServer(iDNHelloServer);
        } else if (netScanServer instanceof IDNHelloServer) {
            iDNHelloServer = (IDNHelloServer)netScanServer;
        } else {
            throw new Error("Invalid server class type");
        }
        this.setHostName(iDNHelloServer, iDNScanRspPacket.getHostName());
        iDNHelloServer.protocolVersion = n4;
        return iDNHelloServer;
    }

    protected void readIDNHelloChatReply(NetScanTrace netScanTrace, ByteBuffer byteBuffer, InetSocketAddress inetSocketAddress, NetScanServer netScanServer) {
        int n = byteBuffer.get(byteBuffer.position()) & 0xFF;
        if (n == 19) {
            try {
                IDNServiceMap iDNServiceMap;
                IDNServiceMapRspPacket iDNServiceMapRspPacket = new IDNServiceMapRspPacket();
                iDNServiceMapRspPacket.readFrom(byteBuffer);
                this.logDebug(netScanTrace, inetSocketAddress, "ServiceMap", new Object[0]);
                ((IDNHelloServer)netScanServer).serviceMap = iDNServiceMap = iDNServiceMapRspPacket.getServiceMap();
            }
            catch (IDNDataException iDNDataException) {
                iDNDataException.printStackTrace();
            }
        } else {
            this.logError(netScanTrace, inetSocketAddress, "Invalid chat response cmdID = %02X", n);
        }
    }

    @Override
    protected String getProtocolName(int n) {
        return "IDNHello";
    }

    @Override
    protected String getTaskName() {
        return "IDNHello";
    }

    @Override
    protected int[] getPortNumbers() {
        return this.portNumbers;
    }

    @Override
    protected void prepareScan() {
        super.prepareScan();
        this.scanSeqNumber = this.scanSeqNumber + 2 & 0xFFFF;
        this.checkSeqNumber = this.scanSeqNumber + 1 & 0xFFFF;
        IDNPacket iDNPacket = new IDNPacket(16);
        iDNPacket.setClientGroup(this.clientGroup);
        try {
            iDNPacket.writeTo(this.scanReqBuffer, this.scanSeqNumber);
        }
        catch (IDNDataException iDNDataException) {
            iDNDataException.printStackTrace();
        }
        try {
            iDNPacket.writeTo(this.checkReqBuffer, this.checkSeqNumber);
        }
        catch (IDNDataException iDNDataException) {
            iDNDataException.printStackTrace();
        }
    }

    @Override
    protected ByteBuffer getScanQuery() {
        return this.scanReqBuffer;
    }

    @Override
    protected ByteBuffer getCheckQuery() {
        return this.checkReqBuffer;
    }

    @Override
    protected NetScanServer readFindReply(NetScanTrace netScanTrace, ByteBuffer byteBuffer, InetSocketAddress inetSocketAddress) {
        return this.readIDNHelloFindReply(netScanTrace, byteBuffer, inetSocketAddress);
    }

    @Override
    protected void getChatQueries(NetScanQueue netScanQueue, InetSocketAddress inetSocketAddress) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(10);
        IDNPacket iDNPacket = new IDNPacket(18);
        iDNPacket.setClientGroup(this.clientGroup);
        try {
            iDNPacket.writeTo(byteBuffer);
            netScanQueue.addQuery(byteBuffer, inetSocketAddress);
        }
        catch (IDNDataException iDNDataException) {
            iDNDataException.printStackTrace();
        }
    }

    @Override
    protected void readChatReply(NetScanTrace netScanTrace, ByteBuffer byteBuffer, InetSocketAddress inetSocketAddress, NetScanServer netScanServer) {
        this.readIDNHelloChatReply(netScanTrace, byteBuffer, inetSocketAddress, netScanServer);
    }

    @Override
    protected String getIDString(NetScanServer netScanServer) {
        IDNHelloServer iDNHelloServer = (IDNHelloServer)netScanServer;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(iDNHelloServer.getHostID().toString());
        String string = iDNHelloServer.getHostName();
        if (string != null) {
            stringBuilder.append("(");
            stringBuilder.append(string);
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public void setClientGroup(int n) {
        this.clientGroup = n;
    }

    public int getClientGroup() {
        return this.clientGroup;
    }
}

