/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec;

import java.io.File;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;

public class RefinedFileFilter
extends FileFilter {
    private String description;
    private String[] extensions;
    private String[] lowerCaseExtensions;

    public RefinedFileFilter(String string, String ... stringArray) {
        this.description = string;
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Extensions must be non-null and not empty");
        }
        this.extensions = new String[stringArray.length];
        this.lowerCaseExtensions = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].length() == 0) {
                throw new IllegalArgumentException("Each extension must be non-null and not empty");
            }
            this.extensions[i] = stringArray[i];
            this.lowerCaseExtensions[i] = stringArray[i].toLowerCase(Locale.ENGLISH);
        }
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    @Override
    public boolean accept(File file) {
        if (file == null) {
            return false;
        }
        if (file.isHidden()) {
            return false;
        }
        if (!file.isFile()) {
            return true;
        }
        String string = file.getName();
        for (String string2 : this.lowerCaseExtensions) {
            if (!string.endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.extensions.length; ++i) {
            if (i != 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append("*").append(this.extensions[i]);
        }
        return this.description + " (" + stringBuilder.toString() + ")";
    }
}

