/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec;

import dexlogic.parsec.GenericParsecException;
import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.RenderOptionsEvent;
import dexlogic.parsec.RenderOptionsListener;
import dexlogic.parsec.routes.FlowProxyBuilder;
import dexlogic.parsec.routes.FlowProxyEditor;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RenderSetup
implements FlowProxyBuilder {
    private String sinkXML;
    private String sinkBody;
    private ArrayList<Service> services;
    private EventListenerList renderOptionsListenerList = new EventListenerList();
    private static NodeCheck sinkServiceCheck = new NodeCheck("service", null);
    private static NodeCheck moduleCheck = new NodeCheck("module", new NodeCheck[]{sinkServiceCheck});
    private static NodeCheck sinkCheck = new NodeCheck("sinkDriver", new NodeCheck[]{moduleCheck});
    private static NodeCheck pluginServiceCheck = new NodeCheck("service", null);
    private static NodeCheck pluginCheck = new NodeCheck("filterDriver", new NodeCheck[]{pluginServiceCheck});
    private static NodeCheck rootCheck = new NodeCheck("dxcSetup", new NodeCheck[]{sinkCheck, pluginCheck});

    private void fireRenderOptionsChanged(RenderOptionsEvent renderOptionsEvent) {
        Object[] objectArray = this.renderOptionsListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != RenderOptionsListener.class) continue;
            ((RenderOptionsListener)objectArray[i + 1]).renderOptionsChanged(renderOptionsEvent);
        }
    }

    private void dumpNode(int n, Node node) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("  ");
        }
        String string = stringBuilder.toString();
        System.out.println(string + node.getNodeType() + "  " + node.getNodeName());
        if (node.hasChildNodes()) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                this.dumpNode(n + 1, node2);
            }
        }
    }

    private void processDoc(NodeCheck nodeCheck, Node node, ArrayList<Service> arrayList) throws ParsecException {
        String string;
        Node node2;
        Object object;
        if (node.getNodeName().equals("service")) {
            object = node.getAttributes();
            node2 = null;
            string = null;
            if (object != null) {
                node2 = object.getNamedItem("name");
            }
            if (node2 != null) {
                string = node2.getNodeValue();
            }
            Node node3 = null;
            String string2 = null;
            if (object != null) {
                node3 = object.getNamedItem("scheme");
            }
            if (node3 != null) {
                string2 = node3.getNodeValue();
            }
            Node node4 = null;
            String string3 = null;
            if (object != null) {
                node4 = object.getNamedItem("setup");
            }
            if (node4 != null) {
                string3 = node4.getNodeValue();
            }
            if (string != null) {
                int n;
                String string4 = ParsecTools.trimString(string2);
                if (string4 != null && (n = string4.indexOf(58)) >= 0) {
                    string4 = string4.substring(0, n);
                    string4 = ParsecTools.trimString(string4);
                }
                n = ParsecTools.getServiceTypeInt(string4);
                arrayList.add(new Service(string, n));
            }
        }
        object = node.getFirstChild();
        while (object != null) {
            node2 = object.getNextSibling();
            if (object.getNodeType() == 1 && nodeCheck.childChecks != null) {
                boolean bl = false;
                for (int i = 0; i < nodeCheck.childChecks.length; ++i) {
                    if (!nodeCheck.childChecks[i].name.equals(object.getNodeName())) continue;
                    this.processDoc(nodeCheck.childChecks[i], (Node)object, arrayList);
                    bl = true;
                    break;
                }
                if (!bl) {
                    throw new ParsecException("Invalid schema");
                }
            } else if (object.getNodeType() == 3) {
                string = object.getNodeValue();
                if (string != null && string.trim().length() != 0) {
                    throw new ParsecException("Invalid schema");
                }
                node.removeChild((Node)object);
            } else {
                throw new ParsecException("Invalid schema");
            }
            object = node2;
        }
    }

    private Document parseDoc(String string) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
        document.getDocumentElement().normalize();
        return document;
    }

    public RenderSetup() {
        this.services = new ArrayList();
    }

    public void setSinkSetup(String string) throws ParsecException {
        String string2 = null;
        ArrayList<Service> arrayList = new ArrayList<Service>();
        try {
            String string3;
            if (string != null && (string3 = string.trim()).length() != 0) {
                if (!string3.startsWith("<dxcSetup>") || !string3.endsWith("</dxcSetup>")) {
                    throw new ParsecException("Invalid XML. Root schema: <dxcSetup>...</dxcSetup>");
                }
                string2 = string3.substring(10, string3.length() - 11);
                string2 = string2.stripTrailing();
                int n = 0;
                while (Character.isWhitespace(string2.charAt(n))) {
                    ++n;
                }
                --n;
                while (n >= 0 && string2.charAt(n) != '\r' && string2.charAt(n) != '\n') {
                    --n;
                }
                string2 = string2.substring(n + 1);
                Document document = this.parseDoc(string3);
                Element element = document.getDocumentElement();
                if (!RenderSetup.rootCheck.name.equals(element.getNodeName())) {
                    throw new ParsecException("Invalid root element: " + element.getNodeName());
                }
                this.processDoc(rootCheck, element, arrayList);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            GenericParsecException genericParsecException = new GenericParsecException(exception.getMessage());
            genericParsecException.initCause(exception);
            throw genericParsecException;
        }
        this.sinkXML = string;
        this.sinkBody = string2;
        this.services = arrayList;
        this.fireRenderOptionsChanged(new RenderOptionsEvent(this));
    }

    public String getSinkXML() {
        if (this.sinkXML == null) {
            return "";
        }
        return this.sinkXML;
    }

    public void addRenderOptionsListener(RenderOptionsListener renderOptionsListener) {
        this.renderOptionsListenerList.add(RenderOptionsListener.class, renderOptionsListener);
    }

    public void removeRenderOptionsListener(RenderOptionsListener renderOptionsListener) {
        this.renderOptionsListenerList.remove(RenderOptionsListener.class, renderOptionsListener);
    }

    public String[] getPatchOptions(int n) {
        if (n > 0) {
            n &= 0xFF;
        }
        if (n >= 0) {
            ArrayList<Service> arrayList = new ArrayList<Service>();
            for (Service stringArray2 : this.services) {
                if (stringArray2.type != n && stringArray2.type >= 0) continue;
                arrayList.add(stringArray2);
            }
            int n2 = 0;
            String[] stringArray = new String[arrayList.size()];
            for (Service service : arrayList) {
                stringArray[n2++] = service.name;
            }
            return stringArray;
        }
        return new String[0];
    }

    @Override
    public void buildFlowProxy(FlowProxyEditor flowProxyEditor) throws ParsecException {
        flowProxyEditor.setXML(this.getSinkXML());
    }

    private static class Service {
        String name;
        int type;

        Service(String string, int n) {
            this.name = string;
            this.type = n;
        }
    }

    private static class NodeCheck {
        String name;
        NodeCheck[] childChecks;

        NodeCheck(String string, NodeCheck[] nodeCheckArray) {
            this.name = string;
            this.childChecks = nodeCheckArray;
        }
    }
}

