/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JLabel;

public class WAlertLabel
extends JLabel {
    private int displayMode;
    private static Color IDLE_COLOR = new Color(0, 0, 0, 0);
    public static final int MODE_ICON = 0;
    public static final int MODE_ICON_AND_TEXT = 1;

    public WAlertLabel(int n) {
        super(new AlertIcon(), 2);
        this.displayMode = n;
        this.setForeground(IDLE_COLOR);
    }

    public void setAlert(String string) {
        if (string != null) {
            this.setForeground(Color.RED);
            if (this.displayMode == 1) {
                this.setText(string);
            }
        } else {
            this.setForeground(IDLE_COLOR);
            if (this.displayMode == 1) {
                this.setText("");
            }
        }
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.displayMode == 1) {
            Insets insets = this.getInsets(null);
            Font font = this.getFont();
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n = insets.left + fontMetrics.stringWidth("XXXXXXXXXXXX") + insets.right;
            int n2 = insets.top + fontMetrics.getHeight() + insets.bottom;
            return new Dimension(n, n2);
        }
        return super.getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.displayMode == 1) {
            return this.getMinimumSize();
        }
        return super.getPreferredSize();
    }

    static class AlertIcon
    implements Icon {
        AlertIcon() {
        }

        @Override
        public int getIconHeight() {
            return 11;
        }

        @Override
        public int getIconWidth() {
            return 9;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = component.getForeground();
            if (color.equals(IDLE_COLOR)) {
                return;
            }
            graphics.setColor(color);
            graphics.fillPolygon(new int[]{n, n + 8, n + 4}, new int[]{n2 + 10, n2 + 10, n2}, 3);
        }
    }
}

