/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec;

import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.config.ConfigSchema;
import dexlogic.parsec.config.SetupProvider;
import dexlogic.parsec.config.SystemProxyBuilder;
import dexlogic.parsec.config.WSystemPanel;
import dexlogic.parsec.pdcx.PDCXReader;
import dexlogic.parsec.routes.FlowProxyBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class WBaseSystemDialog
extends JDialog {
    private SetupProvider setupProvider;
    private WSystemPanel baseSystemPanel;
    private JScrollPane baseScrollPane;

    private JComponent buildSetupUI() {
        JButton jButton = new JButton("Find Sinks");
        jButton.setEnabled(false);
        JButton jButton2 = new JButton("Load...");
        jButton2.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(".");
                int n = jFileChooser.showOpenDialog(WBaseSystemDialog.this);
                if (n != 0) {
                    return;
                }
                try {
                    WBaseSystemDialog.this.loadFrom(jFileChooser.getSelectedFile());
                }
                catch (Throwable throwable) {
                    Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, WBaseSystemDialog.this);
                    ParsecTools.showExceptionDialog(frame, "Base System File Error", throwable);
                }
            }
        });
        JButton jButton3 = new JButton("Save...");
        jButton3.setEnabled(false);
        JPanel jPanel = new JPanel(new GridLayout(1, 0, 8, 0));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        return jPanel;
    }

    private JComponent buildDoneUI() {
        JButton jButton = new JButton("OK");
        jButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WBaseSystemDialog.this.setVisible(false);
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(1, 0, 8, 0));
        jPanel.add(jButton);
        return jPanel;
    }

    private JComponent buildUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.baseScrollPane = new JScrollPane();
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(0, 10, 0, 10));
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(new EmptyBorder(10, 0, 0, 0));
        jPanel3.add((Component)this.buildSetupUI(), "West");
        jPanel3.add((Component)jPanel2, "Center");
        jPanel3.add((Component)this.buildDoneUI(), "East");
        jPanel.add((Component)this.baseScrollPane, "Center");
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    @Override
    protected void processComponentEvent(ComponentEvent componentEvent) {
        if (componentEvent.getID() == 103) {
            this.removeNotify();
            this.setLocationByPlatform(false);
        }
        super.processComponentEvent(componentEvent);
    }

    public WBaseSystemDialog(Window window, SetupProvider setupProvider) {
        super(window, "Base System");
        this.setupProvider = setupProvider;
        this.enableEvents(1L);
        this.setContentPane(this.buildUI());
        this.setDefaultCloseOperation(1);
        this.baseSystemPanel = new WSystemPanel(setupProvider, ConfigSchema.baseSystemElement);
        this.baseScrollPane.setViewportView(this.baseSystemPanel);
        this.setSize(500, 400);
    }

    public void loadFrom(File file) throws ParsecException {
        PDCXReader pDCXReader = PDCXReader.readFrom(file, this.setupProvider);
        WSystemPanel wSystemPanel = pDCXReader.getBaseSystemPanel();
        if (wSystemPanel != null) {
            if (this.baseSystemPanel != null) {
                this.baseSystemPanel.discard();
            }
            this.baseSystemPanel = wSystemPanel;
            this.baseScrollPane.setViewportView(this.baseSystemPanel);
        }
    }

    public void setWorkLock(boolean bl) {
        if (this.baseSystemPanel != null) {
            this.baseSystemPanel.setWorkLock(bl);
        }
    }

    public FlowProxyBuilder getBaseProxyBuilder() {
        if (this.baseSystemPanel == null) {
            return null;
        }
        return new SystemProxyBuilder(this.baseSystemPanel);
    }
}

