/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec;

import dexlogic.parsec.FeedSetupEvent;
import dexlogic.parsec.FeedSetupListener;
import dexlogic.parsec.MediaSource;
import dexlogic.parsec.WFJackListPanel;
import dexlogic.parsec.WFPluginListPanel;
import dexlogic.parsec.WFRoutingPanel;
import dexlogic.parsec.WFTrunkListPanel;
import dexlogic.parsec.WParsecRootPane;
import dexlogic.parsec.WorkLockEvent;
import dexlogic.parsec.WorkLockListener;
import dexlogic.parsec.config.SetupProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;

public class WFeedPanel
extends JPanel {
    private SetupProvider setupProvider;
    private WFTrunkListPanel trunkListPanel;
    private EventListenerList setupListenerList = new EventListenerList();
    boolean workLockFlag;
    private EventListenerList workLockListenerList = new EventListenerList();
    MediaSource mediaSource;
    public static final int STYPE_FLAG_CHANGED_COPY = 4096;
    public static final int STYPE_FLAG_CHANGED_FORK = 8192;

    private void fireWorkLock(WorkLockEvent workLockEvent) {
        Object[] objectArray = this.workLockListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != WorkLockListener.class) continue;
            ((WorkLockListener)objectArray[i + 1]).workLockChanged(workLockEvent);
        }
    }

    private void addPlugins(WFRoutingPanel.RoutingCtl routingCtl, MediaSource.Routing routing) {
        for (MediaSource.Plugin plugin : routing.plugins) {
            WFPluginListPanel.PluginCtl pluginCtl = routingCtl.pluginListPanel.addPlugin(plugin);
            this.addPlugins(pluginCtl, plugin.routing);
        }
    }

    private void buildUI() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(8, 8, 8, 8));
        this.trunkListPanel = new WFTrunkListPanel(this);
        this.add((Component)this.trunkListPanel, "North");
        for (MediaSource.Trunk trunk : this.mediaSource.getFeed().trunks) {
            WFJackListPanel wFJackListPanel = this.trunkListPanel.addTrunk(trunk);
            for (MediaSource.Jack jack : trunk.jacks) {
                WFJackListPanel.JackCtl jackCtl = wFJackListPanel.addJack(jack);
                this.addPlugins(jackCtl, jack.routing);
                jackCtl.updateProcessingOptions();
            }
        }
    }

    void fireMediaSource(FeedSetupEvent feedSetupEvent) {
        Object[] objectArray = this.setupListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != FeedSetupListener.class) continue;
            ((FeedSetupListener)objectArray[i + 1]).mediaSourceChanged(feedSetupEvent);
        }
    }

    void setUnsavedWork() {
        Container container = SwingUtilities.getAncestorOfClass(WParsecRootPane.class, this);
        if (container != null) {
            ((WParsecRootPane)container).setUnsavedWork();
        } else {
            System.out.println("WFeedPanel/unsaved: Can't find root pane");
        }
    }

    public WFeedPanel(SetupProvider setupProvider, MediaSource mediaSource) {
        this.setupProvider = setupProvider;
        this.mediaSource = mediaSource;
        this.buildUI();
    }

    public SetupProvider getSetupProvider() {
        return this.setupProvider;
    }

    public void addSetupListener(FeedSetupListener feedSetupListener) {
        this.setupListenerList.add(FeedSetupListener.class, feedSetupListener);
    }

    public void removeSetupListener(FeedSetupListener feedSetupListener) {
        this.setupListenerList.remove(FeedSetupListener.class, feedSetupListener);
    }

    public void setLocked(boolean bl) {
        this.workLockFlag = bl;
        this.fireWorkLock(new WorkLockEvent(this));
    }

    public boolean isLocked() {
        return this.workLockFlag;
    }

    public void addWorkLockListener(WorkLockListener workLockListener) {
        this.workLockListenerList.add(WorkLockListener.class, workLockListener);
    }

    public void removeWorkLockListener(WorkLockListener workLockListener) {
        this.workLockListenerList.remove(WorkLockListener.class, workLockListener);
    }

    static JLabel createServiceTypeLabel() {
        JLabel jLabel = new JLabel();
        jLabel.setOpaque(false);
        Font font = jLabel.getFont();
        jLabel.setFont(new Font("SansSerif", 2, font.getSize() - 1));
        jLabel.setForeground(new Color(128, 128, 192));
        return jLabel;
    }

    static Color brighter(Color color, double d) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color.getAlpha();
        int n5 = (int)(1.0 / (1.0 - d));
        if (n == 0 && n2 == 0 && n3 == 0) {
            return new Color(n5, n5, n5, n4);
        }
        if (n > 0 && n < n5) {
            n = n5;
        }
        if (n2 > 0 && n2 < n5) {
            n2 = n5;
        }
        if (n3 > 0 && n3 < n5) {
            n3 = n5;
        }
        return new Color(Math.min((int)((double)n / d), 255), Math.min((int)((double)n2 / d), 255), Math.min((int)((double)n3 / d), 255), n4);
    }

    static Color darker(Color color, double d) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color.getAlpha();
        return new Color(Math.max((int)((double)n * d), 0), Math.max((int)((double)n2 * d), 0), Math.max((int)((double)n3 * d), 0), n4);
    }

    public static class CBModel<E>
    extends AbstractListModel<E>
    implements MutableComboBoxModel<E> {
        ArrayList<E> objects = new ArrayList();
        Object selectedObject;

        public CBModel() {
        }

        public CBModel(E[] EArray) {
            int n = EArray.length;
            for (int i = 0; i < n; ++i) {
                this.objects.add(EArray[i]);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedObject;
        }

        @Override
        public void setSelectedItem(Object object) {
            if (this.selectedObject != null && !this.selectedObject.equals(object) || this.selectedObject == null && object != null) {
                this.selectedObject = object;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public E getElementAt(int n) {
            if (n >= 0 && n < this.objects.size()) {
                return this.objects.get(n);
            }
            return null;
        }

        @Override
        public int getSize() {
            return this.objects.size();
        }

        @Override
        public void addElement(E e) {
            this.objects.add(e);
            this.fireIntervalAdded(this, this.objects.size() - 1, this.objects.size() - 1);
        }

        @Override
        public void insertElementAt(E e, int n) {
            this.objects.add(n, e);
            this.fireIntervalAdded(this, n, n);
        }

        @Override
        public void removeElement(Object object) {
            int n = this.objects.indexOf(object);
            if (n >= 0) {
                this.removeElementAt(n);
            }
        }

        @Override
        public void removeElementAt(int n) {
            this.objects.remove(n);
            this.fireIntervalRemoved(this, n, n);
        }
    }

    static class CBEditor
    implements ComboBoxEditor {
        protected JTextField editor = new JTextField("", 9){
            private Color validationColor;
            {
                super(string, n);
                this.validationColor = null;
            }

            @Override
            public void setText(String string) {
                if (this.getText().equals(string)) {
                    return;
                }
                super.setText(string);
                this.setCaretPosition(0);
            }

            @Override
            public Color getBackground() {
                if (this.isEnabled() && this.validationColor != null) {
                    return this.validationColor;
                }
                return super.getBackground();
            }

            @Override
            public void setBackground(Color color) {
                this.validationColor = color;
                this.repaint();
            }

            @Override
            public void setBorder(Border border) {
                Border border2 = BorderFactory.createEmptyBorder(0, 3, 0, 3);
                super.setBorder(BorderFactory.createCompoundBorder(border, border2));
            }
        };
        protected Object editorItem;

        @Override
        public Component getEditorComponent() {
            return this.editor;
        }

        @Override
        public void setItem(Object object) {
            String string = object != null ? object.toString() : null;
            this.editor.setText(string == null ? "" : string);
            this.editorItem = object;
        }

        @Override
        public Object getItem() {
            return this.editorItem;
        }

        @Override
        public void selectAll() {
            this.editor.selectAll();
            this.editor.requestFocus();
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
            this.editor.addActionListener(actionListener);
        }

        @Override
        public void removeActionListener(ActionListener actionListener) {
            this.editor.removeActionListener(actionListener);
        }
    }
}

