/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec;

import dexlogic.parsec.WEmptyRootPane;
import dexlogic.parsec.WParsecRootPane;
import dexlogic.parsec.pdcx.WPDCXRootPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;

public class WParsecFrame
extends JFrame {
    private WParsecRootPane rootPane;
    private static ArrayList<WParsecFrame> parsecFrames = new ArrayList();

    public WParsecFrame(WParsecRootPane wParsecRootPane) {
        this.setRoot(wParsecRootPane);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                WParsecFrame.closeFile(WParsecFrame.this, true);
            }
        });
    }

    public void setRoot(WParsecRootPane wParsecRootPane) {
        this.rootPane = wParsecRootPane;
        this.setTitle(wParsecRootPane.getTitle());
        this.setRootPane(wParsecRootPane);
    }

    public WParsecRootPane getRoot() {
        return this.rootPane;
    }

    public static void createFrame(WParsecRootPane wParsecRootPane) {
        WParsecFrame wParsecFrame = new WParsecFrame(wParsecRootPane);
        parsecFrames.add(wParsecFrame);
        if (wParsecRootPane instanceof WPDCXRootPane) {
            wParsecFrame.setSize(1400, 800);
        } else {
            wParsecFrame.setSize(640, 480);
        }
        wParsecFrame.setLocationByPlatform(true);
        wParsecFrame.setVisible(true);
    }

    public static boolean closeFile(WParsecFrame wParsecFrame, boolean bl) {
        JRootPane jRootPane = wParsecFrame.getRootPane();
        if (jRootPane == null || !(jRootPane instanceof WParsecRootPane)) {
            throw new RuntimeException("Invalid root pane");
        }
        WParsecRootPane wParsecRootPane = (WParsecRootPane)jRootPane;
        if (!wParsecRootPane.confirmClose()) {
            return false;
        }
        int n = parsecFrames.size();
        if (n > 1 || bl) {
            wParsecFrame.setVisible(false);
            wParsecRootPane.dispose();
            wParsecFrame.dispose();
            parsecFrames.remove(wParsecFrame);
            if (bl && n == 1) {
                System.exit(0);
            }
        } else if (!(wParsecRootPane instanceof WEmptyRootPane)) {
            wParsecFrame.setRoot(new WEmptyRootPane());
            wParsecRootPane.dispose();
            wParsecFrame.validate();
        } else {
            System.exit(0);
        }
        return true;
    }

    public static void quitSession() {
        while (parsecFrames.size() > 0 && WParsecFrame.closeFile(parsecFrames.get(0), true)) {
        }
    }

    public static void buildWindowMenu(WParsecFrame wParsecFrame, JMenu jMenu) {
        jMenu.removeAll();
        for (WParsecFrame wParsecFrame2 : parsecFrames) {
            WParsecRootPane wParsecRootPane = wParsecFrame2.getRoot();
            String string = wParsecRootPane != null ? wParsecRootPane.getTitle() : null;
            if (string == null) continue;
            JMenuItem jMenuItem = jMenu.add(string);
            jMenuItem.addActionListener(new SelectWindowAction(wParsecFrame2));
            if (wParsecFrame2 != wParsecFrame) continue;
            jMenuItem.setEnabled(false);
        }
    }

    private static class SelectWindowAction
    implements ActionListener {
        private WParsecFrame frame;

        public SelectWindowAction(WParsecFrame wParsecFrame) {
            this.frame = wParsecFrame;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.frame.toFront();
        }
    }
}

