/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.io.netscan.NetScanFeature;
import dexlogic.io.netscan.NetScanHandler;
import dexlogic.io.netscan.NetScanResult;
import dexlogic.io.netscan.NetScanServer;
import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.config.ConfigSchema;
import dexlogic.parsec.config.DefaultPortSocketAddress;
import dexlogic.parsec.config.WConfigPanel;
import java.awt.Component;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashSet;

public class NetScanMerger {
    WConfigPanel rootPanel;
    protected String featureIDKey;

    private void updateFeaturePanel(WConfigPanel wConfigPanel, NetScanFeature netScanFeature) {
        if (netScanFeature != null) {
            this.setFeatureChecked(wConfigPanel, true);
        } else {
            this.setFeatureChecked(wConfigPanel, false);
        }
    }

    private void mergeFeatures(WConfigPanel wConfigPanel, Component[] componentArray, Collection<NetScanFeature> collection) throws ParsecException {
        int n;
        int n2;
        NetScanFeature[] netScanFeatureArray = new NetScanFeature[componentArray == null ? 0 : componentArray.length];
        int[] nArray = new int[componentArray == null ? 0 : componentArray.length];
        int n3 = n2 = componentArray != null ? componentArray.length : 0;
        for (int i = 0; i < n2; ++i) {
            WConfigPanel wConfigPanel2;
            int n4;
            if (componentArray[i] instanceof WConfigPanel && (n4 = ParsecTools.getServiceTypeInt((wConfigPanel2 = (WConfigPanel)componentArray[i]).getAttrib("style"))) >= 0 && n4 <= 255) continue;
        }
        HashSet<NetScanFeature> hashSet = new HashSet<NetScanFeature>(collection);
        int n5 = n = componentArray != null ? componentArray.length : 0;
        for (n2 = 0; n2 < n; ++n2) {
            if (!(componentArray[n2] instanceof WConfigPanel)) continue;
            WConfigPanel wConfigPanel3 = (WConfigPanel)componentArray[n2];
            if (nArray[n2] <= 0) continue;
            this.updateFeaturePanel(wConfigPanel3, netScanFeatureArray[n2]);
            componentArray[n2] = null;
            hashSet.remove(netScanFeatureArray[n2]);
        }
        for (NetScanFeature netScanFeature : collection) {
            String string;
            int n6;
            int n7;
            if (!hashSet.contains(netScanFeature) || (n7 = netScanFeature.getServiceType()) < 0 || n7 > 255 || (n6 = netScanFeature.getFeatureID()) <= 0 || n6 > 255) continue;
            ConfigSchema.Element element = this.getFeatureSchema(wConfigPanel, netScanFeature);
            if (element == null) {
                throw new IllegalArgumentException("No child schema");
            }
            WConfigPanel wConfigPanel4 = WConfigPanel.createPanel(wConfigPanel.getSetupProvider(), element);
            if (wConfigPanel4 == null) {
                throw new IllegalArgumentException("Child panel creation failed");
            }
            wConfigPanel.addChildPanel(wConfigPanel4);
            wConfigPanel4.putAttrib("style", ParsecTools.getServiceTypeText(n7));
            String string2 = netScanFeature.getFeatureName();
            if (string2 != null && !string2.isEmpty()) {
                wConfigPanel4.putAttrib("name", string2);
            } else if (componentArray == null && collection.size() == 1 && (string = (String)wConfigPanel.getSetupValue("unitName")) != null && !string.isEmpty()) {
                wConfigPanel4.putAttrib("name", string);
            }
            wConfigPanel4.putSetupValue(this.featureIDKey, n6);
            this.updateFeaturePanel(wConfigPanel4, netScanFeature);
        }
    }

    private void updateServerPanel(WConfigPanel wConfigPanel, NetScanServer netScanServer) throws ParsecException {
        int n;
        InetSocketAddress inetSocketAddress;
        Component[] componentArray = wConfigPanel.getStemPanels();
        InetSocketAddress inetSocketAddress2 = inetSocketAddress = netScanServer == null ? null : netScanServer.getDefaultAddress();
        if (inetSocketAddress != null) {
            int n2;
            DefaultPortSocketAddress defaultPortSocketAddress;
            String string;
            Object object = netScanServer.getHostID();
            if (!object.equals(wConfigPanel.getSetupValue("unitID"))) {
                wConfigPanel.putSetupValue("unitID", object);
            }
            if (!ParsecTools.compareString(string = netScanServer.getHostName(), (String)wConfigPanel.getSetupValue("unitName"))) {
                wConfigPanel.putSetupValue("unitName", string);
            }
            if (!(defaultPortSocketAddress = new DefaultPortSocketAddress(inetSocketAddress, n2 = this.getDefaultPort())).equals(wConfigPanel.getSetupValue("remoteAddress"))) {
                wConfigPanel.putSetupValue("remoteAddress", defaultPortSocketAddress);
            }
            this.mergeFeatures(wConfigPanel, componentArray, netScanServer.getFeatureCollection());
            this.setServerChecked(wConfigPanel, true);
        } else {
            this.setServerChecked(wConfigPanel, false);
        }
        int n3 = n = componentArray != null ? componentArray.length : 0;
        for (int i = 0; i < n; ++i) {
            if (!(componentArray[i] instanceof WConfigPanel)) continue;
            this.updateFeaturePanel((WConfigPanel)componentArray[i], null);
        }
    }

    private void mergeScanServers(Component[] componentArray, Collection<NetScanServer> collection) throws ParsecException {
        int n;
        Serializable serializable;
        Object object;
        int n2;
        NetScanServer[] netScanServerArray = new NetScanServer[componentArray == null ? 0 : componentArray.length];
        int[] nArray = new int[componentArray == null ? 0 : componentArray.length];
        int n3 = n2 = componentArray != null ? componentArray.length : 0;
        for (int i = 0; i < n2; ++i) {
            if (!(componentArray[i] instanceof WConfigPanel)) continue;
            WConfigPanel wConfigPanel = (WConfigPanel)componentArray[i];
            object = wConfigPanel.getSetupValue("remoteAddress");
            serializable = null;
            if (object instanceof DefaultPortSocketAddress) {
                serializable = ((DefaultPortSocketAddress)object).getInetSocketAddress();
            }
            int n4 = serializable == null ? -1 : ((InetSocketAddress)serializable).getPort();
            Object object2 = wConfigPanel.getSetupValue("unitID");
            Object object3 = wConfigPanel.getSetupValue("unitName");
            if (object3 != null) {
                object3 = object3.toString();
            }
            if (object3 != null && ((String)object3).isEmpty()) {
                object3 = null;
            }
            for (NetScanServer netScanServer : collection) {
                InetSocketAddress inetSocketAddress = netScanServer.getDefaultAddress();
                int n5 = inetSocketAddress == null ? -1 : inetSocketAddress.getPort();
                boolean bl = serializable != null && ((InetSocketAddress)serializable).equals(inetSocketAddress);
                boolean bl2 = n4 > 0 && n4 == n5;
                boolean bl3 = object3 != null && object3.equals(netScanServer.getHostName());
                int n6 = 0;
                if (object2 != null && object2.equals(netScanServer.getHostID())) {
                    n6 = bl3 && bl ? 10 : (bl3 && bl2 ? 9 : (bl3 ? 8 : 7));
                } else if (object2 == null) {
                    if (bl3 && bl) {
                        n6 = 5;
                    } else if (bl3 && bl2) {
                        n6 = 4;
                    } else if (bl3) {
                        n6 = 3;
                    } else if (bl) {
                        n6 = 2;
                    }
                }
                if (n6 <= nArray[i]) continue;
                nArray[i] = n6;
                netScanServerArray[i] = netScanServer;
            }
        }
        HashSet<NetScanServer> hashSet = new HashSet<NetScanServer>(collection);
        int n7 = n = componentArray != null ? componentArray.length : 0;
        for (n2 = 0; n2 < n; ++n2) {
            if (!(componentArray[n2] instanceof WConfigPanel)) continue;
            object = (WConfigPanel)componentArray[n2];
            if (nArray[n2] <= 0) continue;
            this.updateServerPanel((WConfigPanel)object, netScanServerArray[n2]);
            componentArray[n2] = null;
            hashSet.remove(netScanServerArray[n2]);
        }
        for (NetScanServer netScanServer : collection) {
            if (!hashSet.contains(netScanServer)) continue;
            object = this.getServerSchema(this.rootPanel, netScanServer);
            if (object == null) {
                throw new IllegalArgumentException("No child schema");
            }
            serializable = WConfigPanel.createPanel(this.rootPanel.getSetupProvider(), (ConfigSchema.Element)object);
            if (serializable == null) {
                throw new IllegalArgumentException("Child panel creation failed");
            }
            this.rootPanel.addChildPanel((WConfigPanel)serializable);
            this.updateServerPanel((WConfigPanel)serializable, netScanServer);
        }
    }

    private void updateRootPanel(NetScanResult netScanResult) throws ParsecException {
        int n;
        int n2;
        Component[] componentArray = this.rootPanel.getStemPanels();
        NetScanHandler[] netScanHandlerArray = netScanResult.getScanHandlers();
        int n3 = n2 = netScanHandlerArray != null ? netScanHandlerArray.length : 0;
        for (n = 0; n < n2; ++n) {
            this.mergeScanServers(componentArray, netScanHandlerArray[n].getServerCollection());
        }
        int n4 = n2 = componentArray != null ? componentArray.length : 0;
        for (n = 0; n < n2; ++n) {
            if (!(componentArray[n] instanceof WConfigPanel)) continue;
            this.updateServerPanel((WConfigPanel)componentArray[n], null);
        }
    }

    protected int getDefaultPort() {
        return -1;
    }

    protected ConfigSchema.Element getServerSchema(WConfigPanel wConfigPanel, NetScanServer netScanServer) {
        return null;
    }

    protected ConfigSchema.Element getFeatureSchema(WConfigPanel wConfigPanel, NetScanFeature netScanFeature) {
        return null;
    }

    protected void setServerChecked(WConfigPanel wConfigPanel, boolean bl) {
    }

    protected void setFeatureChecked(WConfigPanel wConfigPanel, boolean bl) {
    }

    public NetScanMerger(WConfigPanel wConfigPanel) {
        this.rootPanel = wConfigPanel;
    }

    public void mergeScanResult(NetScanResult netScanResult) {
        Throwable throwable = netScanResult.getException();
        if (throwable != null) {
            String string = "Network scan error";
            ParsecTools.showExceptionDialog(this.rootPanel, string, throwable);
            return;
        }
        this.rootPanel.getSetupProvider().appendLog(netScanResult.getLog());
        try {
            this.updateRootPanel(netScanResult);
        }
        catch (Throwable throwable2) {
            String string = "Scan result merge error";
            ParsecTools.showExceptionDialog(this.rootPanel, string, throwable2);
        }
    }
}

