/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.parsec.RefinedCBEditor;
import dexlogic.parsec.RefinedCBModel;
import dexlogic.parsec.config.ConfigSchema;
import dexlogic.parsec.config.FilterSpec;
import dexlogic.parsec.config.PluginStyle;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class UPluginCombo
extends JComboBox<FilterSpec> {
    private boolean optionsValid = false;
    private FilterSpec verifiedOption;

    private void verifyAndSelect(Object object) {
        RefinedCBModel refinedCBModel = (RefinedCBModel)this.getModel();
        FilterSpec filterSpec = null;
        if (object != null) {
            int n = refinedCBModel.getSize();
            for (int i = 0; i < n; ++i) {
                FilterSpec filterSpec2 = (FilterSpec)refinedCBModel.getElementAt(i);
                if ((!(object instanceof FilterSpec) || !object.equals(filterSpec2)) && (!(object instanceof String) || !object.equals(filterSpec2.toString()))) continue;
                filterSpec = filterSpec2;
                break;
            }
        }
        this.verifiedOption = filterSpec;
        Object object2 = refinedCBModel.getSelectedItem();
        if (this.verifiedOption != null && object2 != this.verifiedOption) {
            if (this.verifiedOption.equals(object2)) {
                refinedCBModel.setSelectedItem(this.verifiedOption);
            } else {
                super.setSelectedItem(this.verifiedOption);
            }
        } else if (object != object2) {
            super.setSelectedItem(object);
        }
        Component component = this.getEditor().getEditorComponent();
        if (this.verifiedOption != null) {
            component.setBackground(new Color(11071656));
        } else if (!this.optionsValid) {
            component.setBackground(null);
        } else {
            component.setBackground(new Color(0xFFA0A0));
        }
    }

    public UPluginCombo() {
        super(new RefinedCBModel<FilterSpec>(new FilterSpec[]{new TransparentSpec()}));
        this.setEditable(true);
        this.setEditor(new RefinedCBEditor());
        JTextField jTextField = (JTextField)this.getEditor().getEditorComponent();
        jTextField.setEditable(false);
        this.setSelectedItem(this.dataModel.getElementAt(0));
    }

    public void putStyleAttrib(String string) {
        PluginStyle pluginStyle = new PluginStyle(string);
        String string2 = pluginStyle.getDriverID();
        String string3 = pluginStyle.getStyle();
        if (string3 == null) {
            this.setSelectedIndex(0);
        } else if (string2 == null) {
            this.setSelectedItem(string3);
        } else {
            this.setSelectedItem(new WildcardSpec(string2, string3));
        }
    }

    public String getStyleAttrib() {
        Object object = this.getSelectedItem();
        if (object instanceof TransparentSpec) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof WildcardSpec) {
            WildcardSpec wildcardSpec = (WildcardSpec)object;
            String string = wildcardSpec.driverID;
            String string2 = wildcardSpec.getStyle();
            return PluginStyle.toString(string, string2);
        }
        if (object instanceof FilterSpec) {
            FilterSpec filterSpec = (FilterSpec)object;
            ConfigSchema.FilterDriver filterDriver = filterSpec.getDriver();
            String string = filterDriver == null ? null : filterDriver.getDriverID();
            String string3 = filterSpec.getStyle();
            return PluginStyle.toString(string, string3);
        }
        return null;
    }

    public FilterSpec getVerifiedFilterSpec() {
        return this.verifiedOption;
    }

    public void setFilterOptions(FilterSpec[] filterSpecArray) {
        RefinedCBModel refinedCBModel = (RefinedCBModel)this.getModel();
        int n = refinedCBModel.getSize();
        if (n > 1) {
            refinedCBModel.removeRange(1, n);
        }
        refinedCBModel.addAll(filterSpecArray);
        this.optionsValid = filterSpecArray != null;
        this.verifyAndSelect(this.getSelectedItem());
    }

    @Override
    public void setSelectedItem(Object object) {
        if (object instanceof String && ((String)object).strip().length() == 0) {
            object = this.dataModel.getElementAt(0);
        }
        this.verifyAndSelect(object);
    }

    public static class WildcardSpec
    extends FilterSpec {
        public String driverID;

        public WildcardSpec(String string, String string2) {
            super(string2, null, null, null);
            this.driverID = string;
        }

        @Override
        public String getDriverID() {
            return this.driverID;
        }
    }

    public static class TransparentSpec
    extends FilterSpec {
        public TransparentSpec() {
            super("transparent", null, null, null);
        }

        @Override
        public int getLaneCount() {
            return -1;
        }

        @Override
        public int getLaneInputType(int n) {
            return 0;
        }

        @Override
        public int getLaneOutputType(int n) {
            return 0;
        }
    }
}

