/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.config.ServiceInfo;
import dexlogic.parsec.config.SetupProvider;
import java.awt.Color;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class UServiceField
extends JTextField {
    private SetupProvider setupProvider;
    private int inputType = -1;
    private ServiceInfo serviceInfo = null;
    private boolean serviceActiveFlag = true;

    private void setActive(boolean bl) {
        if (!this.serviceActiveFlag && bl) {
            this.setBackground(UIManager.getColor("TextField.background"));
        } else if (this.serviceActiveFlag && !bl) {
            this.setBackground(new Color(0xFFA0A0));
        }
        this.serviceActiveFlag = bl;
    }

    private void serviceChanged() {
        ServiceInfo serviceInfo = null;
        String string = ParsecTools.stripString(this.getText());
        if (string != null && string.length() > 0 && this.inputType >= 0) {
            serviceInfo = new ServiceInfo(string, this.inputType){

                @Override
                void setActive(boolean bl) {
                    UServiceField.this.setActive(bl);
                }
            };
        }
        if (this.serviceInfo == null && serviceInfo != null || this.serviceInfo != null && !this.serviceInfo.equals(serviceInfo)) {
            this.setupProvider.serviceUpdate(this.serviceInfo, serviceInfo);
            this.serviceInfo = serviceInfo;
            if (this.serviceInfo == null) {
                this.setActive(true);
            }
        }
        this.fireActionPerformed();
    }

    public UServiceField(SetupProvider setupProvider) {
        super(14);
        this.setupProvider = setupProvider;
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                UServiceField.this.serviceChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                UServiceField.this.serviceChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                UServiceField.this.serviceChanged();
            }
        });
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        this.serviceChanged();
    }

    public void setInputType(int n) {
        this.inputType = n;
        this.serviceChanged();
    }

    public int getInputType() {
        return this.inputType;
    }
}

