/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.config.ServiceInfo;
import dexlogic.parsec.config.SetupProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class UServicePanel
extends JPanel {
    private SetupProvider setupProvider;
    private int inputType = -1;
    private JTextField serviceNameField;
    private ServiceInfo serviceInfo;

    private void serviceChanged() {
        ServiceInfo serviceInfo = this.serviceInfo;
        ServiceInfo serviceInfo2 = null;
        String string = ParsecTools.stripString(this.serviceNameField.getText());
        if (string != null && this.inputType >= 0) {
            serviceInfo2 = new ServiceInfo(string, this.inputType);
        } else if (serviceInfo == null) {
            return;
        }
        if (serviceInfo == null || serviceInfo2 == null || !serviceInfo.equals(serviceInfo2)) {
            this.setupProvider.serviceChanged(serviceInfo, serviceInfo2);
            this.serviceInfo = serviceInfo2;
        }
    }

    public UServicePanel(SetupProvider setupProvider) {
        super(new BorderLayout());
        this.setupProvider = setupProvider;
        this.serviceNameField = new JTextField(14);
        this.add((Component)this.serviceNameField, "Center");
        this.serviceNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                UServicePanel.this.serviceChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                UServicePanel.this.serviceChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                UServicePanel.this.serviceChanged();
            }
        });
    }

    public void setServiceName(String string) {
        this.serviceNameField.setText(string);
        this.serviceChanged();
    }

    public String getServiceName() {
        return this.serviceNameField.getText();
    }

    public void setInputType(int n) {
        this.inputType = n;
        this.serviceChanged();
    }

    public int getInputType() {
        return this.inputType;
    }
}

