/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.io.dln.DLNUnitID;
import dexlogic.io.netscan.NetScanExplorer;
import dexlogic.io.netscan.NetScanResult;
import dexlogic.io.netscan.proto.DLNFeedScanHandler;
import dexlogic.io.netscan.proto.DLNFeedServer;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.config.ConfigSchema;
import dexlogic.parsec.config.DLNCaptureMerger;
import dexlogic.parsec.config.DLNServerMerger;
import dexlogic.parsec.config.DefaultPortSocketAddress;
import dexlogic.parsec.config.ScanResultMerger;
import dexlogic.parsec.config.SetupProvider;
import dexlogic.parsec.config.UMenuButton;
import dexlogic.parsec.config.WConfigPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetSocketAddress;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class WCollectorPanel
extends WConfigPanel {
    private JMenuItem findEmittersItem;

    private void mergeScanResult(NetScanResult netScanResult) {
        DLNServerMerger dLNServerMerger = new DLNServerMerger(new DLNCaptureMerger());
        ScanResultMerger scanResultMerger = new ScanResultMerger(dLNServerMerger){

            @Override
            public void merge(WConfigPanel wConfigPanel, NetScanResult netScanResult) {
                try {
                    super.merge(wConfigPanel, netScanResult);
                }
                finally {
                    WCollectorPanel.this.findEmittersItem.setEnabled(true);
                }
            }
        };
        scanResultMerger.merge(this, netScanResult);
    }

    private void findIDNEmitters(Object object) {
        int n;
        this.findEmittersItem.setEnabled(false);
        DLNFeedScanHandler dLNFeedScanHandler = new DLNFeedScanHandler();
        Component[] componentArray = this.getStemPanels();
        int n2 = n = componentArray != null ? componentArray.length : 0;
        for (int i = 0; i < n; ++i) {
            Object object2;
            WConfigPanel wConfigPanel;
            Object object3;
            if (!(componentArray[i] instanceof WConfigPanel) || !((object3 = (wConfigPanel = (WConfigPanel)componentArray[i]).getSetupValue("unitID")) instanceof DLNUnitID) || !((object2 = wConfigPanel.getSetupValue("remoteAddress")) instanceof DefaultPortSocketAddress)) continue;
            InetSocketAddress inetSocketAddress = ((DefaultPortSocketAddress)object2).getInetSocketAddress();
            dLNFeedScanHandler.putServer(new DLNFeedServer((DLNUnitID)object3, inetSocketAddress));
        }
        try {
            new NetScanExplorer(dLNFeedScanHandler){

                @Override
                protected void scanEnded(NetScanResult netScanResult) {
                    SwingUtilities.invokeLater(new Runnable(){
                        NetScanResult scanResult;

                        public Runnable init(NetScanResult netScanResult) {
                            this.scanResult = netScanResult;
                            return this;
                        }

                        @Override
                        public void run() {
                            WCollectorPanel.this.mergeScanResult(this.scanResult);
                        }
                    }.init(netScanResult));
                }
            }.runScan(object);
        }
        catch (Throwable throwable) {
            this.findEmittersItem.setEnabled(true);
            String string = "Network scan setup error";
            ParsecTools.showExceptionDialog(this, string, throwable);
        }
    }

    private void amendControlPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        JLabel jLabel = new JLabel(this.getElementSchema().toString());
        jLabel.setOpaque(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
    }

    @Override
    protected void addPopupItemsCmd(UMenuButton uMenuButton) {
        super.addPopupItemsCmd(uMenuButton);
        this.findEmittersItem = uMenuButton.addItem(new JMenuItem("Find IDN Emitters"));
        this.findEmittersItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WCollectorPanel.this.findIDNEmitters(null);
            }
        });
    }

    public WCollectorPanel(SetupProvider setupProvider, ConfigSchema.Element element) {
        super(setupProvider, element);
        this.childIndent = 15;
        this.amendControlPanel(this.getControlPanel());
    }
}

