/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.parsec.GenericParsecException;
import dexlogic.parsec.InternalParsecException;
import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.SetupArgIO;
import dexlogic.parsec.config.ConfigSchema;
import dexlogic.parsec.config.InvalidValueWrapper;
import dexlogic.parsec.config.SVMeta;
import dexlogic.parsec.config.SetupProvider;
import dexlogic.parsec.config.UMenuButton;
import dexlogic.parsec.config.WBranchPanel;
import dexlogic.parsec.remote.ObjectRemotable;
import dexlogic.parsec.routes.LocalObjectAgent;
import dexlogic.parsec.routes.RPCInvokeAdapter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class WConfigPanel
extends JComponent
implements ObjectRemotable {
    private SetupProvider setupProvider;
    private ConfigSchema.Element elementSchema;
    private Map<String, String> attribMap;
    private Map<String, SetupParam> setupMap;
    private JLabel paramLabel;
    private UMenuButton menuButton;
    private JMenuItem discardItem;
    private JMenuItem moveUpItem;
    private JMenuItem moveDnItem;
    private JComponent branchContainer;
    private JComponent stemContainer;
    private LocalObjectAgent localObjectAgent;
    protected int childIndent = 0;
    private static ImageIcon settingsIcon;
    private static ImageIcon changeIcon;
    protected static final int SERVICE_NAME_COLUMN_COUNT = 14;

    private JPanel buildControlPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        this.menuButton = new UMenuButton(this);
        gridBagConstraints.gridx = 10;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 20;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.menuButton, gridBagConstraints);
        return jPanel;
    }

    private void createBranchContainer() {
        this.branchContainer = Box.createVerticalBox();
        this.branchContainer.setOpaque(true);
        this.add((Component)this.branchContainer, 1);
    }

    private void createStemContainer() {
        this.stemContainer = Box.createVerticalBox();
        this.stemContainer.setOpaque(true);
        this.add(this.stemContainer);
    }

    private void discard(Component[] componentArray) {
        int n;
        int n2 = n = componentArray == null ? 0 : componentArray.length;
        for (int i = 0; i < n; ++i) {
            if (componentArray[i] instanceof WConfigPanel) {
                ((WConfigPanel)componentArray[i]).discard();
                continue;
            }
            if (!(componentArray[i] instanceof Container)) continue;
            Component[] componentArray2 = ((Container)componentArray[i]).getComponents();
            ((Container)componentArray[i]).removeAll();
            this.discard(componentArray2);
        }
    }

    private void paramEditorDialog(ConfigSchema.Param param) {
        String string = param.getName();
        Object object = this.getSetupValue(param.getName());
        Object object2 = this.getDefaultValue(string);
        String string2 = "Parameter Editor";
        Object object3 = string;
        if (object2 != null) {
            object3 = (String)object3 + "  default(empty): " + object2.toString();
        }
        int n = 3;
        int n2 = 2;
        JOptionPane jOptionPane = new JOptionPane(object3, n, n2, null, null, null);
        jOptionPane.setWantsInput(true);
        jOptionPane.setInitialSelectionValue(object);
        jOptionPane.setComponentOrientation(this.getComponentOrientation());
        JDialog jDialog = jOptionPane.createDialog(this, string2);
        jOptionPane.selectInitialValue();
        jDialog.setVisible(true);
        jDialog.dispose();
        Object object4 = jOptionPane.getValue();
        if (!(object4 instanceof Integer) || (Integer)object4 != 0) {
            return;
        }
        Object object5 = jOptionPane.getInputValue();
        if (!(object5 instanceof String)) {
            this.putSetupValue(string, null);
        } else if (((String)(object5 = ((String)object5).strip())).isEmpty()) {
            this.putSetupValue(string, null);
        } else if (object5.equals(object2)) {
            this.putSetupValue(string, null);
        } else {
            this.putSetupValue(string, (String)object5);
        }
    }

    protected void dumpAttribMap() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.attribMap != null) {
            for (Map.Entry<String, String> entry : this.attribMap.entrySet()) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(entry.getKey());
                stringBuilder.append("='");
                stringBuilder.append(entry.getValue());
                stringBuilder.append("'");
            }
        }
        System.out.println(stringBuilder.toString());
    }

    protected JPanel getControlPanel() {
        return (JPanel)this.getComponent(0);
    }

    protected JLabel getParamLabel() {
        if (this.paramLabel == null) {
            this.paramLabel = WConfigPanel.createParamLabel();
            this.paramLabel.setOpaque(false);
            this.updateParamLabel();
        }
        return this.paramLabel;
    }

    protected boolean getParamMutable(ConfigSchema.Param param) {
        return param.isMutable();
    }

    protected void buildParamString(StringBuilder stringBuilder) {
        ConfigSchema.Param[] paramArray = this.elementSchema.getParams();
        if (paramArray == null) {
            return;
        }
        for (ConfigSchema.Param param : paramArray) {
            if (!param.isOutline()) continue;
            String string = param.getName();
            Object object = this.getSetupValue(param.getName());
            boolean bl = false;
            if (object == null && (object = this.getDefaultValue(string)) != null) {
                bl = true;
            }
            if (object == null) continue;
            boolean bl2 = object instanceof InvalidValueWrapper;
            if (stringBuilder.length() != 0) {
                stringBuilder.append("&nbsp;&nbsp;");
            }
            stringBuilder.append(string);
            stringBuilder.append(":");
            if (bl) {
                stringBuilder.append("<span style='color:#4040C0'>");
            }
            if (bl2) {
                stringBuilder.append("<span style='background:#FF8080;color:#ffffff'>");
            }
            stringBuilder.append("&nbsp;");
            stringBuilder.append(object.toString());
            stringBuilder.append("&nbsp;");
            if (bl2) {
                stringBuilder.append("</span>");
            }
            if (!bl) continue;
            stringBuilder.append("</span>");
        }
    }

    protected void updateParamLabel() {
        if (this.paramLabel == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.buildParamString(stringBuilder);
        if (stringBuilder.length() > 0) {
            stringBuilder.insert(0, "<html>");
            stringBuilder.append("</html>");
        }
        this.paramLabel.setText(stringBuilder.toString());
    }

    protected WConfigPanel getParentConfigPanel() {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof WConfigPanel)) continue;
            return (WConfigPanel)container;
        }
        return null;
    }

    protected void setCompEnabled(JComponent jComponent, boolean bl) {
        if (jComponent.isEnabled() != bl) {
            jComponent.setEnabled(bl);
        }
    }

    protected void verifyConfig() {
    }

    protected JMenuItem createPopupItemNew(UMenuButton uMenuButton, ConfigSchema.Element element) {
        return uMenuButton.addItemNew(this, element);
    }

    protected void addPopupItemsNew(UMenuButton uMenuButton) {
        int n;
        ConfigSchema.Element[] elementArray = this.elementSchema.getChildSchemas();
        int n2 = n = elementArray == null ? 0 : elementArray.length;
        for (int i = 0; i < n; ++i) {
            ConfigSchema.Element element = elementArray[i];
            if (element == null) {
                uMenuButton.addSeparator();
                continue;
            }
            if (element.isConcealed() || element.isDesignated()) continue;
            this.createPopupItemNew(uMenuButton, element);
        }
    }

    protected void addPopupItemsCmd(UMenuButton uMenuButton) {
    }

    protected void addPopupItemsParam(UMenuButton uMenuButton) {
        ConfigSchema.Param[] paramArray = this.elementSchema.getParams();
        if (paramArray != null) {
            for (ConfigSchema.Param param : paramArray) {
                if (param.isConcealed()) continue;
                String string = param.getName();
                Object object = this.getSetupValue(param.getName());
                boolean bl = this.getParamMutable(param);
                boolean bl2 = false;
                if (object == null && (object = this.getDefaultValue(string)) != null) {
                    bl2 = true;
                }
                if (object == null) {
                    object = "";
                }
                boolean bl3 = object instanceof InvalidValueWrapper;
                StringBuilder stringBuilder = new StringBuilder();
                if (bl2 || bl3) {
                    stringBuilder.append("<html>");
                }
                stringBuilder.append(string);
                stringBuilder.append(":");
                if (bl2) {
                    stringBuilder.append("<span style='color:#4040C0'>");
                }
                if (bl3) {
                    stringBuilder.append("<span style='background:#FF8080;color:#ffffff'>");
                }
                stringBuilder.append("  ");
                stringBuilder.append(object);
                stringBuilder.append(" ");
                if (bl3) {
                    stringBuilder.append("</span>");
                }
                if (bl2) {
                    stringBuilder.append("</span>");
                }
                if (bl2 || bl3) {
                    stringBuilder.append("</html>");
                }
                JMenuItem jMenuItem = uMenuButton.addItem(new JMenuItem(stringBuilder.toString()));
                if (bl) {
                    jMenuItem.addActionListener(new AbstractAction(){
                        private ConfigSchema.Param paramSchema;

                        public AbstractAction init(ConfigSchema.Param param) {
                            this.paramSchema = param;
                            return this;
                        }

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            WConfigPanel.this.paramEditorDialog(this.paramSchema);
                        }
                    }.init(param));
                    continue;
                }
                jMenuItem.setEnabled(false);
            }
        }
    }

    protected void buildPopupMenu(UMenuButton uMenuButton) {
        JMenuItem jMenuItem;
        int n = 0;
        this.addPopupItemsNew(uMenuButton);
        n = uMenuButton.getItemCount();
        this.addPopupItemsCmd(uMenuButton);
        uMenuButton.insertSeparator(n);
        n = uMenuButton.getItemCount();
        if (!this.elementSchema.isDesignated()) {
            jMenuItem = this.discardItem = uMenuButton.addItem(new JMenuItem("Discard"));
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WConfigPanel.this.discard();
                }
            });
        }
        uMenuButton.insertSeparator(n);
        if (uMenuButton.getItemCount() != 0) {
            uMenuButton.addSeparator();
        }
        jMenuItem = this.moveUpItem = uMenuButton.addItem(new JMenuItem("Move Up"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WConfigPanel wConfigPanel = WConfigPanel.this;
                Container container = wConfigPanel.getParent();
                int n = container.getComponentZOrder(wConfigPanel);
                container.setComponentZOrder(wConfigPanel, n - 1);
                container.revalidate();
            }
        });
        jMenuItem = this.moveDnItem = uMenuButton.addItem(new JMenuItem("Move Down"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WConfigPanel wConfigPanel = WConfigPanel.this;
                Container container = wConfigPanel.getParent();
                int n = container.getComponentZOrder(wConfigPanel);
                container.setComponentZOrder(wConfigPanel, n + 1);
                container.revalidate();
            }
        });
        n = uMenuButton.getItemCount();
        this.addPopupItemsParam(uMenuButton);
        uMenuButton.insertSeparator(n);
        uMenuButton.insertSeparator(n);
    }

    protected void resetPopupMenu() {
        if (this.menuButton != null) {
            this.menuButton.resetPopupMenu();
        }
    }

    protected boolean evalReorderItemsEnabled() {
        return true;
    }

    protected boolean evalPanelEnabled() {
        return true;
    }

    protected void updateUIState() {
        boolean bl = this.evalPanelEnabled();
        if (this.branchContainer != null) {
            this.branchContainer.setVisible(bl);
        }
        if (this.stemContainer != null) {
            this.stemContainer.setVisible(bl);
        }
        this.setCompEnabled(this.menuButton, true);
    }

    protected void updatePopupItems() {
        boolean bl;
        boolean bl2 = this.evalReorderItemsEnabled();
        if (this.discardItem != null) {
            this.setCompEnabled(this.discardItem, bl2);
        }
        Container container = this.getParent();
        int n = container.getComponentZOrder(this);
        int n2 = container.getComponentCount() - 1;
        boolean bl3 = bl2 && n > 0;
        boolean bl4 = bl = bl2 && n < n2;
        if (this.moveUpItem != null) {
            this.setCompEnabled(this.moveUpItem, bl3);
        }
        if (this.moveDnItem != null) {
            this.setCompEnabled(this.moveDnItem, bl);
        }
    }

    protected void branchContainerChanged() {
    }

    protected void stemContainerChanged() {
    }

    protected void ensureLocalObjectAgent() {
        if (this.localObjectAgent == null) {
            this.localObjectAgent = new LocalObjectAgent();
        }
    }

    public WConfigPanel(SetupProvider setupProvider, ConfigSchema.Element element) {
        if (setupProvider == null) {
            throw new IllegalArgumentException("Invalid setup provider parameter");
        }
        this.setupProvider = setupProvider;
        if (element == null) {
            throw new IllegalArgumentException("Invalid schema item parameter");
        }
        this.elementSchema = element;
        this.add((Component)this.buildControlPanel(), 0);
        ConfigSchema.Param[] paramArray = element.getParams();
        if (paramArray != null) {
            for (ConfigSchema.Param param : paramArray) {
                if (this.setupMap == null) {
                    this.setupMap = new LinkedHashMap<String, SetupParam>();
                }
                this.setupMap.put(param.getName(), new SetupParam(param));
            }
        }
    }

    public SetupProvider getSetupProvider() {
        return this.setupProvider;
    }

    public ConfigSchema.Element getElementSchema() {
        return this.elementSchema;
    }

    public void discard() {
        WConfigPanel wConfigPanel = this.getParentConfigPanel();
        if (wConfigPanel != null) {
            wConfigPanel.removeChildPanel(this);
            wConfigPanel.revalidate();
        }
        Component[] componentArray = this.getBranchPanels();
        if (this.branchContainer != null) {
            this.branchContainer.removeAll();
        }
        this.discard(componentArray);
        Component[] componentArray2 = this.getStemPanels();
        if (this.stemContainer != null) {
            this.stemContainer.removeAll();
        }
        this.discard(componentArray2);
    }

    public void putSetupValue(String string, Object object) {
        SetupParam setupParam;
        SetupParam setupParam2 = setupParam = this.setupMap == null ? null : this.setupMap.get(string);
        if (setupParam == null) {
            throw new IllegalArgumentException("Invalid setup parameter name: " + string);
        }
        SVMeta sVMeta = setupParam.getMeta();
        if (sVMeta != null) {
            object = sVMeta.parse(object);
        }
        setupParam.currentValue = object;
        this.resetPopupMenu();
        if (this.getParent() != null) {
            this.getSetupProvider().setUnsavedWork();
        }
        if (setupParam.getParamSchema().isOutline()) {
            this.updateParamLabel();
        }
    }

    public Object getSetupValue(String string) {
        SetupParam setupParam;
        SetupParam setupParam2 = setupParam = this.setupMap == null ? null : this.setupMap.get(string);
        if (setupParam == null) {
            throw new IllegalArgumentException("Invalid setup parameter name: " + string);
        }
        return setupParam.currentValue;
    }

    public Object getDefaultValue(String string) {
        SetupParam setupParam;
        SetupParam setupParam2 = setupParam = this.setupMap == null ? null : this.setupMap.get(string);
        if (setupParam == null) {
            throw new IllegalArgumentException("Invalid setup parameter name: " + string);
        }
        return setupParam.getParamSchema().getDefaultValue();
    }

    public void putAttrib(String string, String string2) {
        if (string.equals("setup")) {
            SetupArgIO.readArg(string2, new SetupArgIO(){

                @Override
                public void processParam(String string, String string2) {
                    WConfigPanel.this.putSetupValue(string, string2);
                }
            });
        } else {
            if (this.attribMap == null) {
                this.attribMap = new HashMap<String, String>();
            }
            this.attribMap.put(string, string2);
            this.resetPopupMenu();
            if (this.getParent() != null) {
                this.getSetupProvider().setUnsavedWork();
            }
        }
    }

    public String getAttrib(String string) {
        if (string.equals("setup")) {
            ConfigSchema.Param[] paramArray = this.elementSchema.getParams();
            if (paramArray == null) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (ConfigSchema.Param param : paramArray) {
                String string2 = param.getName();
                Object object = this.getSetupValue(param.getName());
                if (object == null) continue;
                SetupArgIO.writeParam(stringBuilder, string2, object.toString());
            }
            return stringBuilder.toString();
        }
        if (this.attribMap == null) {
            return null;
        }
        return this.attribMap.get(string);
    }

    public LocalObjectAgent getObjectAgent() {
        return this.localObjectAgent;
    }

    public int getBranchPanelCount() {
        if (this.branchContainer == null) {
            return 0;
        }
        return this.branchContainer.getComponentCount();
    }

    public WConfigPanel getBranchPanel(int n) {
        if (this.branchContainer == null) {
            return null;
        }
        if (n < 0 || n >= this.branchContainer.getComponentCount()) {
            return null;
        }
        Component component = this.branchContainer.getComponent(n);
        return component instanceof WConfigPanel ? (WConfigPanel)component : null;
    }

    public Component[] getBranchPanels() {
        if (this.branchContainer == null) {
            return null;
        }
        Component[] componentArray = this.branchContainer.getComponents();
        if (componentArray == null || componentArray.length == 0) {
            return null;
        }
        return componentArray;
    }

    public int getStemPanelCount() {
        if (this.stemContainer == null) {
            return 0;
        }
        return this.stemContainer.getComponentCount();
    }

    public WConfigPanel getStemPanel(int n) {
        if (this.stemContainer == null) {
            return null;
        }
        if (n < 0 || n >= this.stemContainer.getComponentCount()) {
            return null;
        }
        Component component = this.stemContainer.getComponent(n);
        return component instanceof WConfigPanel ? (WConfigPanel)component : null;
    }

    public Component[] getStemPanels() {
        if (this.stemContainer == null) {
            return null;
        }
        Component[] componentArray = this.stemContainer.getComponents();
        if (componentArray == null || componentArray.length == 0) {
            return null;
        }
        return componentArray;
    }

    public void addChildPanel(WConfigPanel wConfigPanel) {
        if (wConfigPanel == null) {
            return;
        }
        wConfigPanel.verifyConfig();
        wConfigPanel.updateUIState();
        if (wConfigPanel instanceof WBranchPanel) {
            if (this.branchContainer == null) {
                this.createBranchContainer();
            }
            this.branchContainer.add(wConfigPanel);
            this.branchContainerChanged();
            this.branchContainer.revalidate();
        } else {
            if (this.stemContainer == null) {
                this.createStemContainer();
            }
            this.stemContainer.add(wConfigPanel);
            this.stemContainerChanged();
            this.stemContainer.revalidate();
        }
        if (this.getParent() != null) {
            this.getSetupProvider().setUnsavedWork();
        }
    }

    public void removeChildPanel(WConfigPanel wConfigPanel) {
        if (wConfigPanel == null) {
            return;
        }
        if (wConfigPanel instanceof WBranchPanel) {
            if (this.branchContainer == null) {
                return;
            }
            this.branchContainer.remove(wConfigPanel);
            this.branchContainerChanged();
            this.branchContainer.revalidate();
        } else {
            if (this.stemContainer == null) {
                return;
            }
            this.stemContainer.remove(wConfigPanel);
            this.stemContainerChanged();
            this.stemContainer.revalidate();
        }
        if (this.getParent() != null) {
            this.getSetupProvider().setUnsavedWork();
        }
    }

    public void setWorkLock(boolean bl) {
        int n;
        int n2;
        Component[] componentArray = this.getBranchPanels();
        int n3 = n2 = componentArray != null ? componentArray.length : 0;
        for (int i = 0; i < n2; ++i) {
            ((WConfigPanel)componentArray[i]).setWorkLock(bl);
        }
        Component[] componentArray2 = this.getStemPanels();
        int n4 = n = componentArray2 != null ? componentArray2.length : 0;
        for (n2 = 0; n2 < n; ++n2) {
            ((WConfigPanel)componentArray2[n2]).setWorkLock(bl);
        }
        if (bl) {
            this.setCompEnabled(this.menuButton, false);
        } else {
            this.updateUIState();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        int n3 = this.getComponentCount();
        for (int i = 0; i < n3; ++i) {
            Component component = this.getComponent(i);
            if (!component.isVisible()) continue;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            if (i == 0) {
                n7 = 4;
                n6 = 4;
                n5 = 4;
                n4 = 4;
            } else {
                n5 = this.childIndent;
            }
            Dimension dimension = component.getPreferredSize();
            int n8 = n5 + dimension.width + n7;
            int n9 = n4 + dimension.height + n6;
            if (n8 > n) {
                n = n8;
            }
            n2 += n9;
        }
        Insets insets = this.getInsets();
        if (insets != null) {
            n += insets.left + insets.right;
            n2 += insets.top + insets.bottom;
        }
        return new Dimension(n, n2);
    }

    @Override
    public void doLayout() {
        int n;
        int n2;
        int n3;
        Serializable serializable;
        int n4;
        Insets insets = this.getInsets();
        int n5 = insets == null ? 0 : insets.left;
        int n6 = insets == null ? 0 : insets.top;
        int n7 = this.getSize().width;
        if (insets != null) {
            n7 -= insets.left + insets.right;
        }
        int n8 = this.getComponentCount();
        for (n4 = 0; n4 < n8; ++n4) {
            serializable = this.getComponent(n4);
            if (!((Component)serializable).isVisible()) continue;
            int n9 = 0;
            n3 = 0;
            n2 = 0;
            n = 0;
            if (n4 == 0) {
                n = 4;
                n2 = 4;
                n3 = 4;
                n9 = 4;
            } else {
                n3 = this.childIndent;
            }
            Dimension dimension = ((Component)serializable).getPreferredSize();
            ((Component)serializable).setBounds(n5 + n3, n6 + n9, n7 - (n3 + n), dimension.height);
            n6 += n9 + dimension.height + n2;
        }
        if (this.stemContainer != null) {
            n4 = 0;
            serializable = this.getBackground();
            for (Container container = this.getParent(); container != null; container = container.getParent()) {
                if (!(container instanceof WConfigPanel)) continue;
                ++n4;
                serializable = container.getBackground();
            }
            if (serializable != null) {
                if (n4 == 0) {
                    this.stemContainer.setBackground(ParsecTools.brighter((Color)serializable, 0.95));
                } else if (n4 == 1) {
                    this.stemContainer.setBackground((Color)serializable);
                } else if (n4 > 1) {
                    this.stemContainer.setBackground(ParsecTools.darker((Color)serializable, Math.pow(0.96, n4 - 1)));
                }
            }
        }
        if (this.branchContainer != null) {
            Color color = this.getBackground();
            serializable = ParsecTools.darker(color, Math.pow(0.96, 1.0));
            int n10 = ((Color)serializable).getRed();
            n3 = ((Color)serializable).getGreen();
            n2 = color.getBlue();
            n = ((Color)serializable).getAlpha();
            this.branchContainer.setBackground(new Color(n10, n3, n2, n));
        }
    }

    @Override
    public String getRPCArg() {
        return this.getAttrib("rpc");
    }

    @Override
    public void updateRPCArg(String string) {
        this.putAttrib("rpc", string);
        if (this.getParent() == null) {
            this.getSetupProvider().setUnsavedWork();
        }
        if (this.localObjectAgent != null) {
            this.localObjectAgent.fwdCall(string);
        }
    }

    @Override
    public void addRPCInvokeAdapter(RPCInvokeAdapter rPCInvokeAdapter) {
        this.ensureLocalObjectAgent();
        this.localObjectAgent.addRPCInvokeAdapter(rPCInvokeAdapter);
    }

    @Override
    public void removeRPCInvokeAdapter(RPCInvokeAdapter rPCInvokeAdapter) {
        if (this.localObjectAgent == null) {
            throw new IllegalArgumentException("RPC invoke adapter not found");
        }
        this.localObjectAgent.removeRPCInvokeAdapter(rPCInvokeAdapter);
    }

    protected static JLabel createServiceTypeLabel() {
        JLabel jLabel = new JLabel();
        jLabel.setOpaque(false);
        Font font = jLabel.getFont();
        jLabel.setFont(new Font("SansSerif", 2, font.getSize() - 2));
        jLabel.setForeground(new Color(128, 128, 192));
        return jLabel;
    }

    protected static JLabel createParamLabel() {
        JLabel jLabel = new JLabel();
        jLabel.setOpaque(false);
        Font font = jLabel.getFont();
        jLabel.setFont(new Font("SansSerif", 0, font.getSize() - 1));
        jLabel.setForeground(new Color(48, 96, 80));
        return jLabel;
    }

    protected static ImageIcon getSettingsIcon() {
        if (settingsIcon == null) {
            settingsIcon = ParsecTools.getImageIcon("/icons/settings-button.png");
        }
        return settingsIcon;
    }

    protected static ImageIcon getChangeIcon() {
        if (changeIcon == null) {
            changeIcon = ParsecTools.getImageIcon("/icons/change-icon.png");
        }
        return changeIcon;
    }

    public static WConfigPanel createPanel(SetupProvider setupProvider, ConfigSchema.Element element) throws ParsecException {
        if (element == null) {
            throw new InternalParsecException("No element schema");
        }
        try {
            Constructor<?> constructor = element.getPanelClass().getConstructor(SetupProvider.class, ConfigSchema.Element.class);
            Object obj = constructor.newInstance(setupProvider, element);
            if (obj instanceof WConfigPanel) {
                return (WConfigPanel)obj;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InternalParsecException("No suitable constructor");
        }
        catch (InvocationTargetException invocationTargetException) {
            ParsecException parsecException;
            Throwable throwable = invocationTargetException.getCause();
            if (throwable == null) {
                throw new ParsecException("InvocationTargetException without cause");
            }
            if (throwable instanceof GenericParsecException) {
                parsecException = new GenericParsecException(throwable.getMessage());
                parsecException.setHints(((ParsecException)throwable).getHints());
                parsecException.setDetails(((ParsecException)throwable).getDetails());
            } else if (throwable instanceof ParsecException) {
                parsecException = new ParsecException(throwable.getMessage());
                parsecException.setHints(((ParsecException)throwable).getHints());
                parsecException.setDetails(((ParsecException)throwable).getDetails());
            } else {
                parsecException = new ParsecException(throwable.getMessage());
            }
            parsecException.initCause(invocationTargetException.getCause());
            throw parsecException;
        }
        catch (Throwable throwable) {
            InternalParsecException internalParsecException = new InternalParsecException("Instantiation exception");
            internalParsecException.initCause(throwable.getCause());
            throw internalParsecException;
        }
        return null;
    }

    public static class SetupParam {
        ConfigSchema.Param paramSchema;
        Object currentValue;

        public SetupParam(ConfigSchema.Param param) {
            this.paramSchema = param;
            this.currentValue = null;
        }

        public String getName() {
            return this.paramSchema.getName();
        }

        public SVMeta getMeta() {
            return this.paramSchema.getMeta();
        }

        public ConfigSchema.Param getParamSchema() {
            return this.paramSchema;
        }

        public String currentValueToString() {
            if (this.currentValue == null) {
                return "";
            }
            if (this.currentValue instanceof InetAddress) {
                return ((InetAddress)this.currentValue).getHostAddress();
            }
            return this.currentValue.toString();
        }
    }
}

