/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.parsec.config.ConfigSchema;
import dexlogic.parsec.config.SetupProvider;
import dexlogic.parsec.config.WConfigPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WFeedPanel
extends WConfigPanel {
    private int modFlags;
    private JCheckBox enabledCheck;
    private boolean checkedFlag = false;
    private boolean reachableFlag = false;
    public static final int MODFLAG_COLLECTOR = 4096;

    private void amendControlPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.enabledCheck = new JCheckBox("");
        this.enabledCheck.setOpaque(false);
        this.enabledCheck.setSelected(true);
        this.enabledCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!WFeedPanel.this.isDisplayable()) {
                    return;
                }
                WFeedPanel.this.updateUIState();
                WFeedPanel.this.getSetupProvider().setUnsavedWork();
            }
        });
        JLabel jLabel = new JLabel(this.getElementSchema().toString());
        jLabel.setOpaque(false);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        jPanel.add((Component)this.enabledCheck, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        jPanel.add((Component)this.getParamLabel(), gridBagConstraints);
    }

    @Override
    protected void buildParamString(StringBuilder stringBuilder) {
        super.buildParamString(stringBuilder);
        if ((this.modFlags & 0x1000) != 0) {
            if (!this.checkedFlag) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append("&nbsp;&nbsp;");
                }
                stringBuilder.append("<span style='background:#FF8080;color:#ffffff'>");
                stringBuilder.append("&nbsp;unchecked&nbsp;");
                stringBuilder.append("</span>");
            } else if (this.reachableFlag) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append("&nbsp;&nbsp;");
                }
                stringBuilder.append("<span style='color:#008000'>");
                stringBuilder.append("&#x2713;");
                stringBuilder.append("</span>");
            } else {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append("&nbsp;&nbsp;");
                }
                stringBuilder.append("<span style='background:#FF8080;color:#ffffff'>");
                stringBuilder.append("&nbsp;missing&nbsp;");
                stringBuilder.append("</span>");
            }
        }
    }

    @Override
    protected boolean evalPanelEnabled() {
        return super.evalPanelEnabled() && this.enabledCheck.isSelected();
    }

    @Override
    protected void updateUIState() {
        super.updateUIState();
        this.setCompEnabled(this.enabledCheck, true);
    }

    public WFeedPanel(SetupProvider setupProvider, ConfigSchema.Element element) {
        super(setupProvider, element);
        if (element != null) {
            this.modFlags = element.getModFlags();
        }
        this.childIndent = 15;
        this.amendControlPanel(this.getControlPanel());
    }

    public void setChecked(boolean bl) {
        if (!this.checkedFlag || this.reachableFlag != bl) {
            this.checkedFlag = true;
            this.reachableFlag = bl;
            this.updateParamLabel();
        }
    }

    @Override
    public void putSetupValue(String string, Object object) {
        super.putSetupValue(string, object);
        if ((this.modFlags & 0x1000) != 0 && (string.equals("unitID") || string.equals("unitName"))) {
            this.checkedFlag = false;
            this.reachableFlag = false;
            this.updateParamLabel();
        }
    }

    @Override
    public void putAttrib(String string, String string2) {
        if (string.equals("style")) {
            ConfigSchema.Element element = this.getElementSchema();
            if (element instanceof ConfigSchema.StyledElement) {
                String string3 = ((ConfigSchema.StyledElement)element).getStyle();
                if (!string3.equals(string2)) {
                    throw new IllegalArgumentException("schema(" + string3 + ") / style(" + string2 + ") mismatch");
                }
            } else {
                super.putAttrib(string, string2);
            }
        } else {
            super.putAttrib(string, string2);
        }
        if (string.equals("enabled")) {
            boolean bl;
            boolean bl2 = bl = string2 != null && string2.equals("true");
            if (this.enabledCheck.isSelected() != bl) {
                this.enabledCheck.setSelected(bl);
                this.updateUIState();
            }
        }
    }

    @Override
    public String getAttrib(String string) {
        if (string.equals("style")) {
            ConfigSchema.Element element = this.getElementSchema();
            if (element instanceof ConfigSchema.StyledElement) {
                return ((ConfigSchema.StyledElement)element).getStyle();
            }
            return super.getAttrib(string);
        }
        if (string.equals("enabled")) {
            return !this.enabledCheck.isSelected() ? "false" : null;
        }
        return super.getAttrib(string);
    }

    @Override
    public void setWorkLock(boolean bl) {
        super.setWorkLock(bl);
        if (bl) {
            this.setCompEnabled(this.enabledCheck, false);
        }
    }
}

