/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.parsec.config.ConfigSchema;
import dexlogic.parsec.config.ServiceList;
import dexlogic.parsec.config.SetupProvider;
import dexlogic.parsec.config.UPatchCombo;
import dexlogic.parsec.config.WConfigPanel;
import dexlogic.parsec.config.WSourceDSPPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;

public class WRoutingPanel
extends WConfigPanel {
    private int patchType;
    private UPatchCombo patchCombo;

    private void updatePatchOptions() {
        if (this.patchType < 0 || !this.patchCombo.isVisible()) {
            this.patchCombo.setPatchOptions(null);
        } else {
            SetupProvider setupProvider = this.getSetupProvider();
            ServiceList[] serviceListArray = setupProvider.getServiceLists(this.patchType);
            this.patchCombo.setPatchOptions(serviceListArray);
        }
    }

    private void amendControlPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.patchType = -1;
        this.patchCombo = new UPatchCombo();
        this.patchCombo.setOpaque(false);
        this.patchCombo.setVisible(false);
        this.patchCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!WRoutingPanel.this.isDisplayable()) {
                    return;
                }
                WRoutingPanel.this.getSetupProvider().setUnsavedWork();
            }
        });
        gridBagConstraints.gridx = 19;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 7, 0, 0);
        jPanel.add((Component)this.patchCombo, gridBagConstraints);
    }

    protected void setPatchType(int n) {
        int n2;
        if (this.patchType == n) {
            return;
        }
        this.patchType = n;
        Component[] componentArray = this.getStemPanels();
        int n3 = n2 = componentArray != null ? componentArray.length : 0;
        for (int i = 0; i < n2; ++i) {
            if (!(componentArray[i] instanceof WSourceDSPPanel)) continue;
            ((WSourceDSPPanel)componentArray[i]).setInputType(n);
        }
        if (this.isDisplayable()) {
            this.updatePatchOptions();
        }
    }

    protected int getPatchType() {
        return this.patchType;
    }

    protected void setPatchAttrib(String string) {
        this.patchCombo.setSelectedItem(string);
        this.updateUIState();
    }

    protected boolean evalPatchConfigurable() {
        return this.getStemPanelCount() <= 0;
    }

    @Override
    protected void updateUIState() {
        super.updateUIState();
        boolean bl = this.evalPatchConfigurable();
        if (this.patchCombo.isVisible() != bl) {
            this.patchCombo.setVisible(bl);
            if (this.isDisplayable()) {
                this.updatePatchOptions();
            }
        }
        if (bl) {
            boolean bl2 = this.evalPanelEnabled();
            if (this.patchCombo.getSelectedItem() == null) {
                this.setCompEnabled(this.patchCombo, false);
            } else {
                this.setCompEnabled(this.patchCombo, bl2);
            }
        }
    }

    @Override
    protected void stemContainerChanged() {
        this.updateUIState();
    }

    public WRoutingPanel(SetupProvider setupProvider, ConfigSchema.Element element) {
        super(setupProvider, element);
        this.amendControlPanel(this.getControlPanel());
    }

    @Override
    public void putAttrib(String string, String string2) {
        if (string.equals("patch")) {
            this.setPatchAttrib(string2);
        } else {
            super.putAttrib(string, string2);
        }
    }

    @Override
    public String getAttrib(String string) {
        if (string.equals("patch")) {
            if (this.evalPatchConfigurable()) {
                Object object = this.patchCombo.getSelectedItem();
                if (object instanceof UPatchCombo.VoidServiceInfo) {
                    return "";
                }
                return object == null ? null : object.toString();
            }
            return null;
        }
        return super.getAttrib(string);
    }

    @Override
    public void addChildPanel(WConfigPanel wConfigPanel) {
        if (wConfigPanel instanceof WSourceDSPPanel) {
            ((WSourceDSPPanel)wConfigPanel).setInputType(this.patchType);
        }
        super.addChildPanel(wConfigPanel);
    }

    @Override
    public void setWorkLock(boolean bl) {
        super.setWorkLock(bl);
        if (bl) {
            this.setCompEnabled(this.patchCombo, false);
        }
    }

    @Override
    public void addNotify() {
        this.updatePatchOptions();
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.patchCombo.setPatchOptions(null);
    }
}

