/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.config;

import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.config.ConfigSchema;
import dexlogic.parsec.config.SetupProvider;
import dexlogic.parsec.config.UServiceField;
import dexlogic.parsec.config.WConfigPanel;
import dexlogic.parsec.config.WSinkDSPPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class WSinkServicePanel
extends WConfigPanel {
    private int modFlags;
    private UServiceField serviceField;
    private JLabel inputTypeLabel;
    private boolean checkedFlag = false;
    private boolean reachableFlag = false;
    private boolean appointedFlag = false;
    public static final int MODFLAG_IDNCLIENT = 1;

    private void amendControlPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.serviceField = new UServiceField(this.getSetupProvider());
        this.serviceField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!WSinkServicePanel.this.isDisplayable()) {
                    return;
                }
                WSinkServicePanel.this.getSetupProvider().setUnsavedWork();
            }
        });
        this.inputTypeLabel = WConfigPanel.createServiceTypeLabel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.serviceField, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        jPanel.add((Component)this.inputTypeLabel, gridBagConstraints);
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.getParamLabel(), gridBagConstraints);
    }

    @Override
    protected void buildParamString(StringBuilder stringBuilder) {
        super.buildParamString(stringBuilder);
        if ((this.modFlags & 1) != 0) {
            if (!this.checkedFlag) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append("&nbsp;&nbsp;");
                }
                stringBuilder.append("<span style='background:#FF8080;color:#ffffff'>");
                stringBuilder.append("&nbsp;unchecked&nbsp;");
                stringBuilder.append("</span>");
            } else if (this.reachableFlag) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append("&nbsp;&nbsp;");
                }
                stringBuilder.append("<span style='color:#008000'>");
                stringBuilder.append("&#x2713;");
                stringBuilder.append("</span>");
            } else if (!this.appointedFlag) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append("&nbsp;&nbsp;");
                }
                stringBuilder.append("<span style='background:#FF8080;color:#ffffff'>");
                stringBuilder.append("&nbsp;missing&nbsp;");
                stringBuilder.append("</span>");
            }
        }
    }

    @Override
    protected void updateUIState() {
        super.updateUIState();
        boolean bl = this.evalPanelEnabled();
        this.setCompEnabled(this.serviceField, bl);
    }

    public WSinkServicePanel(SetupProvider setupProvider, ConfigSchema.Element element) {
        super(setupProvider, element);
        if (element != null) {
            this.modFlags = element.getModFlags();
        }
        this.childIndent = 15;
        this.amendControlPanel(this.getControlPanel());
    }

    public void setChecked(boolean bl, boolean bl2) {
        if (!this.checkedFlag || this.reachableFlag != bl || this.appointedFlag != bl2) {
            this.checkedFlag = true;
            this.reachableFlag = bl;
            this.appointedFlag = bl2;
            this.updateParamLabel();
        }
    }

    @Override
    public void discard() {
        super.discard();
        this.serviceField.setText("");
    }

    @Override
    public void putSetupValue(String string, Object object) {
        super.putSetupValue(string, object);
        if ((this.modFlags & 1) != 0 && string.equals("serviceID")) {
            this.checkedFlag = false;
            this.reachableFlag = false;
            this.appointedFlag = false;
            this.updateParamLabel();
        }
    }

    @Override
    public void putAttrib(String string, String string2) {
        if (string.equals("name")) {
            this.serviceField.setText(ParsecTools.stripString(string2));
        } else if (string.equals("style")) {
            int n;
            this.inputTypeLabel.setText(string2 != null ? string2 : "");
            this.serviceField.setInputType(ParsecTools.getServiceTypeInt(string2));
            int n2 = this.serviceField.getInputType();
            Component[] componentArray = this.getStemPanels();
            int n3 = n = componentArray != null ? componentArray.length : 0;
            for (int i = 0; i < n; ++i) {
                if (!(componentArray[i] instanceof WSinkDSPPanel)) continue;
                ((WSinkDSPPanel)componentArray[i]).setInputType(n2);
            }
        } else {
            super.putAttrib(string, string2);
        }
    }

    @Override
    public String getAttrib(String string) {
        if (string.equals("name")) {
            return ParsecTools.stripString(this.serviceField.getText());
        }
        if (string.equals("style")) {
            return ParsecTools.stripString(this.inputTypeLabel.getText());
        }
        return super.getAttrib(string);
    }

    @Override
    public void addChildPanel(WConfigPanel wConfigPanel) {
        if (wConfigPanel instanceof WSinkDSPPanel) {
            if (this.getStemPanelCount() != 0) {
                return;
            }
        } else {
            return;
        }
        super.addChildPanel(wConfigPanel);
        if (wConfigPanel instanceof WSinkDSPPanel) {
            ((WSinkDSPPanel)wConfigPanel).setInputType(this.serviceField.getInputType());
        }
    }

    @Override
    public void setWorkLock(boolean bl) {
        super.setWorkLock(bl);
        if (bl) {
            this.setCompEnabled(this.serviceField, false);
        }
    }
}

