/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.idn;

import dexlogic.parsec.idn.ClipRectangle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class FormatBorder
implements Border {
    private Color topColor = null;
    private Color leftColor = null;
    private Color bottomColor = null;
    private Color rightColor = null;
    private Insets insets = null;

    public FormatBorder(Color color, Color color2, Color color3, Color color4) {
        this.topColor = color;
        this.leftColor = color2;
        this.bottomColor = color3;
        this.rightColor = color4;
        int n = color == null ? 0 : 1;
        int n2 = color2 == null ? 0 : 1;
        int n3 = color3 == null ? 0 : 1;
        int n4 = color4 == null ? 0 : 1;
        this.insets = new Insets(n, n2, n3, n4);
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        ClipRectangle.initialize(n, n2, n3, n4);
        int n5 = n;
        int n6 = n + n3 - 1;
        int n7 = n2;
        int n8 = n2 + n4 - 1;
        if (this.topColor != null && ClipRectangle.containsY(n7) && ClipRectangle.hasValidWidth()) {
            graphics.setColor(this.topColor);
            graphics.drawLine(ClipRectangle.x, n7, ClipRectangle.x + (ClipRectangle.width - 1), n7);
            ClipRectangle.clipTop(n7 + 1);
        }
        if (this.bottomColor != null && ClipRectangle.containsY(n8) && ClipRectangle.hasValidWidth()) {
            graphics.setColor(this.bottomColor);
            graphics.drawLine(ClipRectangle.x, n8, ClipRectangle.x + (ClipRectangle.width - 1), n8);
            ClipRectangle.clipBottom(n8 - 1);
        }
        if (this.leftColor != null && ClipRectangle.containsX(n5) && ClipRectangle.hasValidHeight()) {
            graphics.setColor(this.leftColor);
            graphics.drawLine(n5, ClipRectangle.y, n5, ClipRectangle.y + (ClipRectangle.height - 1));
            ClipRectangle.clipLeft(n5 + 1);
        }
        if (this.rightColor != null && ClipRectangle.containsX(n6) && ClipRectangle.hasValidHeight()) {
            graphics.setColor(this.rightColor);
            graphics.drawLine(n6, ClipRectangle.y, n6, ClipRectangle.y + (ClipRectangle.height - 1));
            ClipRectangle.clipRight(n6 - 1);
        }
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this.insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

