/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.idn;

import dexlogic.io.idn.IDNFile;
import dexlogic.parsec.GenericParsecException;
import dexlogic.parsec.InternalParsecException;
import dexlogic.parsec.MediaSource;
import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.WParsecRootPane;
import dexlogic.parsec.idn.IDNSource;
import dexlogic.parsec.idn.SourceManager;
import dexlogic.parsec.idn.WFilePanel;
import dexlogic.parsec.idn.WIDNContentPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSlider;

public class WIDNRootPane
extends WParsecRootPane {
    private File filePath;
    IDNFile workFile;
    private WFilePanel filePanel;
    private SourceManager sourceManager;

    private void setImage(JMenuItem jMenuItem, String string) {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            jMenuItem.setIcon(new ImageIcon(ImageIO.read(inputStream)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void buildMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = this.buildFileMenu();
        jMenu.add(this.buildFileNewMenu());
        jMenu.add(this.buildFileOpenItem());
        jMenu.add(this.buildFileCloseItem());
        jMenu.addSeparator();
        jMenu.add(this.buildSinkSetupItem());
        jMenu.add(this.buildServiceParamItem());
        jMenu.addSeparator();
        jMenu.add(this.buildQuitItem());
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Tape");
        jMenu.setMnemonic(84);
        JMenuItem jMenuItem = jMenu.add(new JMenuItem("Play", 80));
        this.setImage(jMenuItem, "/icons/play-menu.png");
        jMenuItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WIDNRootPane.this.sourceManager.play();
            }
        });
        jMenuItem = jMenu.add(new JMenuItem("Pause"));
        this.setImage(jMenuItem, "/icons/pause-menu.png");
        jMenuItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WIDNRootPane.this.sourceManager.pause();
            }
        });
        jMenuItem = jMenu.add(new JMenuItem("Preload"));
        this.setImage(jMenuItem, "/icons/preload-menu.png");
        jMenuItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WIDNRootPane.this.sourceManager.pause();
            }
        });
        jMenuItem = jMenu.add(new JMenuItem("Stop", 83));
        this.setImage(jMenuItem, "/icons/stop-menu.png");
        jMenuItem.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WIDNRootPane.this.sourceManager.stop();
            }
        });
        jMenu.addSeparator();
        jMenuItem = jMenu.add(new JMenuItem("Recorder Setup..."));
        jMenuItem.setEnabled(false);
        jMenuItem = jMenu.add(new JMenuItem("Record", 82));
        jMenuItem.setEnabled(false);
        jMenuItem = jMenu.add(new JMenuItem("Stop", 83));
        jMenuItem.setEnabled(false);
        jMenuBar.add(jMenu);
        jMenuBar.add(this.buildWindowMenu());
        this.setJMenuBar(jMenuBar);
    }

    private void buildUI() {
        this.filePanel = new WFilePanel(this);
        this.getContentPane().add((Component)this.filePanel, "Center");
        this.getContentPane().add((Component)new JSlider(), "South");
    }

    public WIDNRootPane(File file) throws ParsecException {
        if (file == null) {
            String string = "Parsec (IDN-File), invalid constructor invocation";
            throw new InternalParsecException(string);
        }
        if (!file.getName().endsWith(".idn")) {
            String string = "Parsec (IDN-File) can't handle extension of " + file.getName();
            InternalParsecException internalParsecException = new InternalParsecException(string);
            internalParsecException.setDetails("Absolute path: \n" + file.getAbsolutePath());
            throw internalParsecException;
        }
        this.filePath = file;
        try {
            this.workFile = new IDNFile(file.getCanonicalPath());
            this.workFile.open("rw");
            this.workFile.checkStructure();
        }
        catch (Throwable throwable) {
            String string = "File open error: " + file.getName();
            GenericParsecException genericParsecException = new GenericParsecException(string);
            genericParsecException.setDetails(ParsecTools.getTraceDetails(throwable));
            throw genericParsecException;
        }
        MediaSource mediaSource = IDNSource.createSource(file, this.workFile);
        this.sourceManager = new SourceManager(mediaSource);
        this.setTitle("Parsec IDN - " + file.getName());
        this.buildMenu();
        this.buildUI();
    }

    @Override
    public void dispose() {
        this.sourceManager.stop();
        try {
            this.workFile.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this.workFile = null;
        }
    }

    @Override
    protected Container createContentPane() {
        WIDNContentPane wIDNContentPane = new WIDNContentPane(this);
        wIDNContentPane.setName(this.getName() + ".contentPane");
        return wIDNContentPane;
    }
}

