/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.imsp;

import dexlogic.io.idn.IDNTools;
import dexlogic.parsec.GenericParsecException;
import dexlogic.parsec.InternalParsecException;
import dexlogic.parsec.MediaSource;
import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public class IMSPSource {
    private static final int IDNVAL_CID_IMSP_WELCOME = 8704;
    private static final int IDNVAL_CID_IMSP_PING_REQUEST = 8708;
    private static final int IDNVAL_CID_IMSP_PING_RESPONSE = 8709;
    private static final int IDNVAL_CID_IMSP_MEDIA_QUERY = 8712;
    private static final int IDNVAL_CID_IMSP_MEDIA_SUMMARY = 8713;
    private static final int IDNVAL_CID_IMSP_TUNNEL = 8720;

    private static void readMessage(InputStream inputStream, ByteBuffer byteBuffer) throws IOException {
        byteBuffer.clear();
        inputStream.read(byteBuffer.array(), 0, 2);
        int n = byteBuffer.getShort(0) & 0xFFFF;
        if (n < 4) {
            throw new IOException("Invalid message size " + n);
        }
        inputStream.read(byteBuffer.array(), 2, n - 2);
        byteBuffer.limit(n);
    }

    private static void writeMessage(OutputStream outputStream, ByteBuffer byteBuffer) throws IOException {
        outputStream.write(byteBuffer.array(), 0, byteBuffer.limit());
    }

    private static void readWelcome(InputStream inputStream, ByteBuffer byteBuffer) throws IOException, ParsecException {
        IMSPSource.readMessage(inputStream, byteBuffer);
        int n = byteBuffer.getShort() & 0xFFFF;
        int n2 = byteBuffer.getShort() & 0xFFFF;
        if (n2 != 8704) {
            String string = String.format("Invalid welcome message, totalSize=%d, contentID=%04X", n, n2);
            throw new GenericParsecException(string);
        }
    }

    private static void writeMediaQuery(OutputStream outputStream, ByteBuffer byteBuffer, URI uRI) throws IOException {
        byteBuffer.clear();
        byteBuffer.putShort((short)0);
        byteBuffer.putShort((short)8712);
        byteBuffer.put(uRI.getPath().getBytes(StandardCharsets.UTF_8));
        byteBuffer.putShort(0, (short)byteBuffer.position());
        byteBuffer.limit(byteBuffer.position());
        IMSPSource.writeMessage(outputStream, byteBuffer);
    }

    private static MediaCookie readMediaSummary(InputStream inputStream, ByteBuffer byteBuffer) throws IOException, ParsecException {
        int n;
        IMSPSource.readMessage(inputStream, byteBuffer);
        int n2 = byteBuffer.getShort() & 0xFFFF;
        int n3 = byteBuffer.getShort() & 0xFFFF;
        if (n3 != 8713 || n2 < 12) {
            String string = String.format("Invalid drain list message, totalSize=%d, contentID=%04X", n2, n3);
            throw new GenericParsecException(string);
        }
        MediaCookie mediaCookie = new MediaCookie();
        int n4 = byteBuffer.get() & 0xFF;
        int n5 = byteBuffer.get() & 0xFF;
        int n6 = byteBuffer.get() & 0xFF;
        int n7 = byteBuffer.get() & 0xFF;
        mediaCookie.durationMS = byteBuffer.getInt();
        for (n = n4 - 12; n > 0; --n) {
            byteBuffer.get();
        }
        if (n5 == 0) {
            throw new GenericParsecException("Invalid media path");
        }
        n = n2 - 4 - n4;
        if (n / n6 < n7) {
            String string = String.format("Invalid drain list, listSize=%d, drainEntrySize=%d, drainEntryCount=%d", n2, n6, n7);
            throw new GenericParsecException(string);
        }
        mediaCookie.drainList = new ArrayList();
        for (int i = 0; i < n7; ++i) {
            DrainEntry drainEntry = new DrainEntry();
            drainEntry.serviceID = byteBuffer.get() & 0xFF;
            drainEntry.serviceType = byteBuffer.get() & 0xFF;
            drainEntry.flags = byteBuffer.get() & 0xFF;
            int n8 = byteBuffer.get() & 0xFF;
            drainEntry.drainName = IDNTools.readStringField(byteBuffer, 20);
            for (int j = n6 - 24; j > 0; --j) {
                byteBuffer.get();
            }
            mediaCookie.drainList.add(drainEntry);
        }
        return mediaCookie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MediaCookie retrieveRemoteSetup(URI uRI) throws IOException, ParsecException {
        Socket socket = new Socket();
        try {
            MediaCookie mediaCookie;
            socket.connect(new InetSocketAddress(uRI.getHost(), uRI.getPort()), 1000);
            InputStream inputStream = socket.getInputStream();
            OutputStream outputStream = socket.getOutputStream();
            socket.setSoTimeout(1000);
            ByteBuffer byteBuffer = ByteBuffer.allocate(65536);
            IMSPSource.readWelcome(inputStream, byteBuffer);
            IMSPSource.writeMediaQuery(outputStream, byteBuffer, uRI);
            MediaCookie mediaCookie2 = mediaCookie = IMSPSource.readMediaSummary(inputStream, byteBuffer);
            return mediaCookie2;
        }
        finally {
            try {
                socket.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private static void prepareJack(MediaSource.Jack jack, DrainEntry drainEntry) throws ParsecException {
        jack.comment = null;
        jack.serviceType = drainEntry.serviceType;
    }

    private static MediaSource.Jack fetchJack(MediaSource.Jack[] jackArray, int n, String string) {
        int n2 = -1;
        int n3 = 0;
        for (int i = 0; i < jackArray.length; ++i) {
            MediaSource.Jack jack = jackArray[i];
            if (jack == null) continue;
            String string2 = ParsecTools.trimString(jack.getSetupArg("serviceID"));
            int n4 = -1;
            try {
                if (string2 != null) {
                    n4 = Integer.parseInt(string2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                n4 = -1;
            }
            String string3 = ParsecTools.trimString(jack.jackName);
            if (n2 < 0 && n3 < 10 && n4 > 0 && n4 == n && (string3 == null || string != null && string3.equals(string))) {
                n2 = i;
                n3 = 10;
                break;
            }
            if (n2 >= 0 || n3 >= 5 || string2 != null || string3 == null || string == null || !string3.equals(string)) continue;
            n2 = i;
            n3 = 5;
        }
        if (n2 >= 0) {
            MediaSource.Jack jack = jackArray[n2];
            jackArray[n2] = null;
            return jack;
        }
        return null;
    }

    private static void prepareTrunk(MediaSource.Trunk trunk, MediaCookie mediaCookie) throws ParsecException {
        CharSequence charSequence;
        String string = trunk.trunkName;
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        trunk.label = "Stream";
        if (string != null) {
            trunk.label = trunk.label + ": " + string;
        }
        trunk.durationMS = mediaCookie.durationMS;
        MediaSource.Jack[] jackArray = new MediaSource.Jack[trunk.jacks.size()];
        trunk.jacks.toArray(jackArray);
        for (DrainEntry object : mediaCookie.drainList) {
            int n = object.serviceID;
            if (n < 0) continue;
            charSequence = ParsecTools.trimString(object.drainName);
            MediaSource.Jack jack = IMSPSource.fetchJack(jackArray, n, (String)charSequence);
            if (jack == null) {
                jack = trunk.addJack((String)charSequence);
                jack.routing.enabled = jackArray.length == 0;
            } else {
                jack.jackName = charSequence;
            }
            jack.putSetupArg("serviceID", Integer.toString(n));
            IMSPSource.prepareJack(jack, object);
        }
        for (int i = 0; i < jackArray.length; ++i) {
            MediaSource.Jack jack = jackArray[i];
            if (jack == null) continue;
            String string2 = jack.getSetupArg("serviceID");
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("Jack ").append(i + 1);
            if (jack.jackName != null) {
                ((StringBuilder)charSequence).append(" (").append(jack.jackName).append(")");
            }
            if (string2 != null) {
                ((StringBuilder)charSequence).append(", serviceID ").append(string2);
            }
            ((StringBuilder)charSequence).append(" assignment error (unmatched)");
            throw new GenericParsecException(((StringBuilder)charSequence).toString());
        }
    }

    private static void prepareSource(MediaSource mediaSource) throws ParsecException {
        MediaSource.Trunk trunk;
        MediaCookie mediaCookie;
        try {
            mediaCookie = IMSPSource.retrieveRemoteSetup(mediaSource.getFeed().absoluteURI);
        }
        catch (IOException iOException) {
            GenericParsecException genericParsecException = new GenericParsecException("Network I/O error");
            genericParsecException.setDetails(ParsecTools.getTraceDetails(iOException));
            throw genericParsecException;
        }
        int n = mediaSource.getFeed().trunks.size();
        if (n == 0) {
            trunk = mediaSource.getFeed().addTrunk(null);
            trunk.enabled = true;
        } else if (n != 1) {
            String string = "Invalid trunk count " + n;
            throw new GenericParsecException(string);
        }
        trunk = mediaSource.getFeed().trunks.get(0);
        trunk.layout = null;
        try {
            IMSPSource.prepareTrunk(trunk, mediaCookie);
        }
        catch (ParsecException parsecException) {
            int n2 = 1;
            String string = ParsecTools.trimString(trunk.trunkName);
            String string2 = ParsecTools.trimString(trunk.layout);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Trunk ").append(n2);
            if (string != null) {
                stringBuilder.append(" (").append(string).append(")");
            }
            if (string2 != null) {
                stringBuilder.append(", layout: ").append(string2);
            }
            parsecException.addHint(stringBuilder.toString());
            throw parsecException;
        }
    }

    public static MediaSource createSource(URI uRI) throws ParsecException {
        if (uRI == null) {
            throw new InternalParsecException("Invalid parameter");
        }
        MediaSource mediaSource = new MediaSource(uRI);
        try {
            IMSPSource.prepareSource(mediaSource);
        }
        catch (ParsecException parsecException) {
            parsecException.addHint("Media URI: " + mediaSource.getFeed().absoluteURI.toString());
            throw parsecException;
        }
        return mediaSource;
    }

    public static void checkSource(MediaSource mediaSource) throws ParsecException {
        try {
            IMSPSource.prepareSource(mediaSource);
        }
        catch (ParsecException parsecException) {
            parsecException.addHint("Media URI: " + mediaSource.getFeed().absoluteURI.toString());
            throw parsecException;
        }
    }

    public static class DrainEntry {
        public int serviceID;
        public int serviceType;
        public int flags;
        public String drainName;
    }

    public static class MediaCookie {
        public int durationMS;
        ArrayList<DrainEntry> drainList;
    }
}

