/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.pdcx;

import dexlogic.parsec.GenericParsecException;
import dexlogic.parsec.ParsecException;
import dexlogic.parsec.config.ConfigXMLWriter;
import dexlogic.parsec.config.WSystemPanel;
import dexlogic.parsec.remote.DRCArg;
import dexlogic.parsec.remote.DRCBatch;
import java.io.File;
import java.io.FileWriter;
import java.io.IOError;
import java.io.IOException;

public class PDCXWriter {
    public static void writeTo(File file, WSystemPanel wSystemPanel, WSystemPanel wSystemPanel2) throws ParsecException {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            StringBuilder stringBuilder = new StringBuilder();
            XMLWriter xMLWriter = new XMLWriter();
            stringBuilder.append("<pdcx version='1.0'>\n");
            if (wSystemPanel != null && wSystemPanel.getStemPanelCount() > 0) {
                xMLWriter.writePanel("  ", stringBuilder, wSystemPanel);
            }
            if (wSystemPanel2 != null && wSystemPanel2.getStemPanelCount() > 0) {
                xMLWriter.writePanel("  ", stringBuilder, wSystemPanel2);
            }
            stringBuilder.append("</pdcx>\n");
            fileWriter.write(stringBuilder.toString());
            fileWriter.close();
            fileWriter = null;
        }
        catch (IOError | IOException throwable) {
            GenericParsecException genericParsecException = new GenericParsecException(throwable.getMessage());
            genericParsecException.initCause(throwable);
            throw genericParsecException;
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static class XMLWriter
    extends ConfigXMLWriter {
        private XMLWriter() {
        }

        @Override
        protected void writeAttribute(String string, StringBuilder stringBuilder, String string2, String string3) {
            if (string2.equals("rpc")) {
                DRCBatch dRCBatch = null;
                try {
                    dRCBatch = DRCArg.parse(string3);
                    if (dRCBatch == null) {
                        return;
                    }
                }
                catch (ParsecException parsecException) {
                    super.writeAttribute(string, stringBuilder, string2, string3);
                    return;
                }
                String string4 = dRCBatch.toString();
                if (string4 == null) {
                    return;
                }
                String string5 = string + "    ";
                string4 = string4.replaceAll("\n+", "\n" + string5);
                stringBuilder.append("\n").append(string5);
                stringBuilder.append("rpc='\n").append(string5).append(string4).append("'\n").append(string);
            } else {
                super.writeAttribute(string, stringBuilder, string2, string3);
            }
        }
    }
}

