/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.pdcx;

import dexlogic.parsec.FileSaveAction;
import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.RefinedFileFilter;
import dexlogic.parsec.UniqueID;
import dexlogic.parsec.WLogFrame;
import dexlogic.parsec.WParsecRootPane;
import dexlogic.parsec.config.ConfigSchema;
import dexlogic.parsec.config.FilterSpec;
import dexlogic.parsec.config.ServiceInfo;
import dexlogic.parsec.config.ServiceList;
import dexlogic.parsec.config.ServiceManager;
import dexlogic.parsec.config.SetupProvider;
import dexlogic.parsec.config.SystemProxyBuilder;
import dexlogic.parsec.config.WSystemPanel;
import dexlogic.parsec.pdcx.PDCXReader;
import dexlogic.parsec.pdcx.PDCXWriter;
import dexlogic.parsec.routes.DXCLogEvent;
import dexlogic.parsec.routes.FlowEventListener;
import dexlogic.parsec.routes.FlowManager;
import dexlogic.parsec.routes.FlowProxy;
import dexlogic.parsec.routes.RPCInvokeEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class WPDCXRootPane
extends WParsecRootPane
implements SetupProvider {
    private File pdcxFilePath;
    private boolean unsavedWorkFlag = false;
    private ServiceManager serviceManager = new ServiceManager();
    private UniqueID filterIDPool = new UniqueID();
    private WLogFrame logFrame;
    private FlowManager flowManager;
    private FlowProxy loadedProxy;
    private boolean playingFlag;
    private JMenuItem saveMenuItem;
    private WSystemPanel sourceSystemPanel;
    private JScrollPane sourceScrollPane;
    private WSystemPanel renderSystemPanel;
    private JScrollPane renderScrollPane;
    private JToggleButton startButton;
    private JToggleButton stopButton;
    private boolean setupLocked;

    private RefinedFileFilter createFilterPDCX() {
        return new RefinedFileFilter("Parsec Driver Configuration XML", ".pdcx");
    }

    private void filenameChanged() {
        String string = "Untitled";
        if (this.pdcxFilePath != null) {
            string = this.pdcxFilePath.getName();
            this.saveMenuItem.setEnabled(true);
        } else {
            this.saveMenuItem.setEnabled(false);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Parsec Driver Configuration");
        if (string != null) {
            stringBuilder.append("  -  ").append(string);
        }
        if (this.unsavedWorkFlag) {
            stringBuilder.append(" *");
        }
        this.setTitle(stringBuilder.toString());
    }

    private void save(File file) {
        File file2 = new FileSaveAction(this){

            @Override
            public void saveTo(File file) throws ParsecException {
                PDCXWriter.writeTo(file, WPDCXRootPane.this.sourceSystemPanel, WPDCXRootPane.this.renderSystemPanel);
            }
        }.save(file, this.createFilterPDCX());
        if (file2 != null) {
            this.pdcxFilePath = file2;
            this.unsavedWorkFlag = false;
            this.filenameChanged();
        }
    }

    private void play() {
        if (this.playingFlag) {
            return;
        }
        this.logFrame.clear();
        try {
            if (this.sourceSystemPanel != null) {
                this.sourceSystemPanel.setWorkLock(true);
            }
            if (this.renderSystemPanel != null) {
                this.renderSystemPanel.setWorkLock(true);
            }
            this.flowManager.createEntity();
            this.flowManager.loadProxy(new SystemProxyBuilder(this.renderSystemPanel));
            this.loadedProxy = this.flowManager.loadProxy(new SystemProxyBuilder(this.sourceSystemPanel));
            this.flowManager.play(null);
            this.startButton.setSelected(true);
            this.playingFlag = true;
        }
        catch (Throwable throwable) {
            this.flowManager.destroyEntity();
            String string = "Streaming System Error";
            ParsecTools.showExceptionDialog(this, string, throwable);
            if (this.sourceSystemPanel != null) {
                this.sourceSystemPanel.setWorkLock(false);
            }
            if (this.renderSystemPanel != null) {
                this.renderSystemPanel.setWorkLock(false);
            }
            this.stopButton.setSelected(true);
        }
    }

    private void stop() {
        if (!this.playingFlag) {
            return;
        }
        try {
            this.flowManager.stop(null);
            if (this.loadedProxy != null) {
                this.loadedProxy = null;
            }
            this.flowManager.destroyEntity();
        }
        catch (Throwable throwable) {
            this.flowManager.destroyEntity();
            String string = "Streaming System Error";
            ParsecTools.showExceptionDialog(this, string, throwable);
        }
        finally {
            if (this.sourceSystemPanel != null) {
                this.sourceSystemPanel.setWorkLock(false);
            }
            if (this.renderSystemPanel != null) {
                this.renderSystemPanel.setWorkLock(false);
            }
            this.stopButton.setSelected(true);
            this.playingFlag = false;
        }
    }

    private void buildMenu() {
        JMenuItem jMenuItem;
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = this.buildFileMenu();
        jMenu.add(this.buildFileNewMenu());
        jMenu.add(this.buildFileOpenItem());
        jMenu.add(this.buildFileCloseItem());
        jMenu.addSeparator();
        this.saveMenuItem = jMenuItem = jMenu.add(new JMenuItem("Save"));
        jMenuItem.setEnabled(this.pdcxFilePath != null);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WPDCXRootPane.this.save(WPDCXRootPane.this.pdcxFilePath);
            }
        });
        jMenuItem = jMenu.add(new JMenuItem("Save As..."));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WPDCXRootPane.this.save(null);
            }
        });
        jMenu.addSeparator();
        jMenu.add(this.buildQuitItem());
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Tools");
        jMenu.setMnemonic(84);
        jMenuItem = jMenu.add(new JMenuItem("Developer Log..."));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WPDCXRootPane.this.logFrame.setVisible(true);
            }
        });
        jMenuBar.add(jMenu);
        jMenuBar.add(this.buildWindowMenu());
        this.setJMenuBar(jMenuBar);
    }

    private JToggleButton createCtlToggleButton(String string) {
        JToggleButton jToggleButton = new JToggleButton();
        jToggleButton.setIcon(ParsecTools.getImageIcon(string));
        jToggleButton.setMargin(new Insets(5, 8, 5, 8));
        jToggleButton.setBorderPainted(false);
        return jToggleButton;
    }

    private JComponent buildControlPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        ButtonGroup buttonGroup = new ButtonGroup();
        this.startButton = this.createCtlToggleButton("/icons/power-button.png");
        buttonGroup.add(this.startButton);
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WPDCXRootPane.this.play();
            }
        });
        this.stopButton = this.createCtlToggleButton("/icons/stop-button.png");
        buttonGroup.add(this.stopButton);
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WPDCXRootPane.this.stop();
            }
        });
        this.stopButton.setSelected(true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.startButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        jPanel.add((Component)this.stopButton, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        return jPanel;
    }

    private void buildUI() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        this.sourceScrollPane = new JScrollPane();
        this.sourceScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.sourceScrollPane.getVerticalScrollBar().setBlockIncrement(50);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.sourceScrollPane, "Center");
        jPanel2.add((Component)this.buildControlPanel(), "South");
        jPanel.add(jPanel2);
        this.renderScrollPane = new JScrollPane();
        this.renderScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.renderScrollPane.getVerticalScrollBar().setBlockIncrement(50);
        jPanel.add(this.renderScrollPane);
        this.setContentPane(jPanel);
    }

    public WPDCXRootPane(File file) throws ParsecException {
        this.pdcxFilePath = file;
        this.logFrame = new WLogFrame();
        this.logFrame.pack();
        this.flowManager = new FlowManager(new FlowEventListener(){

            @Override
            public void flowLogPosted(DXCLogEvent dXCLogEvent) {
                WPDCXRootPane.this.logFrame.append(dXCLogEvent.getString() + "\n");
            }

            public void flowInfoPosted(RPCInvokeEvent rPCInvokeEvent) {
            }
        });
        this.buildMenu();
        this.buildUI();
        this.filenameChanged();
        if (file != null) {
            PDCXReader pDCXReader = PDCXReader.readFrom(file, this);
            this.sourceSystemPanel = pDCXReader.getSourceSystemPanel();
            this.renderSystemPanel = pDCXReader.getRenderSystemPanel();
        }
        if (this.sourceSystemPanel == null) {
            this.sourceSystemPanel = new WSystemPanel(this, ConfigSchema.sourceSystemElement);
        }
        if (this.renderSystemPanel == null) {
            this.renderSystemPanel = new WSystemPanel(this, ConfigSchema.renderSystemElement);
        }
        this.sourceScrollPane.setViewportView(this.sourceSystemPanel);
        this.renderScrollPane.setViewportView(this.renderSystemPanel);
    }

    @Override
    public boolean confirmClose() {
        if (this.unsavedWorkFlag) {
            Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
            if (window != null) {
                window.setVisible(true);
                window.toFront();
                window.requestFocus();
            }
            if (!this.showConfirmCloseMsg()) {
                return false;
            }
        }
        if (this.playingFlag) {
            this.stop();
        }
        return true;
    }

    @Override
    public void dispose() {
        if (this.playingFlag) {
            this.stop();
        }
    }

    @Override
    public void appendLog(String string) {
        this.logFrame.append(string + "\n");
    }

    @Override
    public void setUnsavedWork() {
        this.unsavedWorkFlag = true;
        this.filenameChanged();
    }

    @Override
    public int requestFilterID() {
        return this.filterIDPool.requestID();
    }

    @Override
    public void releaseFilterID(int n) {
        this.filterIDPool.releaseID(n);
    }

    @Override
    public void serviceUpdate(ServiceInfo serviceInfo, ServiceInfo serviceInfo2) {
        this.serviceManager.serviceUpdate(serviceInfo, serviceInfo2);
    }

    @Override
    public ServiceList[] getServiceLists(int n) {
        return this.serviceManager.getServiceLists(n);
    }

    @Override
    public FilterSpec[] getSourcePluginOptions(int n) {
        if (n < 0) {
            return null;
        }
        ArrayList<FilterSpec> arrayList = new ArrayList<FilterSpec>();
        for (FilterSpec filterSpec : ConfigSchema.filterSpecList) {
            int n2;
            int n3 = filterSpec.getLaneCount();
            if (n3 == 0 || n3 > 1 || filterSpec.getLaneInputType(n2 = 0) != n) continue;
            arrayList.add(filterSpec);
        }
        int n4 = arrayList.size();
        return n4 > 0 ? arrayList.toArray(new FilterSpec[n4]) : null;
    }

    @Override
    public FilterSpec[] getSinkPluginOptions(int n) {
        if (n < 0) {
            return null;
        }
        ArrayList<FilterSpec> arrayList = new ArrayList<FilterSpec>();
        for (FilterSpec filterSpec : ConfigSchema.filterSpecList) {
            int n2;
            int n3;
            int n4 = filterSpec.getBranchCount();
            if (n4 != 0 || (n3 = filterSpec.getLaneCount()) == 0 || n3 > 1 || filterSpec.getLaneInputType(n2 = 0) != n || filterSpec.getLaneOutputType(n2) != n) continue;
            arrayList.add(filterSpec);
        }
        int n5 = arrayList.size();
        return n5 > 0 ? arrayList.toArray(new FilterSpec[n5]) : null;
    }
}

