/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.plj;

import dexlogic.parsec.plj.FeedEntry;
import dexlogic.parsec.plj.RenderOptionsEvent;
import dexlogic.parsec.plj.RenderOptionsListener;
import dexlogic.parsec.plj.RenderSetup;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.MutableComboBoxModel;
import javax.swing.border.Border;

public class WFeedListPanel
extends JPanel {
    RenderSetup renderSetup;
    private HashSet<FeedEntry> feedSet;
    private ArrayList<FeedCtl> feedCtlList = new ArrayList();

    private void addFeed(int n, FeedEntry feedEntry) {
        FeedCtl feedCtl = new FeedCtl(feedEntry);
        this.feedCtlList.add(feedCtl);
        int n2 = 4;
        int n3 = 4;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.insets = new Insets(n2, 0, n3, 0);
        this.add((Component)feedCtl.enableCheck, gridBagConstraints);
        if (feedEntry.hostName != null && feedEntry.hostName.length() > 0) {
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n;
            gridBagConstraints.insets = new Insets(n2, 5, n3, 0);
            this.add((Component)new JLabel(feedEntry.hostName), gridBagConstraints);
        }
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.insets = new Insets(n2, 5, n3, 0);
        this.add((Component)new JLabel("at"), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = n;
        gridBagConstraints.insets = new Insets(n2, 5, n3, 0);
        this.add((Component)new JLabel(feedEntry.remoteAddress.toString()), gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(n2, 0, n3, 0);
        this.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = n;
        gridBagConstraints.insets = new Insets(n2, 5, n3, 0);
        this.add(feedCtl.patchCombo, gridBagConstraints);
    }

    private void buildUI() {
        this.setLayout(new GridBagLayout());
    }

    private void updateProcessingOptions() {
        for (FeedCtl feedCtl : this.feedCtlList) {
            feedCtl.updateProcessingOptions(this.renderSetup);
        }
    }

    public WFeedListPanel(RenderSetup renderSetup) {
        this.renderSetup = renderSetup;
        this.buildUI();
        RenderOptionsListener renderOptionsListener = new RenderOptionsListener(){

            @Override
            public void renderOptionsChanged(RenderOptionsEvent renderOptionsEvent) {
                WFeedListPanel.this.updateProcessingOptions();
            }
        };
        renderSetup.addRenderOptionsListener(renderOptionsListener);
    }

    public void updateFeeds(HashSet<FeedEntry> hashSet) {
        this.removeAll();
        this.feedCtlList.clear();
        int n = 0;
        for (FeedEntry feedEntry : hashSet) {
            this.addFeed(n++, feedEntry);
        }
        this.updateProcessingOptions();
    }

    class FeedCtl {
        boolean patchOptionsValid = false;
        FeedEntry feed;
        JCheckBox enableCheck;
        JComboBox<String> patchCombo;

        void updatePatchValid() {
            Object object;
            boolean bl = false;
            Object object2 = this.patchCombo.getEditor().getItem();
            if (object2 != null && object2 instanceof String) {
                object = (String)object2;
                int n = this.patchCombo.getItemCount();
                for (int i = 0; i < n; ++i) {
                    if (!((String)object).equals(this.patchCombo.getItemAt(i))) continue;
                    bl = true;
                    break;
                }
            }
            object = this.patchCombo.getEditor().getEditorComponent();
            if (bl) {
                ((Component)object).setBackground(new Color(11071656));
            } else if (!this.patchOptionsValid) {
                ((Component)object).setBackground(null);
            } else {
                ((Component)object).setBackground(new Color(0xFFA0A0));
            }
        }

        void updateProcessingOptions(RenderSetup renderSetup) {
            while (this.patchCombo.getItemCount() > 1) {
                this.patchCombo.removeItemAt(1);
            }
            String[] stringArray = renderSetup.getPatchOptions(128);
            for (int i = 0; i < stringArray.length; ++i) {
                this.patchCombo.addItem(stringArray[i]);
            }
            this.patchOptionsValid = true;
            this.updatePatchValid();
        }

        public FeedCtl(final FeedEntry feedEntry) {
            this.feed = feedEntry;
            this.enableCheck = new JCheckBox(feedEntry.unitID.toString());
            this.enableCheck.setSelected(true);
            this.enableCheck.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl;
                    feedEntry.enabled = bl = ((JCheckBox)actionEvent.getSource()).isSelected();
                }
            });
            CBModel<String> cBModel = new CBModel<String>(new String[]{"void"});
            this.patchCombo = new JComboBox<String>(cBModel);
            this.patchCombo.setPrototypeDisplayValue("XXXXXXXXXX");
            this.patchCombo.setEditable(true);
            this.patchCombo.setEditor(new CBEditor());
            JTextField jTextField = (JTextField)this.patchCombo.getEditor().getEditorComponent();
            jTextField.setEditable(false);
            this.patchCombo.setSelectedIndex(0);
            this.patchCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object;
                    feedEntry.patch = FeedCtl.this.patchCombo.getSelectedIndex() == 0 ? "" : ((object = FeedCtl.this.patchCombo.getSelectedItem()) == null ? null : (object instanceof String ? (String)object : ""));
                    FeedCtl.this.updatePatchValid();
                }
            });
        }
    }

    public static class CBModel<E>
    extends AbstractListModel<E>
    implements MutableComboBoxModel<E> {
        ArrayList<E> objects = new ArrayList();
        Object selectedObject;

        public CBModel() {
        }

        public CBModel(E[] EArray) {
            int n = EArray.length;
            for (int i = 0; i < n; ++i) {
                this.objects.add(EArray[i]);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedObject;
        }

        @Override
        public void setSelectedItem(Object object) {
            if (this.selectedObject != null && !this.selectedObject.equals(object) || this.selectedObject == null && object != null) {
                this.selectedObject = object;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public E getElementAt(int n) {
            if (n >= 0 && n < this.objects.size()) {
                return this.objects.get(n);
            }
            return null;
        }

        @Override
        public int getSize() {
            return this.objects.size();
        }

        @Override
        public void addElement(E e) {
            this.objects.add(e);
            this.fireIntervalAdded(this, this.objects.size() - 1, this.objects.size() - 1);
        }

        @Override
        public void insertElementAt(E e, int n) {
            this.objects.add(n, e);
            this.fireIntervalAdded(this, n, n);
        }

        @Override
        public void removeElement(Object object) {
            int n = this.objects.indexOf(object);
            if (n >= 0) {
                this.removeElementAt(n);
            }
        }

        @Override
        public void removeElementAt(int n) {
            this.objects.remove(n);
            this.fireIntervalRemoved(this, n, n);
        }
    }

    static class CBEditor
    implements ComboBoxEditor {
        protected JTextField editor = new JTextField("", 9){
            private Color validationColor;
            {
                super(string, n);
                this.validationColor = null;
            }

            @Override
            public void setText(String string) {
                if (this.getText().equals(string)) {
                    return;
                }
                super.setText(string);
                this.setCaretPosition(0);
            }

            @Override
            public Color getBackground() {
                if (this.isEnabled() && this.validationColor != null) {
                    return this.validationColor;
                }
                return super.getBackground();
            }

            @Override
            public void setBackground(Color color) {
                this.validationColor = color;
                this.repaint();
            }

            @Override
            public void setBorder(Border border) {
                Border border2 = BorderFactory.createEmptyBorder(0, 3, 0, 3);
                super.setBorder(BorderFactory.createCompoundBorder(border, border2));
            }
        };
        protected Object editorItem;

        @Override
        public Component getEditorComponent() {
            return this.editor;
        }

        @Override
        public void setItem(Object object) {
            String string = object != null ? object.toString() : null;
            this.editor.setText(string == null ? "" : string);
            this.editorItem = object;
        }

        @Override
        public Object getItem() {
            return this.editorItem;
        }

        @Override
        public void selectAll() {
            this.editor.selectAll();
            this.editor.requestFocus();
        }

        @Override
        public void addActionListener(ActionListener actionListener) {
            this.editor.addActionListener(actionListener);
        }

        @Override
        public void removeActionListener(ActionListener actionListener) {
            this.editor.removeActionListener(actionListener);
        }
    }
}

