/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.pplx;

import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.pplx.FeedSetupEvent;
import dexlogic.parsec.pplx.FeedSetupListener;
import dexlogic.parsec.pplx.MediaEntry;
import dexlogic.parsec.pplx.WFeedPanel;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.swing.table.AbstractTableModel;

class PlaylistModel
extends AbstractTableModel {
    private String[] columnNames = new String[]{"File", "Title", "Artist", "Length"};
    private ArrayList<MediaEntry> mediaList = new ArrayList();
    private MediaEntry markedEntry = null;

    public Iterable<MediaEntry> getEntryIterable() {
        return this.mediaList;
    }

    public MediaEntry getMediaEntry(int n) {
        if (n < 0 || n >= this.mediaList.size()) {
            return null;
        }
        return this.mediaList.get(n);
    }

    public int getEntryRow(MediaEntry mediaEntry) {
        if (mediaEntry == null) {
            return -1;
        }
        return this.mediaList.indexOf(mediaEntry);
    }

    public long getDurationMS() {
        long l = 0L;
        for (MediaEntry mediaEntry : this.mediaList) {
            long l2 = mediaEntry.getDurationMS();
            l = ParsecTools.addDuration(l, l2);
        }
        return l;
    }

    public long getRemainingMS(MediaEntry mediaEntry) {
        int n = this.mediaList.indexOf(mediaEntry);
        if (n < 0) {
            return -1L;
        }
        long l = 0L;
        ListIterator<MediaEntry> listIterator = this.mediaList.listIterator(n);
        while (listIterator.hasNext()) {
            long l2 = listIterator.next().getDurationMS();
            l = ParsecTools.addDuration(l, l2);
        }
        return l;
    }

    public void addMedia(MediaEntry mediaEntry) {
        if (mediaEntry == null) {
            return;
        }
        WFeedPanel wFeedPanel = mediaEntry.feedPanel;
        if (wFeedPanel != null) {
            wFeedPanel.addSetupListener(new FeedSetupListener(){
                MediaEntry mediaEntry;

                public FeedSetupListener init(MediaEntry mediaEntry) {
                    this.mediaEntry = mediaEntry;
                    return this;
                }

                @Override
                public void mediaSourceChanged(FeedSetupEvent feedSetupEvent) {
                    if (!(feedSetupEvent.getSource() instanceof WFeedPanel)) {
                        return;
                    }
                    WFeedPanel wFeedPanel = (WFeedPanel)feedSetupEvent.getSource();
                    int n = PlaylistModel.this.mediaList.indexOf(this.mediaEntry);
                    if (n >= 0) {
                        PlaylistModel.this.fireTableCellUpdated(n, -1);
                    }
                }
            }.init(mediaEntry));
        }
        int n = this.mediaList.size();
        this.mediaList.add(mediaEntry);
        this.fireTableRowsInserted(n, n);
    }

    public void removeFile(MediaEntry mediaEntry) {
        WFeedPanel wFeedPanel;
        if (mediaEntry == null) {
            return;
        }
        int n = this.mediaList.indexOf(mediaEntry);
        if (this.mediaList.remove(n) == this.markedEntry) {
            System.out.println("PlaylistModel: Removal of marked enty");
            this.markedEntry = null;
        }
        if ((wFeedPanel = mediaEntry.feedPanel) != null) {
            wFeedPanel.discard();
        }
        this.fireTableRowsDeleted(n, n);
    }

    public void reorder(int n, int n2) {
        if (n2 < n) {
            MediaEntry mediaEntry = this.mediaList.remove(n);
            this.fireTableRowsDeleted(n, n);
            this.mediaList.add(n2, mediaEntry);
            this.fireTableRowsInserted(n2, n2);
        } else if (n2 > n + 1) {
            MediaEntry mediaEntry = this.mediaList.remove(n);
            this.fireTableRowsDeleted(n, n);
            this.mediaList.add(--n2, mediaEntry);
            this.fireTableRowsInserted(n2, n2);
        }
    }

    public boolean isMarked(int n) {
        MediaEntry mediaEntry = this.getMediaEntry(n);
        if (mediaEntry == null) {
            return false;
        }
        return mediaEntry == this.markedEntry;
    }

    public void setMarked(MediaEntry mediaEntry) {
        int n;
        if (this.markedEntry != null) {
            n = this.mediaList.indexOf(this.markedEntry);
            this.markedEntry = null;
            if (n >= 0) {
                this.fireTableCellUpdated(n, -1);
            }
        }
        if (mediaEntry != null && (n = this.mediaList.indexOf(mediaEntry)) >= 0) {
            this.markedEntry = mediaEntry;
            this.fireTableCellUpdated(n, -1);
        }
    }

    public MediaEntry getMarked() {
        return this.markedEntry;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public int getRowCount() {
        return this.mediaList.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        MediaEntry mediaEntry = this.getMediaEntry(n);
        if (mediaEntry == null) {
            return null;
        }
        if (n2 == 0) {
            return mediaEntry.displayName;
        }
        if (n2 == 3) {
            long l = mediaEntry.getDurationMS();
            return ParsecTools.durationToString(l);
        }
        return "";
    }
}

