/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.pplx;

import dexlogic.parsec.InternalParsecException;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.SeekSliderUI;
import dexlogic.parsec.UniqueID;
import dexlogic.parsec.config.ConfigSchema;
import dexlogic.parsec.config.FilterSpec;
import dexlogic.parsec.config.ServiceInfo;
import dexlogic.parsec.config.ServiceList;
import dexlogic.parsec.config.ServiceManager;
import dexlogic.parsec.config.SetupProvider;
import dexlogic.parsec.pplx.MediaEntry;
import dexlogic.parsec.pplx.MediaProxyBuilder;
import dexlogic.parsec.pplx.PlaylistModel;
import dexlogic.parsec.pplx.WPPLXRootPane;
import dexlogic.parsec.remote.WAlertIndicator;
import dexlogic.parsec.routes.DXCLogEvent;
import dexlogic.parsec.routes.FlowEventListener;
import dexlogic.parsec.routes.FlowManager;
import dexlogic.parsec.routes.FlowProxy;
import dexlogic.parsec.routes.FlowProxyBuilder;
import dexlogic.parsec.routes.RPCInvokeAdapter;
import dexlogic.parsec.routes.RPCInvokeEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WControlPanel
extends JPanel
implements FlowEventListener,
SetupProvider {
    private PlaylistModel playlistModel;
    private JSlider seekSlider;
    private JToggleButton stopButton;
    private JToggleButton playButton;
    private JToggleButton pauseButton;
    private JToggleButton preloadButton;
    private WAlertIndicator alertIndicator;
    private JLabel elapsedFileLabel;
    private JLabel remainFileLabel;
    private JLabel remainListLabel;
    private long headTimeMS;
    private long fileDurationMS;
    private long listDurationMS;
    private MediaEntry selectedEntry;
    private ServiceManager serviceManager = new ServiceManager();
    private UniqueID filterIDPool = new UniqueID();
    private FlowManager flowManager;
    private int runState;
    private MediaEntry loadedEntry;
    private FlowProxy loadedProxy;
    private RPCInvokeAdapter statsAdapter;
    private static final int STATE_VOID = 0;
    private static final int STATE_INITIALIZED = 1;
    private static final int STATE_LOADED = 2;
    private static final int STATE_PAUSE = 3;
    private static final int STATE_PRELOAD = 4;
    private static final int STATE_PLAY = 5;

    private void updateTime() {
        this.seekSlider.setValue((int)this.headTimeMS);
        boolean bl = this.seekSlider.isEnabled();
        long l = this.headTimeMS / 1000L * 1000L;
        String string = bl ? ParsecTools.durationToString(l) : ParsecTools.durationToString(0L);
        this.elapsedFileLabel.setText(string);
        long l2 = this.fileDurationMS / 1000L * 1000L - this.headTimeMS;
        if (l2 < 0L) {
            l2 = 0L;
        }
        Object object = bl ? "-" + ParsecTools.durationToString(l2) : ParsecTools.durationToString(0L);
        this.remainFileLabel.setText((String)object);
        long l3 = this.listDurationMS / 1000L * 1000L - this.headTimeMS;
        if (l3 < 0L) {
            l3 = 0L;
        }
        String string2 = "-" + ParsecTools.durationToString(l3);
        this.remainListLabel.setText(string2);
    }

    private void processFeedStats(RPCInvokeEvent rPCInvokeEvent) {
        String string = rPCInvokeEvent.getRPCArg();
        if (this.runState < 2) {
            return;
        }
        if (this.seekSlider.getValueIsAdjusting()) {
            return;
        }
        int n = string.indexOf("headTime");
        int n2 = -1;
        if (n >= 0) {
            n = string.indexOf(58, n);
        }
        if (n >= 0) {
            ++n;
        }
        if (n >= 0 && (n2 = string.indexOf(44, n)) < 0) {
            n2 = string.indexOf(125, n);
        }
        if (n >= 0 && n2 >= 0) {
            try {
                this.headTimeMS = (int)(Double.valueOf(string.substring(n, n2)) * 1000.0);
                if (this.headTimeMS > this.fileDurationMS) {
                    this.headTimeMS = this.fileDurationMS;
                }
                this.updateTime();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.runState == 5 && string.indexOf("\"info\":\"leadout\"") >= 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WControlPanel.this.next();
                }
            });
        }
    }

    private void loadEntry(MediaEntry mediaEntry) {
        this.loadedEntry = mediaEntry;
        if (this.loadedEntry != this.selectedEntry) {
            this.headTimeMS = 0L;
            this.fileDurationMS = this.loadedEntry.getDurationMS();
            this.listDurationMS = this.playlistModel.getRemainingMS(this.loadedEntry);
            this.seekSlider.setMaximum((int)this.fileDurationMS);
            this.seekSlider.setEnabled(true);
            this.updateTime();
        }
        if (this.loadedEntry.feedPanel != null) {
            this.loadedEntry.feedPanel.setWorkLock(true);
        }
        this.playlistModel.setMarked(this.loadedEntry);
        this.loadedEntry.mediaSource.getFeed().addInvokeAdapter(this.statsAdapter);
    }

    private void unloadEntry() {
        this.loadedEntry.mediaSource.getFeed().removeInvokeAdapter(this.statsAdapter);
        if (this.loadedEntry != this.selectedEntry) {
            if (this.selectedEntry != null) {
                this.headTimeMS = 0L;
                this.fileDurationMS = this.selectedEntry.getDurationMS();
                this.listDurationMS = this.playlistModel.getRemainingMS(this.selectedEntry);
            } else {
                this.fileDurationMS = 0L;
                this.headTimeMS = 0L;
                this.listDurationMS = this.playlistModel.getDurationMS();
                this.seekSlider.setEnabled(false);
            }
            this.seekSlider.setMaximum((int)this.fileDurationMS);
            this.updateTime();
        }
        if (this.loadedEntry.feedPanel != null) {
            this.loadedEntry.feedPanel.setWorkLock(false);
        }
        this.playlistModel.setMarked(null);
        this.loadedEntry = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(int n, MediaEntry mediaEntry) {
        if (this.runState == n) {
            return;
        }
        try {
            if (this.runState == 0 && n > 0) {
                this.setRenderWorkLock(true);
                this.flowManager.createEntity();
                this.flowManager.loadProxy(this.getRenderProxyBuilder());
                this.runState = 1;
            }
            if (this.runState == 1 && n > 1) {
                if (mediaEntry == null) {
                    throw new InternalParsecException("Aborted: No media entry");
                }
                this.loadEntry(mediaEntry);
                this.loadedProxy = this.flowManager.loadProxy(new MediaProxyBuilder(this.loadedEntry.mediaSource));
                this.flowManager.seek((int)this.headTimeMS, null);
                this.runState = 2;
            }
            if (this.runState >= 2) {
                if (n <= 2) {
                    this.flowManager.stop(null);
                    this.runState = 2;
                } else if (n == 3) {
                    this.flowManager.pause(null);
                    this.runState = n;
                } else if (n == 4) {
                    this.flowManager.preload(null);
                    this.runState = n;
                } else if (n == 5) {
                    this.flowManager.play(null);
                    this.runState = n;
                } else {
                    throw new InternalParsecException("Invalid state request");
                }
            }
            if (this.runState > 0 && n <= 0) {
                this.flowManager.destroyEntity();
                this.setRenderWorkLock(false);
                if (this.loadedEntry != null) {
                    this.unloadEntry();
                }
                this.runState = 0;
            }
        }
        catch (Throwable throwable) {
            this.flowManager.destroyEntity();
            this.setRenderWorkLock(false);
            if (this.loadedEntry != null) {
                this.unloadEntry();
            }
            this.runState = 0;
            String string = "Playback Error";
            ParsecTools.showExceptionDialog(this, string, throwable);
        }
        finally {
            if (this.runState == 3) {
                this.pauseButton.setSelected(true);
            } else if (this.runState == 4) {
                this.preloadButton.setSelected(true);
            } else if (this.runState == 5) {
                this.playButton.setSelected(true);
            } else {
                this.stopButton.setSelected(true);
            }
        }
    }

    private void loadAndApply(int n, MediaEntry mediaEntry) {
        int n2 = this.runState;
        if (this.runState > 0) {
            this.changeState(0, null);
        }
        if (n2 == 0) {
            this.logClear();
        } else {
            this.logAppend("\n");
        }
        if (mediaEntry != null) {
            this.changeState(n, mediaEntry);
        }
    }

    private void applyAction(int n) {
        if (this.runState == n) {
            return;
        }
        if (this.runState < 2 && n >= 2) {
            MediaEntry mediaEntry = this.selectedEntry;
            if (mediaEntry == null) {
                mediaEntry = this.getNextEntry(null, true);
            }
            if (mediaEntry != null) {
                this.loadAndApply(n, mediaEntry);
            }
        } else if (this.runState >= 2) {
            this.changeState(n, this.loadedEntry);
        } else {
            this.changeState(n, null);
        }
    }

    private void skip(int n) {
        if (this.loadedEntry != null) {
            boolean bl = this.loadedEntry == this.selectedEntry;
            MediaEntry mediaEntry = null;
            if (n > 0) {
                mediaEntry = this.getNextEntry(this.loadedEntry, bl);
            }
            if (n < 0) {
                mediaEntry = this.getPrevEntry(this.loadedEntry, bl);
            }
            if (mediaEntry != null) {
                this.loadAndApply(this.runState, mediaEntry);
            }
        } else {
            if (n > 0) {
                this.getNextEntry(null, true);
            }
            if (n < 0) {
                this.getPrevEntry(null, true);
            }
        }
    }

    private void next() {
        if (this.loadedEntry != null) {
            boolean bl = this.loadedEntry == this.selectedEntry;
            MediaEntry mediaEntry = null;
            mediaEntry = this.getNextEntry(this.loadedEntry, bl);
            if (mediaEntry != null) {
                this.loadAndPlay(mediaEntry);
            } else {
                this.stop();
            }
        }
    }

    private ImageIcon getIconImage(String string) {
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            return new ImageIcon(ImageIO.read(inputStream));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private JButton createCtlButton(String string) {
        JButton jButton = new JButton();
        jButton.setIcon(this.getIconImage(string));
        jButton.setMargin(new Insets(5, 8, 5, 8));
        jButton.setBorderPainted(false);
        return jButton;
    }

    private JToggleButton createCtlToggleButton(String string) {
        JToggleButton jToggleButton = new JToggleButton();
        jToggleButton.setIcon(this.getIconImage(string));
        jToggleButton.setMargin(new Insets(5, 8, 5, 8));
        jToggleButton.setBorderPainted(false);
        return jToggleButton;
    }

    private void buildUI() {
        WControlPanel wControlPanel = this;
        wControlPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.seekSlider = new JSlider(){

            @Override
            public void updateUI() {
                this.setUI(new SeekSliderUI(this));
            }
        };
        this.seekSlider.setEnabled(false);
        this.seekSlider.setMinimum(0);
        this.seekSlider.setValue(0);
        this.seekSlider.setBorder(new EmptyBorder(5, 0, 5, 0));
        this.seekSlider.addChangeListener(new ChangeListener(){
            private boolean isAdjusting = false;
            private int savedState;
            private MediaEntry savedEntry = null;

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSlider jSlider = (JSlider)changeEvent.getSource();
                if (jSlider.getValueIsAdjusting()) {
                    if (!this.isAdjusting) {
                        this.isAdjusting = true;
                        this.savedEntry = WControlPanel.this.loadedEntry;
                        this.savedState = WControlPanel.this.runState;
                        if (WControlPanel.this.runState == 5) {
                            try {
                                WControlPanel.this.flowManager.pause(null);
                            }
                            catch (Throwable throwable) {
                                String string = "Seek Error";
                                ParsecTools.showExceptionDialog(jSlider, string, throwable);
                            }
                        }
                    } else if (this.savedEntry == WControlPanel.this.loadedEntry) {
                        int n = jSlider.getValue();
                        if (this.savedState >= 2) {
                            try {
                                WControlPanel.this.flowManager.seek(n, null);
                            }
                            catch (Throwable throwable) {
                                String string = "Seek Error";
                                ParsecTools.showExceptionDialog(jSlider, string, throwable);
                            }
                        }
                        WControlPanel.this.headTimeMS = n;
                        WControlPanel.this.updateTime();
                    }
                } else if (this.isAdjusting) {
                    this.isAdjusting = false;
                    if (this.savedEntry == WControlPanel.this.loadedEntry && this.savedState >= WControlPanel.this.runState && WControlPanel.this.runState == 5) {
                        try {
                            WControlPanel.this.flowManager.play(null);
                        }
                        catch (Throwable throwable) {
                            String string = "Seek Error";
                            ParsecTools.showExceptionDialog(jSlider, string, throwable);
                        }
                    }
                }
            }
        });
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        wControlPanel.add((Component)this.seekSlider, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        ButtonGroup buttonGroup = new ButtonGroup();
        this.stopButton = this.createCtlToggleButton("/icons/stop-button.png");
        buttonGroup.add(this.stopButton);
        this.stopButton.setSelected(true);
        this.stopButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WControlPanel.this.applyAction(0);
            }
        });
        this.playButton = this.createCtlToggleButton("/icons/play-button.png");
        buttonGroup.add(this.playButton);
        this.playButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WControlPanel.this.applyAction(5);
            }
        });
        this.pauseButton = this.createCtlToggleButton("/icons/pause-button.png");
        buttonGroup.add(this.pauseButton);
        this.pauseButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WControlPanel.this.applyAction(3);
            }
        });
        this.preloadButton = this.createCtlToggleButton("/icons/preload-button.png");
        buttonGroup.add(this.preloadButton);
        this.preloadButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WControlPanel.this.applyAction(4);
            }
        });
        JButton jButton = this.createCtlButton("/icons/previous-button.png");
        jButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WControlPanel.this.skip(-1);
            }
        });
        JButton jButton2 = this.createCtlButton("/icons/next-button.png");
        jButton2.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WControlPanel.this.skip(1);
            }
        });
        JButton jButton3 = new JButton();
        jButton3.setMargin(new Insets(1, 4, 1, 4));
        jButton3.setBorderPainted(false);
        JButton jButton4 = new JButton();
        jButton4.setMargin(new Insets(1, 4, 1, 4));
        jButton4.setBorderPainted(false);
        int n = 0;
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        wControlPanel.add((Component)this.stopButton, gridBagConstraints);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        wControlPanel.add((Component)jButton3, gridBagConstraints);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        wControlPanel.add((Component)this.pauseButton, gridBagConstraints);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        wControlPanel.add((Component)this.playButton, gridBagConstraints);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        wControlPanel.add((Component)this.preloadButton, gridBagConstraints);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        wControlPanel.add((Component)jButton4, gridBagConstraints);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        wControlPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        wControlPanel.add((Component)jButton2, gridBagConstraints);
        this.alertIndicator = new WAlertIndicator(this.flowManager, 1);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        wControlPanel.add((Component)this.alertIndicator, gridBagConstraints);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        wControlPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        this.elapsedFileLabel = new JLabel("0:00");
        this.remainFileLabel = new JLabel("0:00");
        this.remainListLabel = new JLabel("0:00");
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        wControlPanel.add((Component)this.elapsedFileLabel, gridBagConstraints);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        wControlPanel.add((Component)new JLabel(" / "), gridBagConstraints);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        wControlPanel.add((Component)this.remainFileLabel, gridBagConstraints);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        wControlPanel.add((Component)new JLabel(" / "), gridBagConstraints);
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        wControlPanel.add((Component)this.remainListLabel, gridBagConstraints);
    }

    protected void logClear() {
    }

    protected void logAppend(String string) {
    }

    protected MediaEntry getNextEntry(MediaEntry mediaEntry, boolean bl) {
        return null;
    }

    protected MediaEntry getPrevEntry(MediaEntry mediaEntry, boolean bl) {
        return null;
    }

    protected void setRenderWorkLock(boolean bl) {
    }

    protected FlowProxyBuilder getRenderProxyBuilder() {
        return null;
    }

    public WControlPanel(PlaylistModel playlistModel) {
        this.playlistModel = playlistModel;
        this.headTimeMS = 0L;
        this.fileDurationMS = 0L;
        this.listDurationMS = 0L;
        this.selectedEntry = null;
        this.flowManager = new FlowManager(this);
        this.runState = 0;
        this.loadedEntry = null;
        this.statsAdapter = new RPCInvokeAdapter("rla-stats"){

            @Override
            public void rpcInvoked(RPCInvokeEvent rPCInvokeEvent) {
                WControlPanel.this.processFeedStats(rPCInvokeEvent);
            }
        };
        this.buildUI();
    }

    public void updateTotalTime() {
        this.listDurationMS = this.loadedEntry != null ? this.playlistModel.getRemainingMS(this.loadedEntry) : (this.selectedEntry != null ? this.playlistModel.getRemainingMS(this.selectedEntry) : this.playlistModel.getDurationMS());
        this.updateTime();
    }

    public void setSelected(MediaEntry mediaEntry) {
        if (this.loadedEntry == null && mediaEntry != this.selectedEntry) {
            boolean bl = false;
            if (mediaEntry != null) {
                this.headTimeMS = 0L;
                this.fileDurationMS = mediaEntry.getDurationMS();
                this.listDurationMS = this.playlistModel.getRemainingMS(mediaEntry);
                bl = true;
            } else {
                this.fileDurationMS = 0L;
                this.headTimeMS = 0L;
                this.listDurationMS = this.playlistModel.getDurationMS();
            }
            this.seekSlider.setMaximum((int)this.fileDurationMS);
            this.seekSlider.setEnabled(bl);
            this.updateTime();
        }
        this.selectedEntry = mediaEntry;
    }

    public void loadAndPlay(MediaEntry mediaEntry) {
        if (mediaEntry != null) {
            this.loadAndApply(5, mediaEntry);
        }
    }

    public void ejectIfLoaded(MediaEntry mediaEntry) {
        if (this.loadedEntry != null && this.loadedEntry == mediaEntry) {
            this.applyAction(0);
        }
    }

    public void stop() {
        this.applyAction(0);
    }

    @Override
    public void flowLogPosted(DXCLogEvent dXCLogEvent) {
        this.logAppend(dXCLogEvent.getString());
    }

    @Override
    public void appendLog(String string) {
        this.logAppend(string);
    }

    @Override
    public void setUnsavedWork() {
        Container container = SwingUtilities.getAncestorOfClass(WPPLXRootPane.class, this);
        if (container != null) {
            ((WPPLXRootPane)container).setUnsavedWork();
        }
    }

    @Override
    public int requestFilterID() {
        return this.filterIDPool.requestID();
    }

    @Override
    public void releaseFilterID(int n) {
        this.filterIDPool.releaseID(n);
    }

    @Override
    public void serviceUpdate(ServiceInfo serviceInfo, ServiceInfo serviceInfo2) {
        this.serviceManager.serviceUpdate(serviceInfo, serviceInfo2);
    }

    @Override
    public ServiceList[] getServiceLists(int n) {
        return this.serviceManager.getServiceLists(n);
    }

    @Override
    public FilterSpec[] getSourcePluginOptions(int n) {
        if (n < 0) {
            return null;
        }
        ArrayList<FilterSpec> arrayList = new ArrayList<FilterSpec>();
        for (FilterSpec filterSpec : ConfigSchema.filterSpecList) {
            int n2;
            int n3 = filterSpec.getLaneCount();
            if (n3 == 0 || n3 > 1 || filterSpec.getLaneInputType(n2 = 0) != n) continue;
            arrayList.add(filterSpec);
        }
        int n4 = arrayList.size();
        return n4 > 0 ? arrayList.toArray(new FilterSpec[n4]) : null;
    }

    @Override
    public FilterSpec[] getSinkPluginOptions(int n) {
        if (n < 0) {
            return null;
        }
        ArrayList<FilterSpec> arrayList = new ArrayList<FilterSpec>();
        for (FilterSpec filterSpec : ConfigSchema.filterSpecList) {
            int n2;
            int n3;
            int n4 = filterSpec.getBranchCount();
            if (n4 != 0 || (n3 = filterSpec.getLaneCount()) == 0 || n3 > 1 || filterSpec.getLaneInputType(n2 = 0) != n || filterSpec.getLaneOutputType(n2) != n) continue;
            arrayList.add(filterSpec);
        }
        int n5 = arrayList.size();
        return n5 > 0 ? arrayList.toArray(new FilterSpec[n5]) : null;
    }
}

