/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.pplx;

import dexlogic.parsec.MediaSource;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.config.FilterSpec;
import dexlogic.parsec.config.SetupProvider;
import dexlogic.parsec.config.UFilterButton;
import dexlogic.parsec.config.UPluginCombo;
import dexlogic.parsec.pplx.WFRoutingPanel;
import dexlogic.parsec.pplx.WFeedPanel;
import dexlogic.parsec.remote.ObjectRemotable;
import dexlogic.parsec.remote.WAlertIndicator;
import dexlogic.parsec.remote.WFilterDialog;
import dexlogic.parsec.routes.RPCInvokeAdapter;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

public class WFPluginListPanel
extends WFRoutingPanel {
    private WFeedPanel feedPanel;
    private WFRoutingPanel.RoutingCtl parentCtl;
    private int rowCount = 0;

    private void buildUI() {
        this.setLayout(new GridBagLayout());
        this.setBackground(WFeedPanel.darker(this.getBackground(), 0.96));
        this.setBorder(new MatteBorder(1, 1, 1, 0, WFeedPanel.darker(this.getBackground(), 0.85)));
    }

    PluginCtl addPlugin(MediaSource.Plugin plugin) {
        PluginCtl pluginCtl = new PluginCtl(this.feedPanel, this.parentCtl, plugin);
        pluginCtl.updateState();
        int n = 4;
        int n2 = 4;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.rowCount;
        gridBagConstraints.insets = new Insets(n, 4, n2, 0);
        this.add((Component)pluginCtl.pluginCheck, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = this.rowCount;
        gridBagConstraints.insets = new Insets(n, 0, n2, 0);
        this.add((Component)pluginCtl.inputTypeLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = this.rowCount;
        gridBagConstraints.insets = new Insets(n, 5, n2, 0);
        this.add((Component)pluginCtl.pluginCombo, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = this.rowCount;
        gridBagConstraints.insets = new Insets(n, 3, n2, 0);
        this.add((Component)pluginCtl.alertIndicator, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = this.rowCount;
        gridBagConstraints.insets = new Insets(n, 3, n2, 0);
        this.add((Component)pluginCtl.filterButton, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = this.rowCount;
        gridBagConstraints.insets = new Insets(n, 0, n2, 0);
        this.add((Component)pluginCtl.outputTypeLabel, gridBagConstraints);
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = this.rowCount;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(n, 0, n2, 0);
        this.add((Component)pluginCtl.hSpace, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = this.rowCount;
        gridBagConstraints.insets = new Insets(n, 15, n2, 0);
        this.add((Component)pluginCtl.routingPanel, gridBagConstraints);
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = this.rowCount;
        gridBagConstraints.insets = new Insets(n, 15, n2, 0);
        this.add((Component)pluginCtl.dspAddButton, gridBagConstraints);
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = this.rowCount++;
        gridBagConstraints.insets = new Insets(n, 5, n2, 4);
        this.add((Component)pluginCtl.dspRemoveButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.rowCount++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.add((Component)pluginCtl.pluginListPanel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        return pluginCtl;
    }

    public WFPluginListPanel(WFeedPanel wFeedPanel, WFRoutingPanel.RoutingCtl routingCtl) {
        this.feedPanel = wFeedPanel;
        this.parentCtl = routingCtl;
        this.buildUI();
    }

    public void addNewPlugin() {
        MediaSource.Plugin plugin = new MediaSource.Plugin();
        this.parentCtl.routing.plugins.add(plugin);
        if (this.isDisplayable()) {
            this.feedPanel.getSetupProvider().setUnsavedWork();
        }
        PluginCtl pluginCtl = this.addPlugin(plugin);
        pluginCtl.updateProcessingOptions();
        this.revalidate();
    }

    class PluginCtl
    extends WFRoutingPanel.RoutingCtl {
        private int filterID;
        private int inputType;
        private ObjectRemotable objectRemotable;
        private FilterSpec filterSpec;
        private WFilterDialog filterDialog;
        protected WFRoutingPanel.RoutingCtl parentCtl;
        protected MediaSource.Plugin plugin;
        protected JCheckBox pluginCheck;
        protected JLabel inputTypeLabel;
        protected UPluginCombo pluginCombo;
        protected WAlertIndicator alertIndicator;
        protected UFilterButton filterButton;
        protected JPanel hSpace;
        protected CardLayout routingLayout;
        protected JPanel routingPanel;

        private void updateInputTypeVisible() {
            int n = 8192;
            this.inputTypeLabel.setVisible(this.inputType >= 0 && (this.inputType & n) != 0);
        }

        private void updateFilterButtonEnable() {
            if (this.filterSpec == null) {
                this.filterButton.setEnabled(false);
            } else if (this.filterSpec.getDialogClass() == null) {
                this.filterButton.setEnabled(false);
            } else {
                this.filterButton.setEnabled(this.routing.enabled);
            }
        }

        @Override
        protected int getServiceType(MediaSource.Plugin plugin) {
            int n;
            if (this.inputType < 0) {
                return -1;
            }
            if (this.filterSpec == null) {
                return -1;
            }
            if (plugin != null) {
                n = this.routing.plugins.indexOf(plugin);
                if (n < 0) {
                    return -1;
                }
            } else {
                n = 0;
            }
            if (this.filterSpec.getBranchCount() == 0) {
                int n2 = this.filterSpec.getLaneOutputType(n);
                if (n2 == 0) {
                    return this.inputType & 0xFF;
                }
                if (n2 == (this.inputType & 0xFF)) {
                    return this.inputType & 0xFF;
                }
                return 0x1000 | n2;
            }
            return 0x2000 | this.filterSpec.getBranchOutputType(n);
        }

        @Override
        protected void remove() {
            if (this.filterDialog != null) {
                this.filterDialog.dispose();
                this.filterDialog = null;
            }
            this.pluginCheck.getParent().remove(this.pluginCheck);
            this.inputTypeLabel.getParent().remove(this.inputTypeLabel);
            this.pluginCombo.getParent().remove(this.pluginCombo);
            this.filterButton.getParent().remove(this.filterButton);
            this.alertIndicator.getParent().remove(this.alertIndicator);
            this.outputTypeLabel.getParent().remove(this.outputTypeLabel);
            this.hSpace.getParent().remove(this.hSpace);
            this.routingPanel.getParent().remove(this.routingPanel);
            this.dspAddButton.getParent().remove(this.dspAddButton);
            this.dspRemoveButton.getParent().remove(this.dspRemoveButton);
            this.pluginListPanel.getParent().remove(this.pluginListPanel);
            this.filterButton.discardNotify();
            if (this.filterID > 0) {
                this.feedPanel.getSetupProvider().releaseFilterID(this.filterID);
                this.filterID = -1;
            }
            super.remove();
            this.parentCtl.routing.plugins.remove(this.plugin);
            this.parentCtl.children.remove(this);
            this.parentCtl.updateState();
            this.parentCtl.updateOutputChain();
            this.parentCtl.pluginListPanel.revalidate();
        }

        public PluginCtl(final WFeedPanel wFeedPanel, WFRoutingPanel.RoutingCtl routingCtl, final MediaSource.Plugin plugin) {
            super(wFeedPanel, plugin.routing);
            this.filterID = -1;
            this.parentCtl = routingCtl;
            this.plugin = plugin;
            routingCtl.children.add(this);
            this.filterID = wFeedPanel.getSetupProvider().requestFilterID();
            plugin.pluginName = "F" + this.filterID;
            this.pluginCombo = new UPluginCombo();
            this.pluginCombo.setOpaque(false);
            if (plugin.style != null) {
                this.pluginCombo.putStyleAttrib(plugin.style);
            }
            this.pluginCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() != PluginCtl.this.pluginCombo) {
                        return;
                    }
                    plugin.setTransparent();
                    plugin.style = PluginCtl.this.pluginCombo.getStyleAttrib();
                    PluginCtl.this.filterSpec = PluginCtl.this.pluginCombo.getVerifiedFilterSpec();
                    PluginCtl.this.filterButton.setFilterSpec(PluginCtl.this.filterSpec);
                    PluginCtl.this.updateFilterButtonEnable();
                    if (WFPluginListPanel.this.isDisplayable()) {
                        wFeedPanel.getSetupProvider().setUnsavedWork();
                    }
                    PluginCtl.this.updateOutputChain();
                }
            });
            this.objectRemotable = new ObjectRemotable(){

                @Override
                public String getRPCArg() {
                    return plugin.getRPCArg();
                }

                @Override
                public void updateRPCArg(String string) {
                    plugin.updateRPCArg(string);
                    if (WFPluginListPanel.this.isDisplayable()) {
                        wFeedPanel.getSetupProvider().setUnsavedWork();
                    }
                }

                @Override
                public void addRPCInvokeAdapter(RPCInvokeAdapter rPCInvokeAdapter) {
                    plugin.addInvokeAdapter(rPCInvokeAdapter);
                }

                @Override
                public void removeRPCInvokeAdapter(RPCInvokeAdapter rPCInvokeAdapter) {
                    plugin.removeInvokeAdapter(rPCInvokeAdapter);
                }
            };
            this.alertIndicator = new WAlertIndicator(this.objectRemotable);
            this.filterButton = new UFilterButton(plugin.pluginName, this.objectRemotable);
            this.inputTypeLabel = WFeedPanel.createServiceTypeLabel();
            this.inputTypeLabel.setBorder(new EmptyBorder(1, 5, 0, 0));
            this.inputTypeLabel.setVisible(false);
            this.hSpace = new JPanel();
            this.hSpace.setOpaque(false);
            JLabel jLabel = new JLabel("Patch");
            jLabel.setOpaque(false);
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setOpaque(false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            jPanel.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(0, 7, 0, 0);
            jPanel.add((Component)this.patchCombo, gridBagConstraints);
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel2.setOpaque(false);
            this.routingLayout = new CardLayout();
            this.routingPanel = new JPanel(this.routingLayout);
            this.routingPanel.setOpaque(false);
            this.routingPanel.add(jPanel);
            this.routingPanel.add(jPanel2);
            this.pluginCheck = new JCheckBox("", plugin.routing.enabled);
            this.pluginCheck.setOpaque(false);
            this.pluginCheck.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl;
                    plugin.routing.enabled = bl = ((JCheckBox)actionEvent.getSource()).isSelected();
                    if (WFPluginListPanel.this.isDisplayable()) {
                        wFeedPanel.getSetupProvider().setUnsavedWork();
                    }
                    PluginCtl.this.updateState();
                }
            });
        }

        @Override
        public void updateState() {
            super.updateState();
            this.pluginCheck.setEnabled(true);
            this.pluginCombo.setEnabled(this.routing.enabled);
            this.updateFilterButtonEnable();
            if (this.routing.plugins.size() == 0) {
                this.routingLayout.first(this.routingPanel);
            } else {
                this.routingLayout.last(this.routingPanel);
            }
        }

        @Override
        public void setWorkLock(boolean bl) {
            super.setWorkLock(bl);
            if (bl) {
                this.pluginCheck.setEnabled(false);
                this.pluginCombo.setEnabled(false);
            }
        }

        @Override
        public void updateProcessingOptions() {
            this.inputType = this.parentCtl.getServiceType(this.plugin);
            this.inputTypeLabel.setText(ParsecTools.getServiceTypeText(this.inputType));
            this.updateInputTypeVisible();
            int n = this.inputType < 0 ? -1 : this.inputType & 0xFF;
            FilterSpec[] filterSpecArray = null;
            if (n > 0) {
                SetupProvider setupProvider = this.feedPanel.getSetupProvider();
                filterSpecArray = setupProvider.getSourcePluginOptions(n);
            }
            this.pluginCombo.setFilterOptions(filterSpecArray);
            this.filterSpec = this.pluginCombo.getVerifiedFilterSpec();
            this.filterButton.setFilterSpec(this.filterSpec);
            this.updateFilterButtonEnable();
            super.updateProcessingOptions();
        }
    }
}

