/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.pplx;

import dexlogic.parsec.MediaSource;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.config.ServiceList;
import dexlogic.parsec.config.SetupProvider;
import dexlogic.parsec.config.UPatchCombo;
import dexlogic.parsec.pplx.WFPluginListPanel;
import dexlogic.parsec.pplx.WFeedPanel;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class WFRoutingPanel
extends JPanel {

    class RoutingCtl {
        private boolean patchOptionsValid = false;
        private int outputType;
        protected WFeedPanel feedPanel;
        protected MediaSource.Routing routing;
        protected ArrayList<RoutingCtl> children = new ArrayList();
        protected JLabel outputTypeLabel;
        protected UPatchCombo patchCombo;
        protected JButton dspAddButton;
        protected JButton dspRemoveButton;
        WFPluginListPanel pluginListPanel;

        private void updateOutputTypeVisible() {
            int n = 4096;
            if (this.routing.plugins.size() == 0) {
                n |= 0x2000;
            }
            this.outputTypeLabel.setVisible(this.outputType >= 0 && (this.outputType & n) != 0);
        }

        protected int getServiceType(MediaSource.Plugin plugin) {
            return 0;
        }

        protected void remove() {
            this.patchCombo.setPatchOptions(null);
            if (WFRoutingPanel.this.isDisplayable()) {
                this.feedPanel.getSetupProvider().setUnsavedWork();
            }
            RoutingCtl[] routingCtlArray = this.children.toArray(new RoutingCtl[this.children.size()]);
            for (int i = 0; i < routingCtlArray.length; ++i) {
                routingCtlArray[i].remove();
            }
        }

        protected void updateOutputChain() {
            this.outputType = this.getServiceType(null);
            this.outputTypeLabel.setText(ParsecTools.getServiceTypeText(this.outputType));
            this.updateOutputTypeVisible();
            int n = this.outputType < 0 ? -1 : this.outputType & 0xFF;
            SetupProvider setupProvider = this.feedPanel.getSetupProvider();
            ServiceList[] serviceListArray = setupProvider.getServiceLists(n);
            this.patchCombo.setPatchOptions(serviceListArray);
            for (RoutingCtl routingCtl : this.children) {
                routingCtl.updateProcessingOptions();
            }
        }

        public RoutingCtl(final WFeedPanel wFeedPanel, final MediaSource.Routing routing) {
            this.feedPanel = wFeedPanel;
            this.routing = routing;
            this.outputTypeLabel = WFeedPanel.createServiceTypeLabel();
            this.outputTypeLabel.setBorder(new EmptyBorder(1, 10, 0, 0));
            this.outputTypeLabel.setVisible(false);
            this.patchCombo = new UPatchCombo();
            this.patchCombo.setOpaque(false);
            if (routing.plugins.size() == 0 && routing.patch != null) {
                if (routing.patch.length() != 0) {
                    this.patchCombo.setSelectedItem(routing.patch);
                } else {
                    this.patchCombo.setSelectedItem("");
                }
            } else {
                this.patchCombo.setSelectedItem(null);
            }
            this.patchCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object;
                    routing.patch = RoutingCtl.this.patchCombo.getSelectedIndex() == 0 ? "" : ((object = RoutingCtl.this.patchCombo.getSelectedItem()) == null ? null : object.toString());
                    if (WFRoutingPanel.this.isDisplayable()) {
                        wFeedPanel.getSetupProvider().setUnsavedWork();
                    }
                }
            });
            this.pluginListPanel = new WFPluginListPanel(wFeedPanel, this);
            this.dspAddButton = new JButton("DSP");
            this.dspAddButton.setOpaque(false);
            this.dspAddButton.setMargin(new Insets(0, 4, 0, 4));
            this.dspAddButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RoutingCtl.this.pluginListPanel.addNewPlugin();
                    RoutingCtl.this.updateState();
                }
            });
            ImageIcon imageIcon = null;
            try {
                InputStream inputStream = this.getClass().getResourceAsStream("/icons/trash-button.png");
                imageIcon = new ImageIcon(ImageIO.read(inputStream));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.dspRemoveButton = imageIcon != null ? new JButton(imageIcon) : new JButton("T");
            this.dspRemoveButton.setOpaque(false);
            this.dspRemoveButton.setMargin(new Insets(0, 2, 0, 2));
            this.dspRemoveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RoutingCtl.this.remove();
                }
            });
        }

        public void updateState() {
            this.updateOutputTypeVisible();
            if (this.routing.plugins.size() == 0) {
                this.pluginListPanel.setVisible(false);
                if (this.routing.patch == null) {
                    this.patchCombo.setEnabled(false);
                } else {
                    this.patchCombo.setEnabled(this.routing.enabled);
                }
            } else {
                this.pluginListPanel.setVisible(this.routing.enabled);
                this.patchCombo.setEnabled(false);
            }
            this.dspAddButton.setEnabled(this.routing.enabled);
            this.dspRemoveButton.setEnabled(this.routing.enabled);
        }

        public void setWorkLock(boolean bl) {
            for (RoutingCtl routingCtl : this.children) {
                routingCtl.setWorkLock(bl);
            }
            if (bl) {
                this.patchCombo.setEnabled(false);
                this.dspAddButton.setEnabled(false);
                this.dspRemoveButton.setEnabled(false);
            } else {
                this.updateState();
            }
        }

        public void updateProcessingOptions() {
            this.updateOutputChain();
        }
    }
}

