/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.pplx;

import dexlogic.parsec.MediaSource;
import dexlogic.parsec.config.SetupProvider;
import dexlogic.parsec.pplx.FeedSetupEvent;
import dexlogic.parsec.pplx.FeedSetupListener;
import dexlogic.parsec.pplx.WFJackListPanel;
import dexlogic.parsec.pplx.WFPluginListPanel;
import dexlogic.parsec.pplx.WFRoutingPanel;
import dexlogic.parsec.pplx.WFTrunkListPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;

public class WFeedPanel
extends JPanel {
    private SetupProvider setupProvider;
    private WFTrunkListPanel trunkListPanel;
    private EventListenerList setupListenerList = new EventListenerList();
    MediaSource mediaSource;
    public static final int STYPE_FLAG_CHANGED_COPY = 4096;
    public static final int STYPE_FLAG_CHANGED_FORK = 8192;

    private void addPlugins(WFRoutingPanel.RoutingCtl routingCtl, MediaSource.Routing routing) {
        for (MediaSource.Plugin plugin : routing.plugins) {
            WFPluginListPanel.PluginCtl pluginCtl = routingCtl.pluginListPanel.addPlugin(plugin);
            this.addPlugins(pluginCtl, plugin.routing);
        }
    }

    private void buildUI() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(8, 8, 8, 8));
        this.trunkListPanel = new WFTrunkListPanel(this);
        this.add((Component)this.trunkListPanel, "North");
        for (MediaSource.Trunk trunk : this.mediaSource.getFeed().trunks) {
            WFJackListPanel wFJackListPanel = this.trunkListPanel.addTrunk(trunk);
            for (MediaSource.Jack jack : trunk.jacks) {
                WFJackListPanel.JackCtl jackCtl = wFJackListPanel.addJack(this.trunkListPanel, jack);
                this.addPlugins(jackCtl, jack.routing);
                jackCtl.updateProcessingOptions();
            }
        }
    }

    void fireMediaSource(FeedSetupEvent feedSetupEvent) {
        Object[] objectArray = this.setupListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != FeedSetupListener.class) continue;
            ((FeedSetupListener)objectArray[i + 1]).mediaSourceChanged(feedSetupEvent);
        }
    }

    public WFeedPanel(SetupProvider setupProvider, MediaSource mediaSource) {
        this.setupProvider = setupProvider;
        this.mediaSource = mediaSource;
        this.buildUI();
    }

    public SetupProvider getSetupProvider() {
        return this.setupProvider;
    }

    public void discard() {
        this.trunkListPanel.discard();
    }

    public void setWorkLock(boolean bl) {
        this.trunkListPanel.setWorkLock(bl);
    }

    public void addSetupListener(FeedSetupListener feedSetupListener) {
        this.setupListenerList.add(FeedSetupListener.class, feedSetupListener);
    }

    public void removeSetupListener(FeedSetupListener feedSetupListener) {
        this.setupListenerList.remove(FeedSetupListener.class, feedSetupListener);
    }

    static JLabel createServiceTypeLabel() {
        JLabel jLabel = new JLabel();
        jLabel.setOpaque(false);
        Font font = jLabel.getFont();
        jLabel.setFont(new Font("SansSerif", 2, font.getSize() - 1));
        jLabel.setForeground(new Color(128, 128, 192));
        return jLabel;
    }

    static Color brighter(Color color, double d) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color.getAlpha();
        int n5 = (int)(1.0 / (1.0 - d));
        if (n == 0 && n2 == 0 && n3 == 0) {
            return new Color(n5, n5, n5, n4);
        }
        if (n > 0 && n < n5) {
            n = n5;
        }
        if (n2 > 0 && n2 < n5) {
            n2 = n5;
        }
        if (n3 > 0 && n3 < n5) {
            n3 = n5;
        }
        return new Color(Math.min((int)((double)n / d), 255), Math.min((int)((double)n2 / d), 255), Math.min((int)((double)n3 / d), 255), n4);
    }

    static Color darker(Color color, double d) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = color.getAlpha();
        return new Color(Math.max((int)((double)n * d), 0), Math.max((int)((double)n2 * d), 0), Math.max((int)((double)n3 * d), 0), n4);
    }
}

