/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.pplx;

import dexlogic.parsec.pplx.PlaylistModel;
import dexlogic.parsec.pplx.PopupEvent;
import dexlogic.parsec.pplx.PopupListener;
import dexlogic.parsec.pplx.TablePopupEvent;
import dexlogic.parsec.pplx.WPPLXRootPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

class WPlaylistTable
extends JTable {
    private EventListenerList listenerList = new EventListenerList();

    private void firePopup(PopupEvent popupEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PopupListener.class) continue;
            ((PopupListener)objectArray[i + 1]).popupInvoked(popupEvent);
        }
    }

    public WPlaylistTable(PlaylistModel playlistModel) {
        super(playlistModel);
        this.setFillsViewportHeight(true);
        this.setShowHorizontalLines(false);
        this.setShowVerticalLines(false);
        this.setSelectionMode(0);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setRowHeight(20);
        TableCellRenderer tableCellRenderer = new DefaultTableCellRenderer(){
            TableCellRenderer headerRenderer;
            Font plainFont;
            Font boldFont;
            HeaderBorder headerBorder;
            EmptyBorder cellBorder;

            public TableCellRenderer init(TableCellRenderer tableCellRenderer) {
                this.headerRenderer = tableCellRenderer;
                this.plainFont = new Font("Helvetica", 0, 12);
                this.boldFont = new Font("Helvetica", 1, 12);
                this.cellBorder = new EmptyBorder(3, 7, 3, 7);
                return this;
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Object object2;
                JLabel jLabel;
                if (n == -1) {
                    jLabel = (JLabel)this.headerRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (this.headerBorder == null) {
                        object2 = jLabel.getBorder().getBorderInsets(jLabel);
                        Insets insets = this.cellBorder.getBorderInsets();
                        this.headerBorder = new HeaderBorder();
                        this.headerBorder.setInsideBorder(new EmptyBorder(insets.top, insets.left - ((Insets)object2).left, insets.bottom, insets.right - ((Insets)object2).right));
                    }
                    if ((object2 = jLabel.getBorder()) != this.headerBorder) {
                        this.headerBorder.setOutsideBorder((Border)object2);
                        jLabel.setBorder(this.headerBorder);
                    }
                } else {
                    jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    jLabel.setBorder(this.cellBorder);
                }
                object2 = (PlaylistModel)jTable.getModel();
                if (((PlaylistModel)object2).isMarked(n)) {
                    jLabel.setFont(this.boldFont);
                } else {
                    jLabel.setFont(this.plainFont);
                }
                if (n2 == 3) {
                    jLabel.setHorizontalAlignment(4);
                } else {
                    jLabel.setHorizontalAlignment(2);
                }
                return jLabel;
            }

            class HeaderBorder
            extends CompoundBorder {
                HeaderBorder() {
                }

                public void setInsideBorder(Border border) {
                    this.insideBorder = border;
                }

                public void setOutsideBorder(Border border) {
                    this.outsideBorder = border;
                }
            }
        }.init(this.getTableHeader().getDefaultRenderer());
        this.setDefaultRenderer(String.class, tableCellRenderer);
        this.getTableHeader().setDefaultRenderer(tableCellRenderer);
        this.getTableHeader().setReorderingAllowed(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Point point;
                if (!(mouseEvent.getSource() instanceof JTable)) {
                    return;
                }
                JTable jTable = (JTable)mouseEvent.getSource();
                int n = jTable.rowAtPoint(point = mouseEvent.getPoint());
                if (n < 0) {
                    jTable.clearSelection();
                }
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    if (n >= 0) {
                        jTable.setRowSelectionInterval(n, n);
                    }
                    WPlaylistTable.this.firePopup(new TablePopupEvent(jTable, mouseEvent.getX(), mouseEvent.getY(), n));
                }
            }
        });
        this.setDragEnabled(true);
        this.setDropMode(DropMode.INSERT_ROWS);
        this.setTransferHandler(new TransferHandler(){
            private final DataFlavor transferFlavor = new DataFlavor(Integer.class, "");

            private boolean handleImport(TransferHandler.TransferSupport transferSupport, boolean bl) {
                Object object;
                if (transferSupport.getComponent() != WPlaylistTable.this || !transferSupport.isDrop() || !transferSupport.isDataFlavorSupported(this.transferFlavor)) {
                    return false;
                }
                int n = -1;
                try {
                    object = transferSupport.getTransferable().getTransferData(this.transferFlavor);
                    n = (Integer)object;
                }
                catch (Exception exception) {
                    return false;
                }
                object = (JTable.DropLocation)transferSupport.getDropLocation();
                int n2 = ((JTable.DropLocation)object).getRow();
                int n3 = WPlaylistTable.this.getModel().getRowCount();
                if (n < 0 || n >= n3) {
                    return false;
                }
                if (n2 < 0 || n2 > n3) {
                    return false;
                }
                TableModel tableModel = WPlaylistTable.this.getModel();
                if (!(tableModel instanceof PlaylistModel)) {
                    return false;
                }
                PlaylistModel playlistModel = (PlaylistModel)tableModel;
                if (bl) {
                    return true;
                }
                playlistModel.reorder(n, n2);
                Container container = SwingUtilities.getAncestorOfClass(WPPLXRootPane.class, WPlaylistTable.this);
                if (container != null) {
                    ((WPPLXRootPane)container).setUnsavedWork();
                } else {
                    System.out.println("WPlaylistTable: Can't find root pane");
                }
                int n4 = n2 <= n ? n2 : n2 - 1;
                WPlaylistTable.this.setRowSelectionInterval(n4, n4);
                return true;
            }

            @Override
            public int getSourceActions(JComponent jComponent) {
                if (jComponent != WPlaylistTable.this) {
                    return 0;
                }
                return 2;
            }

            @Override
            protected Transferable createTransferable(JComponent jComponent) {
                if (jComponent != WPlaylistTable.this) {
                    return null;
                }
                int n = WPlaylistTable.this.getSelectedRow();
                if (n < 0) {
                    return null;
                }
                return new RowTransfer(n, this.transferFlavor);
            }

            @Override
            public boolean canImport(TransferHandler.TransferSupport transferSupport) {
                return this.handleImport(transferSupport, true);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport transferSupport) {
                return this.handleImport(transferSupport, false);
            }
        });
    }

    public void addPopupListener(PopupListener popupListener) {
        this.listenerList.add(PopupListener.class, popupListener);
    }

    public void removePopupListener(PopupListener popupListener) {
        this.listenerList.remove(PopupListener.class, popupListener);
    }

    static class RowTransfer
    implements Transferable {
        Integer row;
        DataFlavor dataFlavor;
        DataFlavor[] dataFlavors;

        public RowTransfer(Integer n, DataFlavor dataFlavor) {
            this.row = n;
            this.dataFlavor = dataFlavor;
            this.dataFlavors = new DataFlavor[]{dataFlavor};
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) {
            if (dataFlavor == this.dataFlavor) {
                return this.row;
            }
            return null;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.dataFlavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor == this.dataFlavor;
        }
    }
}

