/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.remote;

import dexlogic.parsec.remote.DRCArg;
import dexlogic.parsec.remote.DRCArgException;
import dexlogic.parsec.remote.DRCArray;
import dexlogic.parsec.remote.DRCObject;

public class DRCJob {
    private String methodName;
    private DRCObject params;

    DRCJob(DRCObject dRCObject) throws DRCArgException {
        Object v = dRCObject.get("jsonrpc");
        if (v == null || !(v instanceof String) || !v.equals("2.0")) {
            throw new DRCArgException("Invalid JSON-RPC header");
        }
        Object v2 = dRCObject.get("method");
        if (v2 == null || !(v2 instanceof String)) {
            throw new DRCArgException("Invalid JSON-RPC method object");
        }
        this.methodName = (String)v2;
        Object v3 = dRCObject.get("params");
        if (v3 != null && !(v3 instanceof DRCObject) && !(v3 instanceof DRCArray)) {
            throw new DRCArgException("Invalid JSON-RPC params object");
        }
        this.params = (DRCObject)v3;
    }

    void toString(StringBuilder stringBuilder, String string) {
        stringBuilder.append(string).append("{\n");
        String string2 = string + "  ";
        stringBuilder.append(string2).append("\"jsonrpc\": \"").append("2.0").append("\",\n");
        stringBuilder.append(string2).append("\"method\": \"").append(this.methodName).append("\",\n");
        stringBuilder.append(string2).append("\"params\":\n");
        DRCArg.writeJSONObject(stringBuilder, string2, this.params);
        stringBuilder.append(string).append("}");
    }

    public DRCJob(String string, DRCObject dRCObject) {
        this.methodName = string;
        this.params = dRCObject;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public DRCObject getParams() {
        return this.params;
    }

    public String getStringParam(String string) {
        if (this.params == null) {
            return null;
        }
        return this.params.getString(string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder, "");
        return stringBuilder.toString();
    }
}

