/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.remote;

import dexlogic.parsec.remote.DRCArg;
import dexlogic.parsec.remote.DRCBatch;
import dexlogic.parsec.remote.DRCJob;
import dexlogic.parsec.remote.WAlertLabel;
import dexlogic.parsec.routes.RPCInvokeAdapter;
import dexlogic.parsec.routes.RPCInvokeBroker;
import dexlogic.parsec.routes.RPCInvokeEvent;

public class WAlertIndicator
extends WAlertLabel {
    private RPCInvokeBroker rpcInvokeBroker;
    private String alertMessage;
    private AlertAdapter alertAdapter;
    private boolean alertAdapterActive;

    protected void alertInvoked(DRCJob dRCJob) {
        String string = dRCJob.getStringParam("info");
        this.showAlert(string);
    }

    public WAlertIndicator(RPCInvokeBroker rPCInvokeBroker, int n) {
        super(n);
        this.rpcInvokeBroker = rPCInvokeBroker;
        this.alertAdapter = new AlertAdapter();
    }

    public WAlertIndicator(RPCInvokeBroker rPCInvokeBroker) {
        this(rPCInvokeBroker, 0);
    }

    @Override
    public void addNotify() {
        if (this.rpcInvokeBroker != null) {
            this.rpcInvokeBroker.addRPCInvokeAdapter(this.alertAdapter);
            this.alertAdapterActive = true;
        }
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.rpcInvokeBroker != null && this.alertAdapterActive) {
            this.rpcInvokeBroker.removeRPCInvokeAdapter(this.alertAdapter);
            this.alertAdapterActive = false;
        }
    }

    class AlertAdapter
    extends RPCInvokeAdapter {
        public AlertAdapter() {
            super(61440);
        }

        @Override
        public void rpcInvoked(RPCInvokeEvent rPCInvokeEvent) {
            DRCBatch dRCBatch = null;
            try {
                dRCBatch = DRCArg.parse(rPCInvokeEvent.getRPCArg());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (dRCBatch != null) {
                for (DRCJob dRCJob : dRCBatch) {
                    String string = dRCJob.getMethodName();
                    if (string == null || !string.equals("alert")) continue;
                    WAlertIndicator.this.alertInvoked(dRCJob);
                }
            }
        }
    }
}

