/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.remote;

import dexlogic.parsec.remote.ObjectRemotable;
import dexlogic.parsec.remote.WAlertIndicator;
import dexlogic.parsec.remote.WFilterDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.border.EmptyBorder;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WTransformDialog
extends WFilterDialog {
    private boolean scalingLinked = true;
    private boolean mirrorX = false;
    private boolean mirrorY = false;
    private double scalingX = 1.0;
    private double scalingY = 1.0;
    private double translationX = 0.0;
    private double translationY = 0.0;
    private double rotation = 0.0;
    private boolean linkedScaleAdjust = false;
    private double linkedScaleX = 0.0;
    private double linkedScaleY = 0.0;
    private JLabel scalingLabelX;
    private JLabel scalingLabelY;
    private JScrollBar scalingBarX;
    private JScrollBar scalingBarY;
    private JLabel translationLabelX;
    private JLabel translationLabelY;
    private JLabel rotationLabel;
    private WAlertIndicator alertIndicator;

    private void readFilterArgs() {
        Object object;
        JSONObject jSONObject;
        Object object2;
        try {
            object2 = this.getRemotable().getRPCArg();
            jSONObject = new JSONObject((String)(object2 == null ? "" : object2));
        }
        catch (Throwable throwable) {
            jSONObject = new JSONObject();
        }
        try {
            String string;
            object = jSONObject.getString("jsonrpc");
            if (!((String)object).equals("2.0")) {
                new JSONException("");
            }
            if (!(string = jSONObject.getString("method")).equals("update")) {
                new JSONException("");
            }
            object2 = jSONObject.getJSONObject("params");
        }
        catch (Throwable throwable) {
            object2 = new JSONObject();
        }
        try {
            object = ((JSONObject)object2).getJSONArray("mirror");
            this.mirrorX = ((JSONArray)object).getBoolean(0);
            this.mirrorY = ((JSONArray)object).getBoolean(1);
        }
        catch (Throwable throwable) {
            this.mirrorX = false;
            this.mirrorY = false;
        }
        try {
            object = ((JSONObject)object2).getJSONArray("scaling");
            this.scalingX = ((JSONArray)object).getDouble(0);
            this.scalingY = ((JSONArray)object).getDouble(1);
        }
        catch (Throwable throwable) {
            this.scalingX = 1.0;
            this.scalingY = 1.0;
        }
        try {
            object = ((JSONObject)object2).getJSONArray("translation");
            this.translationX = ((JSONArray)object).getDouble(0);
            this.translationY = ((JSONArray)object).getDouble(1);
        }
        catch (Throwable throwable) {
            this.translationX = 0.0;
            this.translationY = 0.0;
        }
        try {
            object = ((JSONObject)object2).getJSONArray("rotation");
            this.rotation = ((JSONArray)object).getDouble(0);
        }
        catch (Throwable throwable) {
            this.rotation = 0.0;
        }
    }

    private void updateFilterArgs() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\n");
        stringBuilder.append("  \"jsonrpc\": \"2.0\",\n");
        stringBuilder.append("  \"method\": \"update\",\n");
        stringBuilder.append("  \"params\":\n");
        stringBuilder.append("  {\n");
        stringBuilder.append("    \"mirror\": [").append(this.mirrorX).append(", ").append(this.mirrorY).append("],\n");
        stringBuilder.append("    \"scaling\": [").append(this.scalingX).append(", ").append(this.scalingY).append("],\n");
        stringBuilder.append("    \"translation\": [").append(this.translationX).append(", ").append(this.translationY).append("],\n");
        stringBuilder.append("    \"rotation\": [").append(this.rotation).append("]\n");
        stringBuilder.append("  }\n");
        stringBuilder.append("}");
        this.getRemotable().updateRPCArg(stringBuilder.toString());
    }

    private JComponent buildGroupHeading(String string, JComponent jComponent) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(string), "West");
        if (jComponent != null) {
            jPanel.add((Component)jComponent, "East");
        }
        return jPanel;
    }

    private JComponent buildEntryUI() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        Dimension dimension = new Dimension(100, 10);
        JCheckBox jCheckBox = new JCheckBox("X Mirror", this.mirrorX);
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WTransformDialog.this.mirrorX = ((JCheckBox)actionEvent.getSource()).isSelected();
                WTransformDialog.this.updateFilterArgs();
            }
        });
        JCheckBox jCheckBox2 = new JCheckBox("Y Mirror", this.mirrorY);
        jCheckBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WTransformDialog.this.mirrorY = ((JCheckBox)actionEvent.getSource()).isSelected();
                WTransformDialog.this.updateFilterArgs();
            }
        });
        JCheckBox jCheckBox3 = new JCheckBox("Linked", this.scalingLinked);
        int n = 10;
        this.scalingBarX = new JScrollBar(0, 100, n, 10, 300 + n);
        this.scalingBarY = new JScrollBar(0, 100, n, 10, 300 + n);
        this.scalingBarX.setValue((int)(this.scalingX * 100.0 + 0.5));
        this.scalingBarY.setValue((int)(this.scalingY * 100.0 + 0.5));
        this.scalingLabelX = new WLabel(Integer.toString(this.scalingBarX.getValue()) + "%", "999%");
        this.scalingLabelY = new WLabel(Integer.toString(this.scalingBarY.getValue()) + "%", "999%");
        this.linkedScaleX = (double)this.scalingBarX.getValue() / 100.0;
        this.linkedScaleY = (double)this.scalingBarY.getValue() / 100.0;
        this.scalingBarX.setPreferredSize(dimension);
        this.scalingBarY.setPreferredSize(dimension);
        jCheckBox3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ((JCheckBox)actionEvent.getSource()).isSelected();
                if (!WTransformDialog.this.scalingLinked && bl) {
                    WTransformDialog.this.linkedScaleX = (double)WTransformDialog.this.scalingBarX.getValue() / 100.0;
                    WTransformDialog.this.linkedScaleY = (double)WTransformDialog.this.scalingBarY.getValue() / 100.0;
                }
                WTransformDialog.this.scalingLinked = bl;
            }
        });
        this.scalingBarX.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                WTransformDialog.this.scalingX = (double)adjustmentEvent.getValue() / 100.0;
                WTransformDialog.this.scalingLabelX.setText(Integer.toString(adjustmentEvent.getValue()) + "%");
                if (!WTransformDialog.this.linkedScaleAdjust) {
                    if (WTransformDialog.this.scalingLinked) {
                        double d = WTransformDialog.this.linkedScaleY * (WTransformDialog.this.scalingX / WTransformDialog.this.linkedScaleX);
                        WTransformDialog.this.linkedScaleAdjust = true;
                        WTransformDialog.this.scalingBarY.setValue((int)(d * 100.0 + 0.5));
                        WTransformDialog.this.linkedScaleAdjust = false;
                    }
                    WTransformDialog.this.updateFilterArgs();
                }
            }
        });
        this.scalingBarY.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                WTransformDialog.this.scalingY = (double)adjustmentEvent.getValue() / 100.0;
                WTransformDialog.this.scalingLabelY.setText(Integer.toString(adjustmentEvent.getValue()) + "%");
                if (!WTransformDialog.this.linkedScaleAdjust) {
                    if (WTransformDialog.this.scalingLinked) {
                        double d = WTransformDialog.this.linkedScaleX * (WTransformDialog.this.scalingY / WTransformDialog.this.linkedScaleY);
                        WTransformDialog.this.linkedScaleAdjust = true;
                        WTransformDialog.this.scalingBarX.setValue((int)(d * 100.0 + 0.5));
                        WTransformDialog.this.linkedScaleAdjust = false;
                    }
                    WTransformDialog.this.updateFilterArgs();
                }
            }
        });
        int n2 = 5;
        JScrollBar jScrollBar = new JScrollBar(0, 0, n2, -80, 80 + n2);
        JScrollBar jScrollBar2 = new JScrollBar(0, 0, n2, -80, 80 + n2);
        jScrollBar.setValue((int)(this.translationX * 100.0 + 0.5));
        jScrollBar2.setValue((int)(this.translationY * 100.0 + 0.5));
        this.translationLabelX = new WLabel(Integer.toString(jScrollBar.getValue()), "999");
        this.translationLabelY = new WLabel(Integer.toString(jScrollBar2.getValue()), "999");
        jScrollBar.setPreferredSize(dimension);
        jScrollBar2.setPreferredSize(dimension);
        jScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                WTransformDialog.this.translationX = (double)adjustmentEvent.getValue() / 100.0;
                WTransformDialog.this.translationLabelX.setText(Integer.toString(adjustmentEvent.getValue()));
                WTransformDialog.this.updateFilterArgs();
            }
        });
        jScrollBar2.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                WTransformDialog.this.translationY = (double)adjustmentEvent.getValue() / 100.0;
                WTransformDialog.this.translationLabelY.setText(Integer.toString(adjustmentEvent.getValue()));
                WTransformDialog.this.updateFilterArgs();
            }
        });
        int n3 = 15;
        JScrollBar jScrollBar3 = new JScrollBar(0, 0, n3, -180, 180 + n3);
        jScrollBar3.setValue((int)(this.rotation + 0.5));
        this.rotationLabel = new WLabel(Integer.toString(jScrollBar3.getValue()), "-999");
        jScrollBar3.setPreferredSize(dimension);
        jScrollBar3.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                WTransformDialog.this.rotation = adjustmentEvent.getValue();
                WTransformDialog.this.rotationLabel.setText(Integer.toString(adjustmentEvent.getValue()));
                WTransformDialog.this.updateFilterArgs();
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        int n4 = 0;
        int n5 = 12;
        int n6 = 3;
        int n7 = 6;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n4++;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n4++;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jCheckBox2, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n4++;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(n5, 0, 0, 0);
        jPanel.add((Component)this.buildGroupHeading("Scaling", jCheckBox3), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n4;
        gridBagConstraints.insets = new Insets(n6, 0, 0, 0);
        jPanel.add((Component)new JLabel("X"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(n6, n7, 0, 0);
        jPanel.add((Component)this.scalingBarX, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n4++;
        gridBagConstraints.insets = new Insets(n6, n7, 0, 0);
        jPanel.add((Component)this.scalingLabelX, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n4;
        gridBagConstraints.insets = new Insets(n6, 0, 0, 0);
        jPanel.add((Component)new JLabel("Y"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(n6, n7, 0, 0);
        jPanel.add((Component)this.scalingBarY, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n4++;
        gridBagConstraints.insets = new Insets(n6, n7, 0, 0);
        jPanel.add((Component)this.scalingLabelY, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n4++;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(n5, 0, 0, 0);
        jPanel.add((Component)this.buildGroupHeading("Translation", null), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n4;
        gridBagConstraints.insets = new Insets(n6, 0, 0, 0);
        jPanel.add((Component)new JLabel("X"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(n6, n7, 0, 0);
        jPanel.add((Component)jScrollBar, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n4++;
        gridBagConstraints.insets = new Insets(n6, n7, 0, 0);
        jPanel.add((Component)this.translationLabelX, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n4;
        gridBagConstraints.insets = new Insets(n6, 0, 0, 0);
        jPanel.add((Component)new JLabel("Y"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(n6, n7, 0, 0);
        jPanel.add((Component)jScrollBar2, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n4++;
        gridBagConstraints.insets = new Insets(n6, n7, 0, 0);
        jPanel.add((Component)this.translationLabelY, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n4++;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(n5, 0, 0, 0);
        jPanel.add((Component)this.buildGroupHeading("Rotation", null), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(n6, 0, 0, 0);
        jPanel.add((Component)jScrollBar3, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n4++;
        gridBagConstraints.insets = new Insets(n6, n7, 0, 0);
        jPanel.add((Component)this.rotationLabel, gridBagConstraints);
        this.alertIndicator = new WAlertIndicator(this.getRemotable(), 1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n4++;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(n5, 0, 0, 0);
        jPanel.add((Component)this.alertIndicator, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        return jPanel;
    }

    private void buildUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(8, 8, 8, 8));
        jPanel.add((Component)this.buildEntryUI(), "Center");
        this.setContentPane(jPanel);
    }

    public WTransformDialog(Window window, String string, ObjectRemotable objectRemotable) {
        super(window, string + " - Transform", objectRemotable);
        this.readFilterArgs();
        this.buildUI();
    }

    private static class WLabel
    extends JLabel {
        private String maxText;
        private Dimension minSize;

        public WLabel(String string, String string2) {
            super(string);
            this.maxText = string2;
        }

        @Override
        public Dimension getMinimumSize() {
            if (this.minSize == null) {
                Insets insets = this.getInsets(null);
                Font font = this.getFont();
                FontMetrics fontMetrics = this.getFontMetrics(font);
                int n = insets.left + fontMetrics.stringWidth(this.maxText) + insets.right;
                int n2 = insets.top + fontMetrics.getHeight() + insets.bottom;
                this.minSize = new Dimension(n, n2);
            }
            return this.minSize;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }
    }
}

