/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.routes;

import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.routes.FlowManager;
import dexlogic.parsec.routes.LocalObjectAgent;
import dexlogic.parsec.routes.RPCInvokeAdapter;
import dexlogic.parsec.routes.RPCInvokeHandler;
import dexlogic.parsec.routes.RemoteCallEvent;
import dexlogic.parsec.routes.RemoteObjectProxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class FlowGraph {
    private FlowManager flowManager;
    private String xmlString;
    private ArrayList<ObjectGateway> objectGatewayList = new ArrayList();
    private HashMap<RPCInvokeAdapter, RPCInvokeHandler[]> rpcHandlerMap = new HashMap();
    long graphHandle = 0L;

    FlowGraph(FlowManager flowManager) {
        this.flowManager = flowManager;
    }

    String getXML() {
        return this.xmlString;
    }

    int getNextPluginServiceNum() {
        return this.flowManager.getNextPluginServiceNum();
    }

    int getNextObjectNum() {
        return this.flowManager.getNextObjectNum();
    }

    void addObjectGateway(int n, LocalObjectAgent localObjectAgent) {
        this.objectGatewayList.add(new ObjectGateway(n, localObjectAgent));
    }

    Iterator<ObjectGateway> getObjectGatewayIterator() {
        return this.objectGatewayList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterator<RPCInvokeHandler> getInvokeHandlerIterator() {
        ArrayList<RPCInvokeHandler> arrayList = new ArrayList<RPCInvokeHandler>();
        HashMap<RPCInvokeAdapter, RPCInvokeHandler[]> hashMap = this.rpcHandlerMap;
        synchronized (hashMap) {
            for (RPCInvokeHandler[] rPCInvokeHandlerArray : this.rpcHandlerMap.values()) {
                for (int i = 0; i < rPCInvokeHandlerArray.length; ++i) {
                    arrayList.add(rPCInvokeHandlerArray[i]);
                }
            }
        }
        return arrayList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addInvokeHandler(RPCInvokeAdapter rPCInvokeAdapter, RPCInvokeHandler rPCInvokeHandler) {
        HashMap<RPCInvokeAdapter, RPCInvokeHandler[]> hashMap = this.rpcHandlerMap;
        synchronized (hashMap) {
            RPCInvokeHandler[] rPCInvokeHandlerArray = this.rpcHandlerMap.get(rPCInvokeAdapter);
            rPCInvokeHandlerArray = ParsecTools.arrayAdd(RPCInvokeHandler.class, rPCInvokeHandlerArray, rPCInvokeHandler);
            this.rpcHandlerMap.put(rPCInvokeAdapter, rPCInvokeHandlerArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RPCInvokeHandler removeInvokeHandler(RPCInvokeAdapter rPCInvokeAdapter) {
        RPCInvokeHandler rPCInvokeHandler = null;
        HashMap<RPCInvokeAdapter, RPCInvokeHandler[]> hashMap = this.rpcHandlerMap;
        synchronized (hashMap) {
            RPCInvokeHandler[] rPCInvokeHandlerArray = this.rpcHandlerMap.get(rPCInvokeAdapter);
            if (rPCInvokeHandlerArray == null) {
                return null;
            }
            rPCInvokeHandler = rPCInvokeHandlerArray[0];
            if ((rPCInvokeHandlerArray = ParsecTools.arrayRemoveFirst(rPCInvokeHandlerArray)) == null) {
                this.rpcHandlerMap.remove(rPCInvokeAdapter);
            } else {
                this.rpcHandlerMap.put(rPCInvokeAdapter, rPCInvokeHandlerArray);
            }
        }
        return rPCInvokeHandler;
    }

    void remoteCallIssued(int n, RemoteCallEvent remoteCallEvent) throws ParsecException {
        if (this.flowManager.hasEntity()) {
            this.flowManager.remotePost(n, remoteCallEvent.getRPCArg());
        }
    }

    RPCInvokeHandler createRPCInvokeHandler(int n, RPCInvokeAdapter rPCInvokeAdapter) {
        return this.flowManager.createRPCInvokeHandler(n, rPCInvokeAdapter);
    }

    void addRPCInvokeAdapter(int n, RPCInvokeAdapter rPCInvokeAdapter) {
        if (rPCInvokeAdapter.selector == null || !(rPCInvokeAdapter.selector instanceof String || rPCInvokeAdapter.selector instanceof Integer)) {
            throw new IllegalArgumentException("Selector must be a String or Integer object");
        }
        RPCInvokeHandler rPCInvokeHandler = this.createRPCInvokeHandler(n, rPCInvokeAdapter);
        this.addInvokeHandler(rPCInvokeAdapter, rPCInvokeHandler);
        this.flowManager.addDispatchHandler(rPCInvokeHandler);
        if (rPCInvokeAdapter.selector instanceof String) {
            // empty if block
        }
    }

    void removeRPCInvokeAdapter(int n, RPCInvokeAdapter rPCInvokeAdapter) {
        RPCInvokeHandler rPCInvokeHandler = this.removeInvokeHandler(rPCInvokeAdapter);
        if (rPCInvokeHandler == null) {
            throw new IllegalArgumentException("RPC invoke adapter not found");
        }
        this.flowManager.removeDispatchHandler(rPCInvokeHandler);
        if (rPCInvokeAdapter.selector instanceof String) {
            // empty if block
        }
    }

    public void setXML(String string) {
        this.xmlString = string;
    }

    class ObjectGateway
    implements RemoteObjectProxy {
        int objID;
        LocalObjectAgent objectAgent;

        ObjectGateway(int n, LocalObjectAgent localObjectAgent) {
            this.objID = n;
            this.objectAgent = localObjectAgent;
        }

        void attach() {
            this.objectAgent.addRemoteObjectProxy(this);
        }

        void detach() {
            this.objectAgent.removeRemoteObjectProxy(this);
        }

        public void remoteCallIssued(RemoteCallEvent remoteCallEvent) throws ParsecException {
            FlowGraph.this.remoteCallIssued(this.objID, remoteCallEvent);
        }

        @Override
        public void addRPCInvokeAdapter(RPCInvokeAdapter rPCInvokeAdapter) {
            FlowGraph.this.addRPCInvokeAdapter(this.objID, rPCInvokeAdapter);
        }

        @Override
        public void removeRPCInvokeAdapter(RPCInvokeAdapter rPCInvokeAdapter) {
            FlowGraph.this.removeRPCInvokeAdapter(this.objID, rPCInvokeAdapter);
        }
    }
}

