/*
 * Decompiled with CFR 0.152.
 */
package dexlogic.parsec.routes;

import dexlogic.dxc.DXCException;
import dexlogic.dxc.DXCListener;
import dexlogic.dxc.DXCManager;
import dexlogic.parsec.InternalParsecException;
import dexlogic.parsec.ParsecException;
import dexlogic.parsec.ParsecTools;
import dexlogic.parsec.routes.DXCLogEvent;
import dexlogic.parsec.routes.FlowEvent;
import dexlogic.parsec.routes.FlowEventListener;
import dexlogic.parsec.routes.FlowLogger;
import dexlogic.parsec.routes.FlowProxy;
import dexlogic.parsec.routes.FlowProxyBuilder;
import dexlogic.parsec.routes.FlowProxyEditor;
import dexlogic.parsec.routes.ProxyStateHandler;
import dexlogic.parsec.routes.RPCInvokeAdapter;
import dexlogic.parsec.routes.RPCInvokeBroker;
import dexlogic.parsec.routes.RPCInvokeEvent;
import dexlogic.parsec.routes.RPCInvokeHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.SwingUtilities;

public class FlowManager
implements FlowLogger,
RPCInvokeBroker {
    private FlowEventListener eventListener;
    private int runState;
    private DXCManager dxcManager;
    private IDDNotificationThread notificationThread;
    private HashMap<Integer, RPCInvokeHandler[]> rpcDispatchMap = new HashMap();
    private int objectNum;
    private int subscriberNum;
    private ArrayList<FlowProxy> proxyList = new ArrayList();
    private static final int STATE_VOID = 0;
    private static final int STATE_STOP = 1;
    private static final int STATE_PAUSE = 2;
    private static final int STATE_PRELOAD = 3;
    private static final int STATE_PLAY = 4;

    private String buildTraceDetails(DXCException dXCException, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ParsecTools.getTraceDetails(dXCException));
        if (stringBuilder.length() != 0) {
            stringBuilder.append("\n\n");
        }
        stringBuilder.append(dXCException.getTraceDetails());
        if (string != null) {
            stringBuilder.append("\n\n");
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private Integer createDispatcherKey(int n, int n2) {
        if ((n & 0xC000) == 32768) {
            return n << 16 | 0;
        }
        return n << 16 | n2;
    }

    int getNextObjectNum() {
        int n = this.objectNum++;
        return n;
    }

    RPCInvokeHandler createRPCInvokeHandler(int n, RPCInvokeAdapter rPCInvokeAdapter) {
        if (rPCInvokeAdapter.selector == null) {
            throw new IllegalArgumentException("RPC invoke adapter has no selector");
        }
        int n2 = 0;
        if (rPCInvokeAdapter.selector instanceof String) {
            int n3 = this.subscriberNum++;
            n2 = 0x8000 | n3;
        } else if (rPCInvokeAdapter.selector instanceof Integer) {
            n2 = (Integer)rPCInvokeAdapter.selector;
        } else {
            throw new IllegalArgumentException("Could not create a dispatch handler for " + rPCInvokeAdapter.selector.getClass().toString());
        }
        return new RPCInvokeHandler(n, n2, rPCInvokeAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDispatchHandler(RPCInvokeHandler rPCInvokeHandler) {
        Integer n = this.createDispatcherKey(rPCInvokeHandler.lsnID, rPCInvokeHandler.objID);
        HashMap<Integer, RPCInvokeHandler[]> hashMap = this.rpcDispatchMap;
        synchronized (hashMap) {
            RPCInvokeHandler[] rPCInvokeHandlerArray = this.rpcDispatchMap.get(n);
            rPCInvokeHandlerArray = ParsecTools.arrayAdd(RPCInvokeHandler.class, rPCInvokeHandlerArray, rPCInvokeHandler);
            this.rpcDispatchMap.put(n, rPCInvokeHandlerArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeDispatchHandler(Integer n) {
        RPCInvokeHandler rPCInvokeHandler = null;
        HashMap<Integer, RPCInvokeHandler[]> hashMap = this.rpcDispatchMap;
        synchronized (hashMap) {
            RPCInvokeHandler[] rPCInvokeHandlerArray = this.rpcDispatchMap.get(n);
            if (rPCInvokeHandlerArray == null) {
                return false;
            }
            rPCInvokeHandler = rPCInvokeHandlerArray[0];
            if ((rPCInvokeHandlerArray = ParsecTools.arrayRemoveFirst(rPCInvokeHandlerArray)) == null) {
                this.rpcDispatchMap.remove(n);
            } else {
                this.rpcDispatchMap.put(n, rPCInvokeHandlerArray);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeDispatchHandler(RPCInvokeHandler rPCInvokeHandler) {
        Integer n = this.createDispatcherKey(rPCInvokeHandler.lsnID, rPCInvokeHandler.objID);
        HashMap<Integer, RPCInvokeHandler[]> hashMap = this.rpcDispatchMap;
        synchronized (hashMap) {
            RPCInvokeHandler[] rPCInvokeHandlerArray = this.rpcDispatchMap.get(n);
            if (rPCInvokeHandlerArray == null) {
                return false;
            }
            if ((rPCInvokeHandlerArray = ParsecTools.arrayRemove(rPCInvokeHandlerArray, rPCInvokeHandler)) == null) {
                this.rpcDispatchMap.remove(n);
            } else {
                this.rpcDispatchMap.put(n, rPCInvokeHandlerArray);
            }
        }
        return true;
    }

    void fireLogListenerEvent(DXCLogEvent dXCLogEvent) {
        if (this.eventListener != null) {
            this.eventListener.flowLogPosted(dXCLogEvent);
        } else {
            System.out.println(dXCLogEvent.getString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchRPCInvokeEvent(RPCInvokeEvent rPCInvokeEvent) {
        int n;
        RPCInvokeHandler[] rPCInvokeHandlerArray;
        Integer n2;
        HashMap<Integer, RPCInvokeHandler[]> hashMap;
        int n3 = rPCInvokeEvent.getReceiverRLA();
        int n4 = rPCInvokeEvent.getSenderRLA();
        if (n4 != 0) {
            hashMap = this.rpcDispatchMap;
            synchronized (hashMap) {
                n2 = n3 << 16 | n4;
                rPCInvokeHandlerArray = this.rpcDispatchMap.get(n2);
                if (rPCInvokeHandlerArray != null) {
                    for (n = 0; n < rPCInvokeHandlerArray.length; ++n) {
                        rPCInvokeHandlerArray[n].dispatch(rPCInvokeEvent);
                    }
                }
            }
        }
        hashMap = this.rpcDispatchMap;
        synchronized (hashMap) {
            n2 = n3 << 16 | 0;
            rPCInvokeHandlerArray = this.rpcDispatchMap.get(n2);
            if (rPCInvokeHandlerArray != null) {
                for (n = 0; n < rPCInvokeHandlerArray.length; ++n) {
                    rPCInvokeHandlerArray[n].dispatch(rPCInvokeEvent);
                }
            }
        }
    }

    public FlowManager() {
        this.runState = 0;
    }

    public FlowManager(FlowEventListener flowEventListener) {
        this.eventListener = flowEventListener;
        this.runState = 0;
    }

    public boolean hasEntity() {
        return this.dxcManager != null;
    }

    public void createEntity() throws ParsecException {
        if (this.dxcManager != null) {
            throw new InternalParsecException("Invalid state, existing DXC manager object");
        }
        DXCManager dXCManager = null;
        Thread thread = null;
        try {
            dXCManager = new DXCManager(0x20000FF);
            thread = new IDDNotificationThread(dXCManager);
            thread.start();
            this.dxcManager = dXCManager;
            dXCManager = null;
            this.notificationThread = thread;
            thread = null;
            this.runState = 1;
        }
        catch (Throwable throwable) {
            if (throwable instanceof DXCException) {
                String string = ((DXCException)throwable).getDXCMessage();
                InternalParsecException internalParsecException = new InternalParsecException(string);
                throw internalParsecException.setDetails(this.buildTraceDetails((DXCException)throwable, null));
            }
            String string = throwable.getMessage();
            InternalParsecException internalParsecException = new InternalParsecException();
            throw internalParsecException.setDetails(ParsecTools.getTraceDetails(throwable));
        }
        finally {
            if (dXCManager != null) {
                dXCManager.reset();
            }
            if (thread != null) {
                try {
                    thread.interrupt();
                    thread.join();
                }
                catch (InterruptedException interruptedException) {}
                ((IDDNotificationThread)thread).discardEvents();
            }
            if (dXCManager != null) {
                dXCManager.close();
            }
        }
        this.objectNum = 10;
        this.subscriberNum = 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyEntity() {
        Iterator<Object> iterator;
        if (this.dxcManager == null) {
            return;
        }
        for (FlowProxy flowProxy : this.proxyList) {
            iterator = flowProxy.getObjectGatewayIterator();
            while (iterator.hasNext()) {
                iterator.next().detach();
            }
            if (this.runState <= 1) continue;
            iterator = flowProxy.getStateHandlerIterator();
            while (iterator.hasNext()) {
                ((ProxyStateHandler)iterator.next()).processStopping(this);
            }
        }
        this.runState = 0;
        try {
            this.dxcManager.reset();
            try {
                this.notificationThread.interrupt();
                this.notificationThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.notificationThread.flushEvents();
            this.dxcManager.close();
            this.dxcManager = null;
            this.notificationThread = null;
        }
        catch (Throwable throwable) {
            this.dxcManager = null;
            this.notificationThread = null;
            for (FlowProxy flowProxy : this.proxyList) {
                Iterator<RPCInvokeHandler> iterator2 = flowProxy.getInvokeHandlerIterator();
                while (iterator2.hasNext()) {
                    this.removeDispatchHandler(iterator2.next());
                }
            }
            this.proxyList.clear();
            throw throwable;
        }
        for (FlowProxy flowProxy : this.proxyList) {
            iterator = flowProxy.getInvokeHandlerIterator();
            while (iterator.hasNext()) {
                this.removeDispatchHandler((RPCInvokeHandler)iterator.next());
            }
        }
        this.proxyList.clear();
    }

    public FlowProxy loadProxy(FlowProxyBuilder flowProxyBuilder) throws ParsecException {
        if (this.dxcManager == null) {
            throw new InternalParsecException("Invalid state, no DXC manager object");
        }
        if (flowProxyBuilder == null) {
            return null;
        }
        FlowProxy flowProxy = new FlowProxy(this);
        FlowProxyEditor flowProxyEditor = new FlowProxyEditor(flowProxy, this);
        flowProxyBuilder.buildFlowProxy(flowProxyEditor);
        flowProxyEditor.reset();
        String string = flowProxy.getXML();
        if (string == null) {
            return null;
        }
        if ((string = string.trim().replaceAll("\n+", "\n")) == null || string.length() == 0) {
            return null;
        }
        DXCLogEvent dXCLogEvent = new DXCLogEvent(this, "::loadSetup::\n" + string + "\n");
        this.fireLogListenerEvent(dXCLogEvent);
        Iterator<Object> iterator = flowProxy.getInvokeHandlerIterator();
        while (iterator.hasNext()) {
            this.addDispatchHandler(iterator.next());
        }
        try {
            flowProxy.graphHandle = this.dxcManager.buildFromXML(string);
        }
        catch (Throwable throwable) {
            Object object = flowProxy.getInvokeHandlerIterator();
            while (object.hasNext()) {
                this.removeDispatchHandler(object.next());
            }
            if (throwable instanceof DXCException) {
                object = ((DXCException)throwable).getDXCMessage();
                InternalParsecException internalParsecException = new InternalParsecException((String)object);
                throw internalParsecException.setDetails(this.buildTraceDetails((DXCException)throwable, string));
            }
            object = throwable.getMessage();
            InternalParsecException internalParsecException = new InternalParsecException();
            throw internalParsecException.setDetails(ParsecTools.getTraceDetails(throwable));
        }
        iterator = flowProxy.getObjectGatewayIterator();
        while (iterator.hasNext()) {
            ((FlowProxy.ObjectGateway)iterator.next()).attach();
        }
        this.proxyList.add(flowProxy);
        return flowProxy;
    }

    public FlowProxy loadProxy(String string) throws ParsecException {
        if (this.dxcManager == null) {
            throw new InternalParsecException("Invalid state, no DXC manager object");
        }
        if (string == null) {
            return null;
        }
        if ((string = string.trim().replaceAll("\n+", "\n")) == null || string.length() == 0) {
            return null;
        }
        DXCLogEvent dXCLogEvent = new DXCLogEvent(this, "::loadSetup::\n" + string + "\n");
        this.fireLogListenerEvent(dXCLogEvent);
        FlowProxy flowProxy = new FlowProxy(this);
        try {
            flowProxy.graphHandle = this.dxcManager.buildFromXML(string);
        }
        catch (Throwable throwable) {
            if (throwable instanceof DXCException) {
                String string2 = ((DXCException)throwable).getDXCMessage();
                InternalParsecException internalParsecException = new InternalParsecException(string2);
                throw internalParsecException.setDetails(this.buildTraceDetails((DXCException)throwable, string));
            }
            String string3 = throwable.getMessage();
            InternalParsecException internalParsecException = new InternalParsecException();
            throw internalParsecException.setDetails(ParsecTools.getTraceDetails(throwable));
        }
        this.proxyList.add(flowProxy);
        return flowProxy;
    }

    public String remotePost(int n, String string) throws ParsecException {
        if (this.dxcManager == null) {
            throw new InternalParsecException("Invalid state, no DXC manager object");
        }
        try {
            return this.dxcManager.remotePost(n, string);
        }
        catch (DXCException dXCException) {
            InternalParsecException internalParsecException = new InternalParsecException(dXCException.getDXCMessage());
            throw internalParsecException.setDetails(this.buildTraceDetails(dXCException, null));
        }
    }

    public void play(String string) throws ParsecException {
        if (this.dxcManager == null) {
            throw new InternalParsecException("Invalid state, no DXC manager object");
        }
        try {
            this.dxcManager.play(string);
        }
        catch (DXCException dXCException) {
            InternalParsecException internalParsecException = new InternalParsecException(dXCException.getDXCMessage());
            throw internalParsecException.setDetails(this.buildTraceDetails(dXCException, null));
        }
        if (this.runState <= 1) {
            for (FlowProxy flowProxy : this.proxyList) {
                Iterator<ProxyStateHandler> iterator = flowProxy.getStateHandlerIterator();
                while (iterator.hasNext()) {
                    iterator.next().processStarted(this);
                }
            }
        }
        this.runState = 4;
    }

    public void pause(String string) throws ParsecException {
        if (this.dxcManager == null) {
            throw new InternalParsecException("Invalid state, no DXC manager object");
        }
        try {
            this.dxcManager.pause(string);
        }
        catch (DXCException dXCException) {
            InternalParsecException internalParsecException = new InternalParsecException(dXCException.getDXCMessage());
            throw internalParsecException.setDetails(this.buildTraceDetails(dXCException, null));
        }
        if (this.runState <= 1) {
            for (FlowProxy flowProxy : this.proxyList) {
                Iterator<ProxyStateHandler> iterator = flowProxy.getStateHandlerIterator();
                while (iterator.hasNext()) {
                    iterator.next().processStarted(this);
                }
            }
        }
        this.runState = 2;
    }

    public void preload(String string) throws ParsecException {
        if (this.dxcManager == null) {
            throw new InternalParsecException("Invalid state, no DXC manager object");
        }
        try {
            this.dxcManager.preload(string);
        }
        catch (DXCException dXCException) {
            InternalParsecException internalParsecException = new InternalParsecException(dXCException.getDXCMessage());
            throw internalParsecException.setDetails(this.buildTraceDetails(dXCException, null));
        }
        if (this.runState <= 1) {
            for (FlowProxy flowProxy : this.proxyList) {
                Iterator<ProxyStateHandler> iterator = flowProxy.getStateHandlerIterator();
                while (iterator.hasNext()) {
                    iterator.next().processStarted(this);
                }
            }
        }
        this.runState = 3;
    }

    public void seek(int n, String string) throws ParsecException {
        if (this.dxcManager == null) {
            throw new InternalParsecException("Invalid state, no DXC manager object");
        }
        try {
            this.dxcManager.seek(n, string);
        }
        catch (DXCException dXCException) {
            InternalParsecException internalParsecException = new InternalParsecException(dXCException.getDXCMessage());
            throw internalParsecException.setDetails(this.buildTraceDetails(dXCException, null));
        }
    }

    public void stop(String string) throws ParsecException {
        if (this.dxcManager == null) {
            throw new InternalParsecException("Invalid state, no DXC manager object");
        }
        if (this.runState > 1) {
            for (FlowProxy flowProxy : this.proxyList) {
                Iterator<ProxyStateHandler> iterator = flowProxy.getStateHandlerIterator();
                while (iterator.hasNext()) {
                    iterator.next().processStopping(this);
                }
            }
        }
        this.runState = 1;
        this.dxcManager.idle(string);
    }

    @Override
    public void logInfo(String string) {
        try {
            this.remotePost(65281, string);
        }
        catch (ParsecException parsecException) {
            System.out.println(string);
        }
    }

    @Override
    public void addRPCInvokeAdapter(RPCInvokeAdapter rPCInvokeAdapter) {
        if (rPCInvokeAdapter.selector == null || !(rPCInvokeAdapter.selector instanceof Integer)) {
            throw new IllegalArgumentException("Selector must be an Integer object");
        }
        RPCInvokeHandler rPCInvokeHandler = this.createRPCInvokeHandler(0, rPCInvokeAdapter);
        this.addDispatchHandler(rPCInvokeHandler);
    }

    @Override
    public void removeRPCInvokeAdapter(RPCInvokeAdapter rPCInvokeAdapter) {
        if (rPCInvokeAdapter.selector == null || !(rPCInvokeAdapter.selector instanceof Integer)) {
            throw new IllegalArgumentException("Selector must be an Integer object");
        }
        Integer n = this.createDispatcherKey((Integer)rPCInvokeAdapter.selector, 0);
        if (!this.removeDispatchHandler(n)) {
            throw new IllegalArgumentException("RPC invoke adapter not found");
        }
    }

    class IDDNotificationThread
    extends Thread
    implements DXCListener {
        private DXCManager dxcManager;
        private Object dispatchSync = new Object();
        private FlowEvent firstEvent = null;
        private FlowEvent lastEvent = null;

        private synchronized boolean addLastEvent(FlowEvent flowEvent) {
            boolean bl;
            boolean bl2 = bl = this.firstEvent == null;
            if (this.firstEvent == null) {
                this.firstEvent = this.lastEvent = flowEvent;
            } else {
                this.lastEvent = this.lastEvent.nextEvent = flowEvent;
            }
            return bl;
        }

        private synchronized FlowEvent removeFirstEvent() {
            FlowEvent flowEvent = this.firstEvent;
            if (this.firstEvent != null) {
                if (this.firstEvent == this.lastEvent) {
                    this.lastEvent = null;
                    this.firstEvent = null;
                } else {
                    this.firstEvent = this.firstEvent.nextEvent;
                }
            }
            return flowEvent;
        }

        public IDDNotificationThread(DXCManager dXCManager) {
            this.dxcManager = dXCManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean runDispatch() {
            boolean bl;
            Object object = this.dispatchSync;
            synchronized (object) {
                bl = this.dxcManager.runDispatch(this, null);
            }
            return bl;
        }

        public void discardEvents() {
            FlowEvent flowEvent;
            while ((flowEvent = this.removeFirstEvent()) != null) {
            }
        }

        public void flushEvents() {
            FlowEvent flowEvent;
            while ((flowEvent = this.removeFirstEvent()) != null) {
                if (flowEvent instanceof DXCLogEvent) {
                    FlowManager.this.fireLogListenerEvent((DXCLogEvent)flowEvent);
                    continue;
                }
                if (!(flowEvent instanceof RPCInvokeEvent)) continue;
                FlowManager.this.dispatchRPCInvokeEvent((RPCInvokeEvent)flowEvent);
            }
        }

        @Override
        public void run() {
            try {
                while (true) {
                    if (this.runDispatch()) {
                        Thread.sleep(5L);
                        continue;
                    }
                    Thread.sleep(20L);
                }
            }
            catch (InterruptedException interruptedException) {
                this.runDispatch();
                return;
            }
        }

        @Override
        public void ntfDispatch(Object object, int n, int n2, String string) {
            string = string.trim();
            if ((n & 0xC000) == 32768 || (n & 0xF800) == 61440) {
                RPCInvokeEvent rPCInvokeEvent = new RPCInvokeEvent(FlowManager.this, n, n2, string);
                if (this.addLastEvent(rPCInvokeEvent)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            IDDNotificationThread.this.flushEvents();
                        }
                    });
                }
            } else if ((n & 0xFF80) == 65280) {
                byte by = (byte)(n & 0xF);
                DXCLogEvent dXCLogEvent = new DXCLogEvent(FlowManager.this, string);
                if (this.addLastEvent(dXCLogEvent)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            IDDNotificationThread.this.flushEvents();
                        }
                    });
                }
            } else {
                System.out.println("ntfDispatch: Discarded notification to recvRLA=0x" + Integer.toHexString(n));
            }
        }
    }
}

